/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.BuyerTaxInfo;

@Schema(description="Buyer information.")
public class BuyerInfo {
    @SerializedName(value="BuyerEmail")
    private String buyerEmail = null;
    @SerializedName(value="BuyerName")
    private String buyerName = null;
    @SerializedName(value="BuyerCounty")
    private String buyerCounty = null;
    @SerializedName(value="BuyerTaxInfo")
    private BuyerTaxInfo buyerTaxInfo = null;
    @SerializedName(value="PurchaseOrderNumber")
    private String purchaseOrderNumber = null;

    public BuyerInfo buyerEmail(String buyerEmail) {
        this.buyerEmail = buyerEmail;
        return this;
    }

    @Schema(description="The anonymized email address of the buyer.")
    public String getBuyerEmail() {
        return this.buyerEmail;
    }

    public void setBuyerEmail(String buyerEmail) {
        this.buyerEmail = buyerEmail;
    }

    public BuyerInfo buyerName(String buyerName) {
        this.buyerName = buyerName;
        return this;
    }

    @Schema(description="The buyer name or the recipient name.")
    public String getBuyerName() {
        return this.buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public BuyerInfo buyerCounty(String buyerCounty) {
        this.buyerCounty = buyerCounty;
        return this;
    }

    @Schema(description="The county of the buyer.  **Note**: This attribute is only available in the Brazil marketplace.")
    public String getBuyerCounty() {
        return this.buyerCounty;
    }

    public void setBuyerCounty(String buyerCounty) {
        this.buyerCounty = buyerCounty;
    }

    public BuyerInfo buyerTaxInfo(BuyerTaxInfo buyerTaxInfo) {
        this.buyerTaxInfo = buyerTaxInfo;
        return this;
    }

    @Schema(description="")
    public BuyerTaxInfo getBuyerTaxInfo() {
        return this.buyerTaxInfo;
    }

    public void setBuyerTaxInfo(BuyerTaxInfo buyerTaxInfo) {
        this.buyerTaxInfo = buyerTaxInfo;
    }

    public BuyerInfo purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(description="The purchase order (PO) number entered by the buyer at checkout. Only returned for orders where the buyer entered a PO number at checkout.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuyerInfo buyerInfo = (BuyerInfo)o;
        return Objects.equals(this.buyerEmail, buyerInfo.buyerEmail) && Objects.equals(this.buyerName, buyerInfo.buyerName) && Objects.equals(this.buyerCounty, buyerInfo.buyerCounty) && Objects.equals(this.buyerTaxInfo, buyerInfo.buyerTaxInfo) && Objects.equals(this.purchaseOrderNumber, buyerInfo.purchaseOrderNumber);
    }

    public int hashCode() {
        return Objects.hash(this.buyerEmail, this.buyerName, this.buyerCounty, this.buyerTaxInfo, this.purchaseOrderNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuyerInfo {\n");
        sb.append("    buyerEmail: ").append(this.toIndentedString(this.buyerEmail)).append("\n");
        sb.append("    buyerName: ").append(this.toIndentedString(this.buyerName)).append("\n");
        sb.append("    buyerCounty: ").append(this.toIndentedString(this.buyerCounty)).append("\n");
        sb.append("    buyerTaxInfo: ").append(this.toIndentedString(this.buyerTaxInfo)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

