/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.AssociationType;

@Schema(description="An item that is associated with an order item. For example, a tire installation service that is purchased with tires.")
public class AssociatedItem {
    @SerializedName(value="OrderId")
    private String orderId = null;
    @SerializedName(value="OrderItemId")
    private String orderItemId = null;
    @SerializedName(value="AssociationType")
    private AssociationType associationType = null;

    public AssociatedItem orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @Schema(description="The order item's order identifier, in 3-7-7 format.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public AssociatedItem orderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
        return this;
    }

    @Schema(description="An Amazon-defined item identifier for the associated item.")
    public String getOrderItemId() {
        return this.orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public AssociatedItem associationType(AssociationType associationType) {
        this.associationType = associationType;
        return this;
    }

    @Schema(description="")
    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(AssociationType associationType) {
        this.associationType = associationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociatedItem associatedItem = (AssociatedItem)o;
        return Objects.equals(this.orderId, associatedItem.orderId) && Objects.equals(this.orderItemId, associatedItem.orderItemId) && Objects.equals((Object)this.associationType, (Object)associatedItem.associationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.orderId, this.orderItemId, this.associationType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssociatedItem {\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    orderItemId: ").append(this.toIndentedString(this.orderItemId)).append("\n");
        sb.append("    associationType: ").append(this.toIndentedString((Object)this.associationType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

