/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The container for address extended fields (such as `street name` and `street number`). Currently only available with Brazil shipping addresses.")
public class AddressExtendedFields {
    @SerializedName(value="StreetName")
    private String streetName = null;
    @SerializedName(value="StreetNumber")
    private String streetNumber = null;
    @SerializedName(value="Complement")
    private String complement = null;
    @SerializedName(value="Neighborhood")
    private String neighborhood = null;

    public AddressExtendedFields streetName(String streetName) {
        this.streetName = streetName;
        return this;
    }

    @Schema(description="The street name.")
    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public AddressExtendedFields streetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
        return this;
    }

    @Schema(description="The house, building, or property number associated with the location's street address.")
    public String getStreetNumber() {
        return this.streetNumber;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public AddressExtendedFields complement(String complement) {
        this.complement = complement;
        return this;
    }

    @Schema(description="The floor number/unit number in the building/private house number.")
    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String complement) {
        this.complement = complement;
    }

    public AddressExtendedFields neighborhood(String neighborhood) {
        this.neighborhood = neighborhood;
        return this;
    }

    @Schema(description="The neighborhood. This value is only used in some countries (such as Brazil).")
    public String getNeighborhood() {
        return this.neighborhood;
    }

    public void setNeighborhood(String neighborhood) {
        this.neighborhood = neighborhood;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressExtendedFields addressExtendedFields = (AddressExtendedFields)o;
        return Objects.equals(this.streetName, addressExtendedFields.streetName) && Objects.equals(this.streetNumber, addressExtendedFields.streetNumber) && Objects.equals(this.complement, addressExtendedFields.complement) && Objects.equals(this.neighborhood, addressExtendedFields.neighborhood);
    }

    public int hashCode() {
        return Objects.hash(this.streetName, this.streetNumber, this.complement, this.neighborhood);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressExtendedFields {\n");
        sb.append("    streetName: ").append(this.toIndentedString(this.streetName)).append("\n");
        sb.append("    streetNumber: ").append(this.toIndentedString(this.streetNumber)).append("\n");
        sb.append("    complement: ").append(this.toIndentedString(this.complement)).append("\n");
        sb.append("    neighborhood: ").append(this.toIndentedString(this.neighborhood)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

