/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.messaging.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.messaging.v1.Attachment;

@Schema(description="The request schema for the `createDigitalAccessKey` operation.")
public class CreateDigitalAccessKeyRequest {
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="attachments")
    private List<Attachment> attachments = null;

    public CreateDigitalAccessKeyRequest text(String text) {
        this.text = text;
        return this;
    }

    @Schema(description="The text that is sent to the buyer. Only links that are related to the digital access key are allowed. Do not include HTML or email addresses. The text must be written in the buyer's preferred language, which you can retrieve from the `GetAttributes` operation.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public CreateDigitalAccessKeyRequest attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public CreateDigitalAccessKeyRequest addAttachmentsItem(Attachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Schema(description="Attachments that you want to include in the message to the buyer.")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateDigitalAccessKeyRequest createDigitalAccessKeyRequest = (CreateDigitalAccessKeyRequest)o;
        return Objects.equals(this.text, createDigitalAccessKeyRequest.text) && Objects.equals(this.attachments, createDigitalAccessKeyRequest.attachments);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.attachments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateDigitalAccessKeyRequest {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

