/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.merchantfulfillment.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.merchantfulfillment.v0.AdjustmentItemList;
import software.amazon.spapi.models.merchantfulfillment.v0.AvailableFormatOptionsForLabelList;
import software.amazon.spapi.models.merchantfulfillment.v0.AvailableShippingServiceOptions;
import software.amazon.spapi.models.merchantfulfillment.v0.Benefits;
import software.amazon.spapi.models.merchantfulfillment.v0.CurrencyAmount;
import software.amazon.spapi.models.merchantfulfillment.v0.LabelFormatList;
import software.amazon.spapi.models.merchantfulfillment.v0.ShippingServiceOptions;

@Schema(description="A shipping service offer made by a carrier.")
public class ShippingService {
    @SerializedName(value="ShippingServiceName")
    private String shippingServiceName = null;
    @SerializedName(value="CarrierName")
    private String carrierName = null;
    @SerializedName(value="ShippingServiceId")
    private String shippingServiceId = null;
    @SerializedName(value="ShippingServiceOfferId")
    private String shippingServiceOfferId = null;
    @SerializedName(value="ShipDate")
    private OffsetDateTime shipDate = null;
    @SerializedName(value="EarliestEstimatedDeliveryDate")
    private OffsetDateTime earliestEstimatedDeliveryDate = null;
    @SerializedName(value="LatestEstimatedDeliveryDate")
    private OffsetDateTime latestEstimatedDeliveryDate = null;
    @SerializedName(value="Rate")
    private CurrencyAmount rate = null;
    @SerializedName(value="RateWithAdjustments")
    private CurrencyAmount rateWithAdjustments = null;
    @SerializedName(value="AdjustmentItemList")
    private AdjustmentItemList adjustmentItemList = null;
    @SerializedName(value="ShippingServiceOptions")
    private ShippingServiceOptions shippingServiceOptions = null;
    @SerializedName(value="AvailableShippingServiceOptions")
    private AvailableShippingServiceOptions availableShippingServiceOptions = null;
    @SerializedName(value="AvailableLabelFormats")
    private LabelFormatList availableLabelFormats = null;
    @SerializedName(value="AvailableFormatOptionsForLabel")
    private AvailableFormatOptionsForLabelList availableFormatOptionsForLabel = null;
    @SerializedName(value="RequiresAdditionalSellerInputs")
    private Boolean requiresAdditionalSellerInputs = null;
    @SerializedName(value="Benefits")
    private Benefits benefits = null;

    public ShippingService shippingServiceName(String shippingServiceName) {
        this.shippingServiceName = shippingServiceName;
        return this;
    }

    @Schema(required=true, description="A plain text representation of a carrier's shipping service. For example, \"UPS Ground\" or \"FedEx Standard Overnight\". ")
    public String getShippingServiceName() {
        return this.shippingServiceName;
    }

    public void setShippingServiceName(String shippingServiceName) {
        this.shippingServiceName = shippingServiceName;
    }

    public ShippingService carrierName(String carrierName) {
        this.carrierName = carrierName;
        return this;
    }

    @Schema(required=true, description="The name of the carrier.")
    public String getCarrierName() {
        return this.carrierName;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public ShippingService shippingServiceId(String shippingServiceId) {
        this.shippingServiceId = shippingServiceId;
        return this;
    }

    @Schema(required=true, description="")
    public String getShippingServiceId() {
        return this.shippingServiceId;
    }

    public void setShippingServiceId(String shippingServiceId) {
        this.shippingServiceId = shippingServiceId;
    }

    public ShippingService shippingServiceOfferId(String shippingServiceOfferId) {
        this.shippingServiceOfferId = shippingServiceOfferId;
        return this;
    }

    @Schema(required=true, description="An Amazon-defined shipping service offer identifier.")
    public String getShippingServiceOfferId() {
        return this.shippingServiceOfferId;
    }

    public void setShippingServiceOfferId(String shippingServiceOfferId) {
        this.shippingServiceOfferId = shippingServiceOfferId;
    }

    public ShippingService shipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
        return this;
    }

    @Schema(required=true, description="")
    public OffsetDateTime getShipDate() {
        return this.shipDate;
    }

    public void setShipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
    }

    public ShippingService earliestEstimatedDeliveryDate(OffsetDateTime earliestEstimatedDeliveryDate) {
        this.earliestEstimatedDeliveryDate = earliestEstimatedDeliveryDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getEarliestEstimatedDeliveryDate() {
        return this.earliestEstimatedDeliveryDate;
    }

    public void setEarliestEstimatedDeliveryDate(OffsetDateTime earliestEstimatedDeliveryDate) {
        this.earliestEstimatedDeliveryDate = earliestEstimatedDeliveryDate;
    }

    public ShippingService latestEstimatedDeliveryDate(OffsetDateTime latestEstimatedDeliveryDate) {
        this.latestEstimatedDeliveryDate = latestEstimatedDeliveryDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getLatestEstimatedDeliveryDate() {
        return this.latestEstimatedDeliveryDate;
    }

    public void setLatestEstimatedDeliveryDate(OffsetDateTime latestEstimatedDeliveryDate) {
        this.latestEstimatedDeliveryDate = latestEstimatedDeliveryDate;
    }

    public ShippingService rate(CurrencyAmount rate) {
        this.rate = rate;
        return this;
    }

    @Schema(required=true, description="")
    public CurrencyAmount getRate() {
        return this.rate;
    }

    public void setRate(CurrencyAmount rate) {
        this.rate = rate;
    }

    public ShippingService rateWithAdjustments(CurrencyAmount rateWithAdjustments) {
        this.rateWithAdjustments = rateWithAdjustments;
        return this;
    }

    @Schema(required=true, description="")
    public CurrencyAmount getRateWithAdjustments() {
        return this.rateWithAdjustments;
    }

    public void setRateWithAdjustments(CurrencyAmount rateWithAdjustments) {
        this.rateWithAdjustments = rateWithAdjustments;
    }

    public ShippingService adjustmentItemList(AdjustmentItemList adjustmentItemList) {
        this.adjustmentItemList = adjustmentItemList;
        return this;
    }

    @Schema(description="")
    public AdjustmentItemList getAdjustmentItemList() {
        return this.adjustmentItemList;
    }

    public void setAdjustmentItemList(AdjustmentItemList adjustmentItemList) {
        this.adjustmentItemList = adjustmentItemList;
    }

    public ShippingService shippingServiceOptions(ShippingServiceOptions shippingServiceOptions) {
        this.shippingServiceOptions = shippingServiceOptions;
        return this;
    }

    @Schema(required=true, description="")
    public ShippingServiceOptions getShippingServiceOptions() {
        return this.shippingServiceOptions;
    }

    public void setShippingServiceOptions(ShippingServiceOptions shippingServiceOptions) {
        this.shippingServiceOptions = shippingServiceOptions;
    }

    public ShippingService availableShippingServiceOptions(AvailableShippingServiceOptions availableShippingServiceOptions) {
        this.availableShippingServiceOptions = availableShippingServiceOptions;
        return this;
    }

    @Schema(description="")
    public AvailableShippingServiceOptions getAvailableShippingServiceOptions() {
        return this.availableShippingServiceOptions;
    }

    public void setAvailableShippingServiceOptions(AvailableShippingServiceOptions availableShippingServiceOptions) {
        this.availableShippingServiceOptions = availableShippingServiceOptions;
    }

    public ShippingService availableLabelFormats(LabelFormatList availableLabelFormats) {
        this.availableLabelFormats = availableLabelFormats;
        return this;
    }

    @Schema(description="")
    public LabelFormatList getAvailableLabelFormats() {
        return this.availableLabelFormats;
    }

    public void setAvailableLabelFormats(LabelFormatList availableLabelFormats) {
        this.availableLabelFormats = availableLabelFormats;
    }

    public ShippingService availableFormatOptionsForLabel(AvailableFormatOptionsForLabelList availableFormatOptionsForLabel) {
        this.availableFormatOptionsForLabel = availableFormatOptionsForLabel;
        return this;
    }

    @Schema(description="")
    public AvailableFormatOptionsForLabelList getAvailableFormatOptionsForLabel() {
        return this.availableFormatOptionsForLabel;
    }

    public void setAvailableFormatOptionsForLabel(AvailableFormatOptionsForLabelList availableFormatOptionsForLabel) {
        this.availableFormatOptionsForLabel = availableFormatOptionsForLabel;
    }

    public ShippingService requiresAdditionalSellerInputs(Boolean requiresAdditionalSellerInputs) {
        this.requiresAdditionalSellerInputs = requiresAdditionalSellerInputs;
        return this;
    }

    @Schema(required=true, description="When true, additional seller inputs are required.")
    public Boolean isRequiresAdditionalSellerInputs() {
        return this.requiresAdditionalSellerInputs;
    }

    public void setRequiresAdditionalSellerInputs(Boolean requiresAdditionalSellerInputs) {
        this.requiresAdditionalSellerInputs = requiresAdditionalSellerInputs;
    }

    public ShippingService benefits(Benefits benefits) {
        this.benefits = benefits;
        return this;
    }

    @Schema(description="")
    public Benefits getBenefits() {
        return this.benefits;
    }

    public void setBenefits(Benefits benefits) {
        this.benefits = benefits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShippingService shippingService = (ShippingService)o;
        return Objects.equals(this.shippingServiceName, shippingService.shippingServiceName) && Objects.equals(this.carrierName, shippingService.carrierName) && Objects.equals(this.shippingServiceId, shippingService.shippingServiceId) && Objects.equals(this.shippingServiceOfferId, shippingService.shippingServiceOfferId) && Objects.equals(this.shipDate, shippingService.shipDate) && Objects.equals(this.earliestEstimatedDeliveryDate, shippingService.earliestEstimatedDeliveryDate) && Objects.equals(this.latestEstimatedDeliveryDate, shippingService.latestEstimatedDeliveryDate) && Objects.equals(this.rate, shippingService.rate) && Objects.equals(this.rateWithAdjustments, shippingService.rateWithAdjustments) && Objects.equals(this.adjustmentItemList, shippingService.adjustmentItemList) && Objects.equals(this.shippingServiceOptions, shippingService.shippingServiceOptions) && Objects.equals(this.availableShippingServiceOptions, shippingService.availableShippingServiceOptions) && Objects.equals(this.availableLabelFormats, shippingService.availableLabelFormats) && Objects.equals(this.availableFormatOptionsForLabel, shippingService.availableFormatOptionsForLabel) && Objects.equals(this.requiresAdditionalSellerInputs, shippingService.requiresAdditionalSellerInputs) && Objects.equals(this.benefits, shippingService.benefits);
    }

    public int hashCode() {
        return Objects.hash(this.shippingServiceName, this.carrierName, this.shippingServiceId, this.shippingServiceOfferId, this.shipDate, this.earliestEstimatedDeliveryDate, this.latestEstimatedDeliveryDate, this.rate, this.rateWithAdjustments, this.adjustmentItemList, this.shippingServiceOptions, this.availableShippingServiceOptions, this.availableLabelFormats, this.availableFormatOptionsForLabel, this.requiresAdditionalSellerInputs, this.benefits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShippingService {\n");
        sb.append("    shippingServiceName: ").append(this.toIndentedString(this.shippingServiceName)).append("\n");
        sb.append("    carrierName: ").append(this.toIndentedString(this.carrierName)).append("\n");
        sb.append("    shippingServiceId: ").append(this.toIndentedString(this.shippingServiceId)).append("\n");
        sb.append("    shippingServiceOfferId: ").append(this.toIndentedString(this.shippingServiceOfferId)).append("\n");
        sb.append("    shipDate: ").append(this.toIndentedString(this.shipDate)).append("\n");
        sb.append("    earliestEstimatedDeliveryDate: ").append(this.toIndentedString(this.earliestEstimatedDeliveryDate)).append("\n");
        sb.append("    latestEstimatedDeliveryDate: ").append(this.toIndentedString(this.latestEstimatedDeliveryDate)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    rateWithAdjustments: ").append(this.toIndentedString(this.rateWithAdjustments)).append("\n");
        sb.append("    adjustmentItemList: ").append(this.toIndentedString(this.adjustmentItemList)).append("\n");
        sb.append("    shippingServiceOptions: ").append(this.toIndentedString(this.shippingServiceOptions)).append("\n");
        sb.append("    availableShippingServiceOptions: ").append(this.toIndentedString(this.availableShippingServiceOptions)).append("\n");
        sb.append("    availableLabelFormats: ").append(this.toIndentedString(this.availableLabelFormats)).append("\n");
        sb.append("    availableFormatOptionsForLabel: ").append(this.toIndentedString(this.availableFormatOptionsForLabel)).append("\n");
        sb.append("    requiresAdditionalSellerInputs: ").append(this.toIndentedString(this.requiresAdditionalSellerInputs)).append("\n");
        sb.append("    benefits: ").append(this.toIndentedString(this.benefits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

