/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.merchantfulfillment.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.merchantfulfillment.v0.AdditionalSellerInput;
import software.amazon.spapi.models.merchantfulfillment.v0.Constraints;
import software.amazon.spapi.models.merchantfulfillment.v0.InputTargetType;
import software.amazon.spapi.models.merchantfulfillment.v0.RestrictedSetValues;

@Schema(description="Specifies characteristics that apply to a seller input.")
public class SellerInputDefinition {
    @SerializedName(value="IsRequired")
    private Boolean isRequired = null;
    @SerializedName(value="DataType")
    private String dataType = null;
    @SerializedName(value="Constraints")
    private Constraints constraints = null;
    @SerializedName(value="InputDisplayText")
    private String inputDisplayText = null;
    @SerializedName(value="InputTarget")
    private InputTargetType inputTarget = null;
    @SerializedName(value="StoredValue")
    private AdditionalSellerInput storedValue = null;
    @SerializedName(value="RestrictedSetValues")
    private RestrictedSetValues restrictedSetValues = null;

    public SellerInputDefinition isRequired(Boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    @Schema(required=true, description="When true, the additional input field is required.")
    public Boolean isIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    public SellerInputDefinition dataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    @Schema(required=true, description="The data type of the additional input field.")
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public SellerInputDefinition constraints(Constraints constraints) {
        this.constraints = constraints;
        return this;
    }

    @Schema(required=true, description="")
    public Constraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Constraints constraints) {
        this.constraints = constraints;
    }

    public SellerInputDefinition inputDisplayText(String inputDisplayText) {
        this.inputDisplayText = inputDisplayText;
        return this;
    }

    @Schema(required=true, description="The display text for the additional input field.")
    public String getInputDisplayText() {
        return this.inputDisplayText;
    }

    public void setInputDisplayText(String inputDisplayText) {
        this.inputDisplayText = inputDisplayText;
    }

    public SellerInputDefinition inputTarget(InputTargetType inputTarget) {
        this.inputTarget = inputTarget;
        return this;
    }

    @Schema(description="")
    public InputTargetType getInputTarget() {
        return this.inputTarget;
    }

    public void setInputTarget(InputTargetType inputTarget) {
        this.inputTarget = inputTarget;
    }

    public SellerInputDefinition storedValue(AdditionalSellerInput storedValue) {
        this.storedValue = storedValue;
        return this;
    }

    @Schema(required=true, description="")
    public AdditionalSellerInput getStoredValue() {
        return this.storedValue;
    }

    public void setStoredValue(AdditionalSellerInput storedValue) {
        this.storedValue = storedValue;
    }

    public SellerInputDefinition restrictedSetValues(RestrictedSetValues restrictedSetValues) {
        this.restrictedSetValues = restrictedSetValues;
        return this;
    }

    @Schema(description="")
    public RestrictedSetValues getRestrictedSetValues() {
        return this.restrictedSetValues;
    }

    public void setRestrictedSetValues(RestrictedSetValues restrictedSetValues) {
        this.restrictedSetValues = restrictedSetValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellerInputDefinition sellerInputDefinition = (SellerInputDefinition)o;
        return Objects.equals(this.isRequired, sellerInputDefinition.isRequired) && Objects.equals(this.dataType, sellerInputDefinition.dataType) && Objects.equals(this.constraints, sellerInputDefinition.constraints) && Objects.equals(this.inputDisplayText, sellerInputDefinition.inputDisplayText) && Objects.equals((Object)this.inputTarget, (Object)sellerInputDefinition.inputTarget) && Objects.equals(this.storedValue, sellerInputDefinition.storedValue) && Objects.equals(this.restrictedSetValues, sellerInputDefinition.restrictedSetValues);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isRequired, this.dataType, this.constraints, this.inputDisplayText, this.inputTarget, this.storedValue, this.restrictedSetValues});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SellerInputDefinition {\n");
        sb.append("    isRequired: ").append(this.toIndentedString(this.isRequired)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString(this.dataType)).append("\n");
        sb.append("    constraints: ").append(this.toIndentedString(this.constraints)).append("\n");
        sb.append("    inputDisplayText: ").append(this.toIndentedString(this.inputDisplayText)).append("\n");
        sb.append("    inputTarget: ").append(this.toIndentedString((Object)this.inputTarget)).append("\n");
        sb.append("    storedValue: ").append(this.toIndentedString(this.storedValue)).append("\n");
        sb.append("    restrictedSetValues: ").append(this.toIndentedString(this.restrictedSetValues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

