/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.merchantfulfillment.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Currency type and amount.")
public class CurrencyAmount {
    @SerializedName(value="CurrencyCode")
    private String currencyCode = null;
    @SerializedName(value="Amount")
    private Double amount = null;

    public CurrencyAmount currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Schema(required=true, description="Three-digit currency code in ISO 4217 format.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public CurrencyAmount amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @Schema(required=true, description="The currency amount.")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrencyAmount currencyAmount = (CurrencyAmount)o;
        return Objects.equals(this.currencyCode, currencyAmount.currencyCode) && Objects.equals(this.amount, currencyAmount.amount);
    }

    public int hashCode() {
        return Objects.hash(this.currencyCode, this.amount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CurrencyAmount {\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

