/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Schema(description="The request body schema for the `putListingsItem` operation.")
public class ListingsItemPutRequest {
    @SerializedName(value="productType")
    private String productType = null;
    @SerializedName(value="requirements")
    private RequirementsEnum requirements = null;
    @SerializedName(value="attributes")
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public ListingsItemPutRequest productType(String productType) {
        this.productType = productType;
        return this;
    }

    @Schema(required=true, description="The Amazon product type of the listings item.")
    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public ListingsItemPutRequest requirements(RequirementsEnum requirements) {
        this.requirements = requirements;
        return this;
    }

    @Schema(description="The name of the requirements set for the provided data.")
    public RequirementsEnum getRequirements() {
        return this.requirements;
    }

    public void setRequirements(RequirementsEnum requirements) {
        this.requirements = requirements;
    }

    public ListingsItemPutRequest attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ListingsItemPutRequest putAttributesItem(String key, Object attributesItem) {
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Schema(required=true, description="A JSON object containing structured listings item attribute data keyed by attribute name.")
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListingsItemPutRequest listingsItemPutRequest = (ListingsItemPutRequest)o;
        return Objects.equals(this.productType, listingsItemPutRequest.productType) && Objects.equals((Object)this.requirements, (Object)listingsItemPutRequest.requirements) && Objects.equals(this.attributes, listingsItemPutRequest.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.productType, this.requirements, this.attributes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListingsItemPutRequest {\n");
        sb.append("    productType: ").append(this.toIndentedString(this.productType)).append("\n");
        sb.append("    requirements: ").append(this.toIndentedString((Object)this.requirements)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RequirementsEnum {
        LISTING("LISTING"),
        LISTING_PRODUCT_ONLY("LISTING_PRODUCT_ONLY"),
        LISTING_OFFER_ONLY("LISTING_OFFER_ONLY");

        private String value;

        private RequirementsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RequirementsEnum fromValue(String input) {
            for (RequirementsEnum b : RequirementsEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RequirementsEnum> {
            public void write(JsonWriter jsonWriter, RequirementsEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public RequirementsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RequirementsEnum.fromValue(value);
            }
        }
    }
}

