/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The enforcement action taken by Amazon that affect the publishing or status of a listing")
public class IssueEnforcementAction {
    @SerializedName(value="action")
    private String action = null;

    public IssueEnforcementAction action(String action) {
        this.action = action;
        return this;
    }

    @Schema(example="LISTING_SUPPRESSED", required=true, description="The enforcement action name.   Possible values:   * `LISTING_SUPPRESSED` - This enforcement takes down the current listing item's buyability.   * `ATTRIBUTE_SUPPRESSED` - An attribute's value on the listing item is invalid, which causes it to be rejected by Amazon.   * `CATALOG_ITEM_REMOVED` - This catalog item is inactive on Amazon, and all offers against it in the applicable marketplace are non-buyable.   * `SEARCH_SUPPRESSED` - This value indicates that the catalog item is hidden from search results.")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueEnforcementAction issueEnforcementAction = (IssueEnforcementAction)o;
        return Objects.equals(this.action, issueEnforcementAction.action);
    }

    public int hashCode() {
        return Objects.hash(this.action);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueEnforcementAction {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

