/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.invoices.v2024_06_19;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.LocalDate;
import software.amazon.spapi.models.invoices.v2024_06_19.FileFormat;
import software.amazon.spapi.models.invoices.v2024_06_19.TransactionIdentifier;

@Schema(description="The information required to create the export request.")
public class ExportInvoicesRequest {
    @SerializedName(value="dateEnd")
    private LocalDate dateEnd = null;
    @SerializedName(value="dateStart")
    private LocalDate dateStart = null;
    @SerializedName(value="externalInvoiceId")
    private String externalInvoiceId = null;
    @SerializedName(value="fileFormat")
    private FileFormat fileFormat = null;
    @SerializedName(value="invoiceType")
    private String invoiceType = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="series")
    private String series = null;
    @SerializedName(value="statuses")
    private List<String> statuses = null;
    @SerializedName(value="transactionIdentifier")
    private TransactionIdentifier transactionIdentifier = null;
    @SerializedName(value="transactionType")
    private String transactionType = null;

    public ExportInvoicesRequest dateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    @Schema(description="The latest invoice creation date for invoices that you want to include in the response. Dates are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format. The default is the time of the request.")
    public LocalDate getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
    }

    public ExportInvoicesRequest dateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @Schema(description="The earliest invoice creation date for invoices that you want to include in the response. Dates are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format. The default is 24 hours prior to the time of the request.")
    public LocalDate getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
    }

    public ExportInvoicesRequest externalInvoiceId(String externalInvoiceId) {
        this.externalInvoiceId = externalInvoiceId;
        return this;
    }

    @Schema(description="The external ID of the invoices you want included in the response.")
    public String getExternalInvoiceId() {
        return this.externalInvoiceId;
    }

    public void setExternalInvoiceId(String externalInvoiceId) {
        this.externalInvoiceId = externalInvoiceId;
    }

    public ExportInvoicesRequest fileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @Schema(description="")
    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public ExportInvoicesRequest invoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
        return this;
    }

    @Schema(description="The marketplace-specific classification of the invoice type. Use the `getInvoicesAttributes` operation to check `invoiceType` options.")
    public String getInvoiceType() {
        return this.invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public ExportInvoicesRequest marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="The ID of the marketplace from which you want the invoices.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ExportInvoicesRequest series(String series) {
        this.series = series;
        return this;
    }

    @Schema(description="The series number of the invoices you want included in the response.")
    public String getSeries() {
        return this.series;
    }

    public void setSeries(String series) {
        this.series = series;
    }

    public ExportInvoicesRequest statuses(List<String> statuses) {
        this.statuses = statuses;
        return this;
    }

    public ExportInvoicesRequest addStatusesItem(String statusesItem) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<String>();
        }
        this.statuses.add(statusesItem);
        return this;
    }

    @Schema(description="A list of statuses that you can use to filter invoices. Use the `getInvoicesAttributes` operation to check invoice status options.  Min count: 1")
    public List<String> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<String> statuses) {
        this.statuses = statuses;
    }

    public ExportInvoicesRequest transactionIdentifier(TransactionIdentifier transactionIdentifier) {
        this.transactionIdentifier = transactionIdentifier;
        return this;
    }

    @Schema(description="")
    public TransactionIdentifier getTransactionIdentifier() {
        return this.transactionIdentifier;
    }

    public void setTransactionIdentifier(TransactionIdentifier transactionIdentifier) {
        this.transactionIdentifier = transactionIdentifier;
    }

    public ExportInvoicesRequest transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(description="The marketplace-specific classification of the transaction type for which the invoice was created. Use the `getInvoicesAttributes` operation to check `transactionType` options")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportInvoicesRequest exportInvoicesRequest = (ExportInvoicesRequest)o;
        return Objects.equals(this.dateEnd, exportInvoicesRequest.dateEnd) && Objects.equals(this.dateStart, exportInvoicesRequest.dateStart) && Objects.equals(this.externalInvoiceId, exportInvoicesRequest.externalInvoiceId) && Objects.equals((Object)this.fileFormat, (Object)exportInvoicesRequest.fileFormat) && Objects.equals(this.invoiceType, exportInvoicesRequest.invoiceType) && Objects.equals(this.marketplaceId, exportInvoicesRequest.marketplaceId) && Objects.equals(this.series, exportInvoicesRequest.series) && Objects.equals(this.statuses, exportInvoicesRequest.statuses) && Objects.equals(this.transactionIdentifier, exportInvoicesRequest.transactionIdentifier) && Objects.equals(this.transactionType, exportInvoicesRequest.transactionType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateEnd, this.dateStart, this.externalInvoiceId, this.fileFormat, this.invoiceType, this.marketplaceId, this.series, this.statuses, this.transactionIdentifier, this.transactionType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExportInvoicesRequest {\n");
        sb.append("    dateEnd: ").append(this.toIndentedString(this.dateEnd)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    externalInvoiceId: ").append(this.toIndentedString(this.externalInvoiceId)).append("\n");
        sb.append("    fileFormat: ").append(this.toIndentedString((Object)this.fileFormat)).append("\n");
        sb.append("    invoiceType: ").append(this.toIndentedString(this.invoiceType)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    statuses: ").append(this.toIndentedString(this.statuses)).append("\n");
        sb.append("    transactionIdentifier: ").append(this.toIndentedString(this.transactionIdentifier)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

