/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.FulfillmentShipmentItemList;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.FulfillmentShipmentPackageList;

@Schema(description="Delivery and item information for a shipment in a fulfillment order.")
public class FulfillmentShipment {
    @SerializedName(value="amazonShipmentId")
    private String amazonShipmentId = null;
    @SerializedName(value="fulfillmentCenterId")
    private String fulfillmentCenterId = null;
    @SerializedName(value="fulfillmentShipmentStatus")
    private FulfillmentShipmentStatusEnum fulfillmentShipmentStatus = null;
    @SerializedName(value="shippingDate")
    private OffsetDateTime shippingDate = null;
    @SerializedName(value="estimatedArrivalDate")
    private OffsetDateTime estimatedArrivalDate = null;
    @SerializedName(value="shippingNotes")
    private List<String> shippingNotes = null;
    @SerializedName(value="fulfillmentShipmentItem")
    private FulfillmentShipmentItemList fulfillmentShipmentItem = null;
    @SerializedName(value="fulfillmentShipmentPackage")
    private FulfillmentShipmentPackageList fulfillmentShipmentPackage = null;

    public FulfillmentShipment amazonShipmentId(String amazonShipmentId) {
        this.amazonShipmentId = amazonShipmentId;
        return this;
    }

    @Schema(required=true, description="A shipment identifier assigned by Amazon.")
    public String getAmazonShipmentId() {
        return this.amazonShipmentId;
    }

    public void setAmazonShipmentId(String amazonShipmentId) {
        this.amazonShipmentId = amazonShipmentId;
    }

    public FulfillmentShipment fulfillmentCenterId(String fulfillmentCenterId) {
        this.fulfillmentCenterId = fulfillmentCenterId;
        return this;
    }

    @Schema(required=true, description="An identifier for the fulfillment center from which the shipment is sent.")
    public String getFulfillmentCenterId() {
        return this.fulfillmentCenterId;
    }

    public void setFulfillmentCenterId(String fulfillmentCenterId) {
        this.fulfillmentCenterId = fulfillmentCenterId;
    }

    public FulfillmentShipment fulfillmentShipmentStatus(FulfillmentShipmentStatusEnum fulfillmentShipmentStatus) {
        this.fulfillmentShipmentStatus = fulfillmentShipmentStatus;
        return this;
    }

    @Schema(required=true, description="The current status of the shipment.")
    public FulfillmentShipmentStatusEnum getFulfillmentShipmentStatus() {
        return this.fulfillmentShipmentStatus;
    }

    public void setFulfillmentShipmentStatus(FulfillmentShipmentStatusEnum fulfillmentShipmentStatus) {
        this.fulfillmentShipmentStatus = fulfillmentShipmentStatus;
    }

    public FulfillmentShipment shippingDate(OffsetDateTime shippingDate) {
        this.shippingDate = shippingDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getShippingDate() {
        return this.shippingDate;
    }

    public void setShippingDate(OffsetDateTime shippingDate) {
        this.shippingDate = shippingDate;
    }

    public FulfillmentShipment estimatedArrivalDate(OffsetDateTime estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getEstimatedArrivalDate() {
        return this.estimatedArrivalDate;
    }

    public void setEstimatedArrivalDate(OffsetDateTime estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
    }

    public FulfillmentShipment shippingNotes(List<String> shippingNotes) {
        this.shippingNotes = shippingNotes;
        return this;
    }

    public FulfillmentShipment addShippingNotesItem(String shippingNotesItem) {
        if (this.shippingNotes == null) {
            this.shippingNotes = new ArrayList<String>();
        }
        this.shippingNotes.add(shippingNotesItem);
        return this;
    }

    @Schema(description="Provides additional insight into shipment timeline. Primarily used to communicate that actual delivery dates aren't available.")
    public List<String> getShippingNotes() {
        return this.shippingNotes;
    }

    public void setShippingNotes(List<String> shippingNotes) {
        this.shippingNotes = shippingNotes;
    }

    public FulfillmentShipment fulfillmentShipmentItem(FulfillmentShipmentItemList fulfillmentShipmentItem) {
        this.fulfillmentShipmentItem = fulfillmentShipmentItem;
        return this;
    }

    @Schema(required=true, description="")
    public FulfillmentShipmentItemList getFulfillmentShipmentItem() {
        return this.fulfillmentShipmentItem;
    }

    public void setFulfillmentShipmentItem(FulfillmentShipmentItemList fulfillmentShipmentItem) {
        this.fulfillmentShipmentItem = fulfillmentShipmentItem;
    }

    public FulfillmentShipment fulfillmentShipmentPackage(FulfillmentShipmentPackageList fulfillmentShipmentPackage) {
        this.fulfillmentShipmentPackage = fulfillmentShipmentPackage;
        return this;
    }

    @Schema(description="")
    public FulfillmentShipmentPackageList getFulfillmentShipmentPackage() {
        return this.fulfillmentShipmentPackage;
    }

    public void setFulfillmentShipmentPackage(FulfillmentShipmentPackageList fulfillmentShipmentPackage) {
        this.fulfillmentShipmentPackage = fulfillmentShipmentPackage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentShipment fulfillmentShipment = (FulfillmentShipment)o;
        return Objects.equals(this.amazonShipmentId, fulfillmentShipment.amazonShipmentId) && Objects.equals(this.fulfillmentCenterId, fulfillmentShipment.fulfillmentCenterId) && Objects.equals((Object)this.fulfillmentShipmentStatus, (Object)fulfillmentShipment.fulfillmentShipmentStatus) && Objects.equals(this.shippingDate, fulfillmentShipment.shippingDate) && Objects.equals(this.estimatedArrivalDate, fulfillmentShipment.estimatedArrivalDate) && Objects.equals(this.shippingNotes, fulfillmentShipment.shippingNotes) && Objects.equals(this.fulfillmentShipmentItem, fulfillmentShipment.fulfillmentShipmentItem) && Objects.equals(this.fulfillmentShipmentPackage, fulfillmentShipment.fulfillmentShipmentPackage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amazonShipmentId, this.fulfillmentCenterId, this.fulfillmentShipmentStatus, this.shippingDate, this.estimatedArrivalDate, this.shippingNotes, this.fulfillmentShipmentItem, this.fulfillmentShipmentPackage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentShipment {\n");
        sb.append("    amazonShipmentId: ").append(this.toIndentedString(this.amazonShipmentId)).append("\n");
        sb.append("    fulfillmentCenterId: ").append(this.toIndentedString(this.fulfillmentCenterId)).append("\n");
        sb.append("    fulfillmentShipmentStatus: ").append(this.toIndentedString((Object)this.fulfillmentShipmentStatus)).append("\n");
        sb.append("    shippingDate: ").append(this.toIndentedString(this.shippingDate)).append("\n");
        sb.append("    estimatedArrivalDate: ").append(this.toIndentedString(this.estimatedArrivalDate)).append("\n");
        sb.append("    shippingNotes: ").append(this.toIndentedString(this.shippingNotes)).append("\n");
        sb.append("    fulfillmentShipmentItem: ").append(this.toIndentedString(this.fulfillmentShipmentItem)).append("\n");
        sb.append("    fulfillmentShipmentPackage: ").append(this.toIndentedString(this.fulfillmentShipmentPackage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FulfillmentShipmentStatusEnum {
        PENDING("PENDING"),
        SHIPPED("SHIPPED"),
        CANCELLED_BY_FULFILLER("CANCELLED_BY_FULFILLER"),
        CANCELLED_BY_SELLER("CANCELLED_BY_SELLER");

        private String value;

        private FulfillmentShipmentStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FulfillmentShipmentStatusEnum fromValue(String input) {
            for (FulfillmentShipmentStatusEnum b : FulfillmentShipmentStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FulfillmentShipmentStatusEnum> {
            public void write(JsonWriter jsonWriter, FulfillmentShipmentStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public FulfillmentShipmentStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FulfillmentShipmentStatusEnum.fromValue(value);
            }
        }
    }
}

