/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.FulfillmentPreviewItemList;

@Schema(description="Delivery and item information for a shipment in a fulfillment order preview.")
public class FulfillmentPreviewShipment {
    @SerializedName(value="earliestShipDate")
    private OffsetDateTime earliestShipDate = null;
    @SerializedName(value="latestShipDate")
    private OffsetDateTime latestShipDate = null;
    @SerializedName(value="earliestArrivalDate")
    private OffsetDateTime earliestArrivalDate = null;
    @SerializedName(value="latestArrivalDate")
    private OffsetDateTime latestArrivalDate = null;
    @SerializedName(value="shippingNotes")
    private List<String> shippingNotes = null;
    @SerializedName(value="fulfillmentPreviewItems")
    private FulfillmentPreviewItemList fulfillmentPreviewItems = null;

    public FulfillmentPreviewShipment earliestShipDate(OffsetDateTime earliestShipDate) {
        this.earliestShipDate = earliestShipDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getEarliestShipDate() {
        return this.earliestShipDate;
    }

    public void setEarliestShipDate(OffsetDateTime earliestShipDate) {
        this.earliestShipDate = earliestShipDate;
    }

    public FulfillmentPreviewShipment latestShipDate(OffsetDateTime latestShipDate) {
        this.latestShipDate = latestShipDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getLatestShipDate() {
        return this.latestShipDate;
    }

    public void setLatestShipDate(OffsetDateTime latestShipDate) {
        this.latestShipDate = latestShipDate;
    }

    public FulfillmentPreviewShipment earliestArrivalDate(OffsetDateTime earliestArrivalDate) {
        this.earliestArrivalDate = earliestArrivalDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getEarliestArrivalDate() {
        return this.earliestArrivalDate;
    }

    public void setEarliestArrivalDate(OffsetDateTime earliestArrivalDate) {
        this.earliestArrivalDate = earliestArrivalDate;
    }

    public FulfillmentPreviewShipment latestArrivalDate(OffsetDateTime latestArrivalDate) {
        this.latestArrivalDate = latestArrivalDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getLatestArrivalDate() {
        return this.latestArrivalDate;
    }

    public void setLatestArrivalDate(OffsetDateTime latestArrivalDate) {
        this.latestArrivalDate = latestArrivalDate;
    }

    public FulfillmentPreviewShipment shippingNotes(List<String> shippingNotes) {
        this.shippingNotes = shippingNotes;
        return this;
    }

    public FulfillmentPreviewShipment addShippingNotesItem(String shippingNotesItem) {
        if (this.shippingNotes == null) {
            this.shippingNotes = new ArrayList<String>();
        }
        this.shippingNotes.add(shippingNotesItem);
        return this;
    }

    @Schema(description="Provides additional insight into the shipment timeline when exact delivery dates are not able to be precomputed.")
    public List<String> getShippingNotes() {
        return this.shippingNotes;
    }

    public void setShippingNotes(List<String> shippingNotes) {
        this.shippingNotes = shippingNotes;
    }

    public FulfillmentPreviewShipment fulfillmentPreviewItems(FulfillmentPreviewItemList fulfillmentPreviewItems) {
        this.fulfillmentPreviewItems = fulfillmentPreviewItems;
        return this;
    }

    @Schema(required=true, description="")
    public FulfillmentPreviewItemList getFulfillmentPreviewItems() {
        return this.fulfillmentPreviewItems;
    }

    public void setFulfillmentPreviewItems(FulfillmentPreviewItemList fulfillmentPreviewItems) {
        this.fulfillmentPreviewItems = fulfillmentPreviewItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentPreviewShipment fulfillmentPreviewShipment = (FulfillmentPreviewShipment)o;
        return Objects.equals(this.earliestShipDate, fulfillmentPreviewShipment.earliestShipDate) && Objects.equals(this.latestShipDate, fulfillmentPreviewShipment.latestShipDate) && Objects.equals(this.earliestArrivalDate, fulfillmentPreviewShipment.earliestArrivalDate) && Objects.equals(this.latestArrivalDate, fulfillmentPreviewShipment.latestArrivalDate) && Objects.equals(this.shippingNotes, fulfillmentPreviewShipment.shippingNotes) && Objects.equals(this.fulfillmentPreviewItems, fulfillmentPreviewShipment.fulfillmentPreviewItems);
    }

    public int hashCode() {
        return Objects.hash(this.earliestShipDate, this.latestShipDate, this.earliestArrivalDate, this.latestArrivalDate, this.shippingNotes, this.fulfillmentPreviewItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentPreviewShipment {\n");
        sb.append("    earliestShipDate: ").append(this.toIndentedString(this.earliestShipDate)).append("\n");
        sb.append("    latestShipDate: ").append(this.toIndentedString(this.latestShipDate)).append("\n");
        sb.append("    earliestArrivalDate: ").append(this.toIndentedString(this.earliestArrivalDate)).append("\n");
        sb.append("    latestArrivalDate: ").append(this.toIndentedString(this.latestArrivalDate)).append("\n");
        sb.append("    shippingNotes: ").append(this.toIndentedString(this.shippingNotes)).append("\n");
        sb.append("    fulfillmentPreviewItems: ").append(this.toIndentedString(this.fulfillmentPreviewItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

