/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Feature settings allows you to apply fulfillment features to an order. To block an order from being shipped using Amazon Logistics (AMZL) and an AMZL tracking number, set `featureName` to `BLOCK_AMZL` and `featureFulfillmentPolicy` to `Required`. Blocking AMZL will incur an additional fee surcharge on your MCF orders and increase the risk of some of your orders being unfulfilled or delivered late if there are no alternative carriers available. Using `BLOCK_AMZL` in an order request will take precedence over your Seller Central account setting. To ship in non-Amazon branded packaging (blank boxes), set `featureName` to `BLANK_BOX`. To require a signature from the recipient upon delivery, set `featureName` to `SIGNATURE_CONFIRMATION`. Note that using signature confirmation features will incur additional fees on MCF orders and are currently supported only in the US marketplace. To ensure all items in an order are delivered together, set `featureName` to `DELIVER_TOGETHER`.")
public class FeatureSettings {
    @SerializedName(value="featureName")
    private String featureName = null;
    @SerializedName(value="featureFulfillmentPolicy")
    private FeatureFulfillmentPolicyEnum featureFulfillmentPolicy = null;

    public FeatureSettings featureName(String featureName) {
        this.featureName = featureName;
        return this;
    }

    @Schema(description="The name of the feature. Valid feature names are:  - `BLOCK_AMZL`: Blocks orders from being shipped using Amazon Logistics (AMZL).   - Note: Using this feature will incur additional fee surcharges on MCF orders and may increase the risk of unfulfilled or delayed deliveries if alternative carriers are unavailable. Using `BLOCK_AMZL` in an order request will take precedence over your Seller Central account setting. - `BLANK_BOX`: Ships orders in non-Amazon branded packaging (blank boxes). - `SIGNATURE_CONFIRMATION`: Requires a signature from the recipient upon delivery.    - Note: Using signature confirmation features will incur additional fees on MCF orders and are currently supported only in the US marketplace.")
    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public FeatureSettings featureFulfillmentPolicy(FeatureFulfillmentPolicyEnum featureFulfillmentPolicy) {
        this.featureFulfillmentPolicy = featureFulfillmentPolicy;
        return this;
    }

    @Schema(description="Specifies the policy to use when fulfilling an order.")
    public FeatureFulfillmentPolicyEnum getFeatureFulfillmentPolicy() {
        return this.featureFulfillmentPolicy;
    }

    public void setFeatureFulfillmentPolicy(FeatureFulfillmentPolicyEnum featureFulfillmentPolicy) {
        this.featureFulfillmentPolicy = featureFulfillmentPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureSettings featureSettings = (FeatureSettings)o;
        return Objects.equals(this.featureName, featureSettings.featureName) && Objects.equals((Object)this.featureFulfillmentPolicy, (Object)featureSettings.featureFulfillmentPolicy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.featureName, this.featureFulfillmentPolicy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureSettings {\n");
        sb.append("    featureName: ").append(this.toIndentedString(this.featureName)).append("\n");
        sb.append("    featureFulfillmentPolicy: ").append(this.toIndentedString((Object)this.featureFulfillmentPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FeatureFulfillmentPolicyEnum {
        REQUIRED("Required"),
        NOTREQUIRED("NotRequired");

        private String value;

        private FeatureFulfillmentPolicyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FeatureFulfillmentPolicyEnum fromValue(String input) {
            for (FeatureFulfillmentPolicyEnum b : FeatureFulfillmentPolicyEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FeatureFulfillmentPolicyEnum> {
            public void write(JsonWriter jsonWriter, FeatureFulfillmentPolicyEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public FeatureFulfillmentPolicyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FeatureFulfillmentPolicyEnum.fromValue(value);
            }
        }
    }
}

