/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="An item that Amazon accepted for return.")
public class CreateReturnItem {
    @SerializedName(value="sellerReturnItemId")
    private String sellerReturnItemId = null;
    @SerializedName(value="sellerFulfillmentOrderItemId")
    private String sellerFulfillmentOrderItemId = null;
    @SerializedName(value="amazonShipmentId")
    private String amazonShipmentId = null;
    @SerializedName(value="returnReasonCode")
    private String returnReasonCode = null;
    @SerializedName(value="returnComment")
    private String returnComment = null;

    public CreateReturnItem sellerReturnItemId(String sellerReturnItemId) {
        this.sellerReturnItemId = sellerReturnItemId;
        return this;
    }

    @Schema(required=true, description="An identifier the seller assigns to the return item.")
    public String getSellerReturnItemId() {
        return this.sellerReturnItemId;
    }

    public void setSellerReturnItemId(String sellerReturnItemId) {
        this.sellerReturnItemId = sellerReturnItemId;
    }

    public CreateReturnItem sellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
        return this;
    }

    @Schema(required=true, description="The identifier assigned to the item by the seller when the fulfillment order was created.")
    public String getSellerFulfillmentOrderItemId() {
        return this.sellerFulfillmentOrderItemId;
    }

    public void setSellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
    }

    public CreateReturnItem amazonShipmentId(String amazonShipmentId) {
        this.amazonShipmentId = amazonShipmentId;
        return this;
    }

    @Schema(required=true, description="The identifier for the shipment that is associated with the return item.")
    public String getAmazonShipmentId() {
        return this.amazonShipmentId;
    }

    public void setAmazonShipmentId(String amazonShipmentId) {
        this.amazonShipmentId = amazonShipmentId;
    }

    public CreateReturnItem returnReasonCode(String returnReasonCode) {
        this.returnReasonCode = returnReasonCode;
        return this;
    }

    @Schema(required=true, description="The return reason code assigned to the return item by the seller.")
    public String getReturnReasonCode() {
        return this.returnReasonCode;
    }

    public void setReturnReasonCode(String returnReasonCode) {
        this.returnReasonCode = returnReasonCode;
    }

    public CreateReturnItem returnComment(String returnComment) {
        this.returnComment = returnComment;
        return this;
    }

    @Schema(description="An optional comment about the return item.")
    public String getReturnComment() {
        return this.returnComment;
    }

    public void setReturnComment(String returnComment) {
        this.returnComment = returnComment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateReturnItem createReturnItem = (CreateReturnItem)o;
        return Objects.equals(this.sellerReturnItemId, createReturnItem.sellerReturnItemId) && Objects.equals(this.sellerFulfillmentOrderItemId, createReturnItem.sellerFulfillmentOrderItemId) && Objects.equals(this.amazonShipmentId, createReturnItem.amazonShipmentId) && Objects.equals(this.returnReasonCode, createReturnItem.returnReasonCode) && Objects.equals(this.returnComment, createReturnItem.returnComment);
    }

    public int hashCode() {
        return Objects.hash(this.sellerReturnItemId, this.sellerFulfillmentOrderItemId, this.amazonShipmentId, this.returnReasonCode, this.returnComment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateReturnItem {\n");
        sb.append("    sellerReturnItemId: ").append(this.toIndentedString(this.sellerReturnItemId)).append("\n");
        sb.append("    sellerFulfillmentOrderItemId: ").append(this.toIndentedString(this.sellerFulfillmentOrderItemId)).append("\n");
        sb.append("    amazonShipmentId: ").append(this.toIndentedString(this.amazonShipmentId)).append("\n");
        sb.append("    returnReasonCode: ").append(this.toIndentedString(this.returnReasonCode)).append("\n");
        sb.append("    returnComment: ").append(this.toIndentedString(this.returnComment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

