/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.AppointmentSlot;

@Schema(description="The self ship appointment time slots availability and an expiration date for which the slots can be scheduled.")
public class SelfShipAppointmentSlotsAvailability {
    @SerializedName(value="expiresAt")
    private OffsetDateTime expiresAt = null;
    @SerializedName(value="slots")
    private List<AppointmentSlot> slots = null;

    public SelfShipAppointmentSlotsAvailability expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Schema(description="The time at which the self ship appointment slot expires. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format.")
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public SelfShipAppointmentSlotsAvailability slots(List<AppointmentSlot> slots) {
        this.slots = slots;
        return this;
    }

    public SelfShipAppointmentSlotsAvailability addSlotsItem(AppointmentSlot slotsItem) {
        if (this.slots == null) {
            this.slots = new ArrayList<AppointmentSlot>();
        }
        this.slots.add(slotsItem);
        return this;
    }

    @Schema(description="A list of appointment slots.")
    public List<AppointmentSlot> getSlots() {
        return this.slots;
    }

    public void setSlots(List<AppointmentSlot> slots) {
        this.slots = slots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelfShipAppointmentSlotsAvailability selfShipAppointmentSlotsAvailability = (SelfShipAppointmentSlotsAvailability)o;
        return Objects.equals(this.expiresAt, selfShipAppointmentSlotsAvailability.expiresAt) && Objects.equals(this.slots, selfShipAppointmentSlotsAvailability.slots);
    }

    public int hashCode() {
        return Objects.hash(this.expiresAt, this.slots);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SelfShipAppointmentSlotsAvailability {\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    slots: ").append(this.toIndentedString(this.slots)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

