/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.BoxUpdateInput;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.ItemInput;

@Schema(description="Objects that were included in the update request.")
public class RequestedUpdates {
    @SerializedName(value="boxes")
    private List<BoxUpdateInput> boxes = null;
    @SerializedName(value="items")
    private List<ItemInput> items = null;

    public RequestedUpdates boxes(List<BoxUpdateInput> boxes) {
        this.boxes = boxes;
        return this;
    }

    public RequestedUpdates addBoxesItem(BoxUpdateInput boxesItem) {
        if (this.boxes == null) {
            this.boxes = new ArrayList<BoxUpdateInput>();
        }
        this.boxes.add(boxesItem);
        return this;
    }

    @Schema(description="A list of boxes that will be present in the shipment after the update.")
    public List<BoxUpdateInput> getBoxes() {
        return this.boxes;
    }

    public void setBoxes(List<BoxUpdateInput> boxes) {
        this.boxes = boxes;
    }

    public RequestedUpdates items(List<ItemInput> items) {
        this.items = items;
        return this;
    }

    public RequestedUpdates addItemsItem(ItemInput itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<ItemInput>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Schema(description="A list of all items that will be present in the shipment after the update.")
    public List<ItemInput> getItems() {
        return this.items;
    }

    public void setItems(List<ItemInput> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestedUpdates requestedUpdates = (RequestedUpdates)o;
        return Objects.equals(this.boxes, requestedUpdates.boxes) && Objects.equals(this.items, requestedUpdates.items);
    }

    public int hashCode() {
        return Objects.hash(this.boxes, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestedUpdates {\n");
        sb.append("    boxes: ").append(this.toIndentedString(this.boxes)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

