/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Currency;

@Schema(description="Information pertaining to the preparation of inbound goods.")
public class PrepInstruction {
    @SerializedName(value="fee")
    private Currency fee = null;
    @SerializedName(value="prepOwner")
    private String prepOwner = null;
    @SerializedName(value="prepType")
    private String prepType = null;

    public PrepInstruction fee(Currency fee) {
        this.fee = fee;
        return this;
    }

    @Schema(description="")
    public Currency getFee() {
        return this.fee;
    }

    public void setFee(Currency fee) {
        this.fee = fee;
    }

    public PrepInstruction prepOwner(String prepOwner) {
        this.prepOwner = prepOwner;
        return this;
    }

    @Schema(description="In some situations, special preparations are required for items and this field reflects the owner of the preparations. Options include `AMAZON`, `SELLER` or `NONE`.")
    public String getPrepOwner() {
        return this.prepOwner;
    }

    public void setPrepOwner(String prepOwner) {
        this.prepOwner = prepOwner;
    }

    public PrepInstruction prepType(String prepType) {
        this.prepType = prepType;
        return this;
    }

    @Schema(description="Type of preparation that should be done.  Possible values: `ITEM_LABELING`, `ITEM_BUBBLEWRAP`, `ITEM_POLYBAGGING`, `ITEM_TAPING`, `ITEM_BLACK_SHRINKWRAP`, `ITEM_HANG_GARMENT`, `ITEM_BOXING`, `ITEM_SETCREAT`, `ITEM_RMOVHANG`, `ITEM_SUFFOSTK`, `ITEM_CAP_SEALING`, `ITEM_DEBUNDLE`, `ITEM_SETSTK`, `ITEM_SIOC`, `ITEM_NO_PREP`, `ADULT`, `BABY`, `TEXTILE`, `HANGER`, `FRAGILE`, `LIQUID`, `SHARP`, `SMALL`, `PERFORATED`, `GRANULAR`, `SET`, `FC_PROVIDED`, `UNKNOWN`, `NONE`.")
    public String getPrepType() {
        return this.prepType;
    }

    public void setPrepType(String prepType) {
        this.prepType = prepType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrepInstruction prepInstruction = (PrepInstruction)o;
        return Objects.equals(this.fee, prepInstruction.fee) && Objects.equals(this.prepOwner, prepInstruction.prepOwner) && Objects.equals(this.prepType, prepInstruction.prepType);
    }

    public int hashCode() {
        return Objects.hash(this.fee, this.prepOwner, this.prepType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrepInstruction {\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    prepOwner: ").append(this.toIndentedString(this.prepOwner)).append("\n");
        sb.append("    prepType: ").append(this.toIndentedString(this.prepType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

