/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.BoxContentInformationSource;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.BoxRequirements;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.ShippingRequirements;

@Schema(description="A way to configure this packing option. Some box content information sources might not be allowed. Non-standard minimum and maximum box weights might be enforced.")
public class PackingConfiguration {
    @SerializedName(value="boxPackingMethods")
    private List<BoxContentInformationSource> boxPackingMethods = null;
    @SerializedName(value="boxRequirements")
    private BoxRequirements boxRequirements = null;
    @SerializedName(value="shippingRequirements")
    private List<ShippingRequirements> shippingRequirements = null;

    public PackingConfiguration boxPackingMethods(List<BoxContentInformationSource> boxPackingMethods) {
        this.boxPackingMethods = boxPackingMethods;
        return this;
    }

    public PackingConfiguration addBoxPackingMethodsItem(BoxContentInformationSource boxPackingMethodsItem) {
        if (this.boxPackingMethods == null) {
            this.boxPackingMethods = new ArrayList<BoxContentInformationSource>();
        }
        this.boxPackingMethods.add(boxPackingMethodsItem);
        return this;
    }

    @Schema(description="The box content information sources that are allowed.")
    public List<BoxContentInformationSource> getBoxPackingMethods() {
        return this.boxPackingMethods;
    }

    public void setBoxPackingMethods(List<BoxContentInformationSource> boxPackingMethods) {
        this.boxPackingMethods = boxPackingMethods;
    }

    public PackingConfiguration boxRequirements(BoxRequirements boxRequirements) {
        this.boxRequirements = boxRequirements;
        return this;
    }

    @Schema(description="")
    public BoxRequirements getBoxRequirements() {
        return this.boxRequirements;
    }

    public void setBoxRequirements(BoxRequirements boxRequirements) {
        this.boxRequirements = boxRequirements;
    }

    public PackingConfiguration shippingRequirements(List<ShippingRequirements> shippingRequirements) {
        this.shippingRequirements = shippingRequirements;
        return this;
    }

    public PackingConfiguration addShippingRequirementsItem(ShippingRequirements shippingRequirementsItem) {
        if (this.shippingRequirements == null) {
            this.shippingRequirements = new ArrayList<ShippingRequirements>();
        }
        this.shippingRequirements.add(shippingRequirementsItem);
        return this;
    }

    @Schema(description="A list of supported shipping requirements for this packing configuration.")
    public List<ShippingRequirements> getShippingRequirements() {
        return this.shippingRequirements;
    }

    public void setShippingRequirements(List<ShippingRequirements> shippingRequirements) {
        this.shippingRequirements = shippingRequirements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackingConfiguration packingConfiguration = (PackingConfiguration)o;
        return Objects.equals(this.boxPackingMethods, packingConfiguration.boxPackingMethods) && Objects.equals(this.boxRequirements, packingConfiguration.boxRequirements) && Objects.equals(this.shippingRequirements, packingConfiguration.shippingRequirements);
    }

    public int hashCode() {
        return Objects.hash(this.boxPackingMethods, this.boxRequirements, this.shippingRequirements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PackingConfiguration {\n");
        sb.append("    boxPackingMethods: ").append(this.toIndentedString(this.boxPackingMethods)).append("\n");
        sb.append("    boxRequirements: ").append(this.toIndentedString(this.boxRequirements)).append("\n");
        sb.append("    shippingRequirements: ").append(this.toIndentedString(this.shippingRequirements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

