/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Currency;

@Schema(description="Contains details about cost related modifications to the placement cost.")
public class Incentive {
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="target")
    private String target = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="value")
    private Currency value = null;

    public Incentive description(String description) {
        this.description = description;
        return this;
    }

    @Schema(required=true, description="Description of the incentive.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Incentive target(String target) {
        this.target = target;
        return this;
    }

    @Schema(required=true, description="Target of the incentive. Possible values: 'Placement Services', 'Fulfillment Fee Discount'.")
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Incentive type(String type) {
        this.type = type;
        return this;
    }

    @Schema(required=true, description="Type of incentive. Possible values: `FEE`, `DISCOUNT`.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Incentive value(Currency value) {
        this.value = value;
        return this;
    }

    @Schema(required=true, description="")
    public Currency getValue() {
        return this.value;
    }

    public void setValue(Currency value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Incentive incentive = (Incentive)o;
        return Objects.equals(this.description, incentive.description) && Objects.equals(this.target, incentive.target) && Objects.equals(this.type, incentive.type) && Objects.equals(this.value, incentive.value);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.target, this.type, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Incentive {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

