/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Address;

@Schema(description="A light-weight inbound plan.")
public class InboundPlanSummary {
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt = null;
    @SerializedName(value="inboundPlanId")
    private String inboundPlanId = null;
    @SerializedName(value="lastUpdatedAt")
    private OffsetDateTime lastUpdatedAt = null;
    @SerializedName(value="marketplaceIds")
    private List<String> marketplaceIds = new ArrayList<String>();
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="sourceAddress")
    private Address sourceAddress = null;
    @SerializedName(value="status")
    private String status = null;

    public InboundPlanSummary createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(required=true, description="The time at which the inbound plan was created. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern `yyyy-MM-ddTHH:mm:ssZ`.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public InboundPlanSummary inboundPlanId(String inboundPlanId) {
        this.inboundPlanId = inboundPlanId;
        return this;
    }

    @Schema(required=true, description="Identifier of an inbound plan.")
    public String getInboundPlanId() {
        return this.inboundPlanId;
    }

    public void setInboundPlanId(String inboundPlanId) {
        this.inboundPlanId = inboundPlanId;
    }

    public InboundPlanSummary lastUpdatedAt(OffsetDateTime lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
        return this;
    }

    @Schema(required=true, description="The time at which the inbound plan was last updated. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern `yyyy-MM-ddTHH:mm:ssZ`.")
    public OffsetDateTime getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public void setLastUpdatedAt(OffsetDateTime lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public InboundPlanSummary marketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
        return this;
    }

    public InboundPlanSummary addMarketplaceIdsItem(String marketplaceIdsItem) {
        this.marketplaceIds.add(marketplaceIdsItem);
        return this;
    }

    @Schema(required=true, description="A list of marketplace IDs.")
    public List<String> getMarketplaceIds() {
        return this.marketplaceIds;
    }

    public void setMarketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
    }

    public InboundPlanSummary name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Human-readable name of the inbound plan.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InboundPlanSummary sourceAddress(Address sourceAddress) {
        this.sourceAddress = sourceAddress;
        return this;
    }

    @Schema(required=true, description="")
    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(Address sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public InboundPlanSummary status(String status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="The current status of the inbound plan. Possible values: `ACTIVE`, `VOIDED`, `SHIPPED`, `ERRORED`.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundPlanSummary inboundPlanSummary = (InboundPlanSummary)o;
        return Objects.equals(this.createdAt, inboundPlanSummary.createdAt) && Objects.equals(this.inboundPlanId, inboundPlanSummary.inboundPlanId) && Objects.equals(this.lastUpdatedAt, inboundPlanSummary.lastUpdatedAt) && Objects.equals(this.marketplaceIds, inboundPlanSummary.marketplaceIds) && Objects.equals(this.name, inboundPlanSummary.name) && Objects.equals(this.sourceAddress, inboundPlanSummary.sourceAddress) && Objects.equals(this.status, inboundPlanSummary.status);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.inboundPlanId, this.lastUpdatedAt, this.marketplaceIds, this.name, this.sourceAddress, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundPlanSummary {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    inboundPlanId: ").append(this.toIndentedString(this.inboundPlanId)).append("\n");
        sb.append("    lastUpdatedAt: ").append(this.toIndentedString(this.lastUpdatedAt)).append("\n");
        sb.append("    marketplaceIds: ").append(this.toIndentedString(this.marketplaceIds)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sourceAddress: ").append(this.toIndentedString(this.sourceAddress)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

