/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Address;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.PackingOptionSummary;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.PlacementOptionSummary;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.ShipmentSummary;

@Schema(description="Inbound plan containing details of the inbound workflow.")
public class InboundPlan {
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt = null;
    @SerializedName(value="inboundPlanId")
    private String inboundPlanId = null;
    @SerializedName(value="lastUpdatedAt")
    private OffsetDateTime lastUpdatedAt = null;
    @SerializedName(value="marketplaceIds")
    private List<String> marketplaceIds = new ArrayList<String>();
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="packingOptions")
    private List<PackingOptionSummary> packingOptions = null;
    @SerializedName(value="placementOptions")
    private List<PlacementOptionSummary> placementOptions = null;
    @SerializedName(value="shipments")
    private List<ShipmentSummary> shipments = null;
    @SerializedName(value="sourceAddress")
    private Address sourceAddress = null;
    @SerializedName(value="status")
    private String status = null;

    public InboundPlan createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(required=true, description="The time at which the inbound plan was created. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime with pattern `yyyy-MM-ddTHH:mm:ssZ`.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public InboundPlan inboundPlanId(String inboundPlanId) {
        this.inboundPlanId = inboundPlanId;
        return this;
    }

    @Schema(required=true, description="Identifier of an inbound plan.")
    public String getInboundPlanId() {
        return this.inboundPlanId;
    }

    public void setInboundPlanId(String inboundPlanId) {
        this.inboundPlanId = inboundPlanId;
    }

    public InboundPlan lastUpdatedAt(OffsetDateTime lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
        return this;
    }

    @Schema(required=true, description="The time at which the inbound plan was last updated. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern `yyyy-MM-ddTHH:mm:ssZ`.")
    public OffsetDateTime getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public void setLastUpdatedAt(OffsetDateTime lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public InboundPlan marketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
        return this;
    }

    public InboundPlan addMarketplaceIdsItem(String marketplaceIdsItem) {
        this.marketplaceIds.add(marketplaceIdsItem);
        return this;
    }

    @Schema(required=true, description="A list of marketplace IDs.")
    public List<String> getMarketplaceIds() {
        return this.marketplaceIds;
    }

    public void setMarketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
    }

    public InboundPlan name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Human-readable name of the inbound plan.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InboundPlan packingOptions(List<PackingOptionSummary> packingOptions) {
        this.packingOptions = packingOptions;
        return this;
    }

    public InboundPlan addPackingOptionsItem(PackingOptionSummary packingOptionsItem) {
        if (this.packingOptions == null) {
            this.packingOptions = new ArrayList<PackingOptionSummary>();
        }
        this.packingOptions.add(packingOptionsItem);
        return this;
    }

    @Schema(description="Packing options for the inbound plan. This property will be populated when it has been generated via the corresponding operation. If there is a chosen placement option, only packing options for that placement option will be returned. If there are confirmed shipments, only packing options for those shipments will be returned. Query the packing option for more details.")
    public List<PackingOptionSummary> getPackingOptions() {
        return this.packingOptions;
    }

    public void setPackingOptions(List<PackingOptionSummary> packingOptions) {
        this.packingOptions = packingOptions;
    }

    public InboundPlan placementOptions(List<PlacementOptionSummary> placementOptions) {
        this.placementOptions = placementOptions;
        return this;
    }

    public InboundPlan addPlacementOptionsItem(PlacementOptionSummary placementOptionsItem) {
        if (this.placementOptions == null) {
            this.placementOptions = new ArrayList<PlacementOptionSummary>();
        }
        this.placementOptions.add(placementOptionsItem);
        return this;
    }

    @Schema(description="Placement options for the inbound plan. This property will be populated when it has been generated via the corresponding operation. If there is a chosen placement option, that will be the only returned option. Query the placement option for more details.")
    public List<PlacementOptionSummary> getPlacementOptions() {
        return this.placementOptions;
    }

    public void setPlacementOptions(List<PlacementOptionSummary> placementOptions) {
        this.placementOptions = placementOptions;
    }

    public InboundPlan shipments(List<ShipmentSummary> shipments) {
        this.shipments = shipments;
        return this;
    }

    public InboundPlan addShipmentsItem(ShipmentSummary shipmentsItem) {
        if (this.shipments == null) {
            this.shipments = new ArrayList<ShipmentSummary>();
        }
        this.shipments.add(shipmentsItem);
        return this;
    }

    @Schema(description="A list of shipment IDs for the inbound plan. This property is populated when it has been generated with the `confirmPlacementOptions` operation. Only shipments from the chosen placement option are returned. Query the shipment for more details.")
    public List<ShipmentSummary> getShipments() {
        return this.shipments;
    }

    public void setShipments(List<ShipmentSummary> shipments) {
        this.shipments = shipments;
    }

    public InboundPlan sourceAddress(Address sourceAddress) {
        this.sourceAddress = sourceAddress;
        return this;
    }

    @Schema(required=true, description="")
    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(Address sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public InboundPlan status(String status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="Current status of the inbound plan. Possible values: `ACTIVE`, `VOIDED`, `SHIPPED`, `ERRORED`.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundPlan inboundPlan = (InboundPlan)o;
        return Objects.equals(this.createdAt, inboundPlan.createdAt) && Objects.equals(this.inboundPlanId, inboundPlan.inboundPlanId) && Objects.equals(this.lastUpdatedAt, inboundPlan.lastUpdatedAt) && Objects.equals(this.marketplaceIds, inboundPlan.marketplaceIds) && Objects.equals(this.name, inboundPlan.name) && Objects.equals(this.packingOptions, inboundPlan.packingOptions) && Objects.equals(this.placementOptions, inboundPlan.placementOptions) && Objects.equals(this.shipments, inboundPlan.shipments) && Objects.equals(this.sourceAddress, inboundPlan.sourceAddress) && Objects.equals(this.status, inboundPlan.status);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.inboundPlanId, this.lastUpdatedAt, this.marketplaceIds, this.name, this.packingOptions, this.placementOptions, this.shipments, this.sourceAddress, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundPlan {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    inboundPlanId: ").append(this.toIndentedString(this.inboundPlanId)).append("\n");
        sb.append("    lastUpdatedAt: ").append(this.toIndentedString(this.lastUpdatedAt)).append("\n");
        sb.append("    marketplaceIds: ").append(this.toIndentedString(this.marketplaceIds)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    packingOptions: ").append(this.toIndentedString(this.packingOptions)).append("\n");
        sb.append("    placementOptions: ").append(this.toIndentedString(this.placementOptions)).append("\n");
        sb.append("    shipments: ").append(this.toIndentedString(this.shipments)).append("\n");
        sb.append("    sourceAddress: ").append(this.toIndentedString(this.sourceAddress)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

