/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Specific details to identify a place.")
public class Address {
    @SerializedName(value="addressLine1")
    private String addressLine1 = null;
    @SerializedName(value="addressLine2")
    private String addressLine2 = null;
    @SerializedName(value="city")
    private String city = null;
    @SerializedName(value="companyName")
    private String companyName = null;
    @SerializedName(value="countryCode")
    private String countryCode = null;
    @SerializedName(value="districtOrCounty")
    private String districtOrCounty = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="phoneNumber")
    private String phoneNumber = null;
    @SerializedName(value="postalCode")
    private String postalCode = null;
    @SerializedName(value="stateOrProvinceCode")
    private String stateOrProvinceCode = null;

    public Address addressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        return this;
    }

    @Schema(required=true, description="Street address information.")
    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public Address addressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        return this;
    }

    @Schema(description="Additional street address information.")
    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @Schema(required=true, description="The city.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Address companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Schema(description="The name of the business.")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Address countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Schema(required=true, description="The country code in two-character ISO 3166-1 alpha-2 format.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Address districtOrCounty(String districtOrCounty) {
        this.districtOrCounty = districtOrCounty;
        return this;
    }

    @Schema(description="The district or county.")
    public String getDistrictOrCounty() {
        return this.districtOrCounty;
    }

    public void setDistrictOrCounty(String districtOrCounty) {
        this.districtOrCounty = districtOrCounty;
    }

    public Address email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="The email address.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Address name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="The name of the individual who is the primary contact.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Address phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Schema(description="The phone number.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Schema(required=true, description="The postal code.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address stateOrProvinceCode(String stateOrProvinceCode) {
        this.stateOrProvinceCode = stateOrProvinceCode;
        return this;
    }

    @Schema(description="The state or province code.")
    public String getStateOrProvinceCode() {
        return this.stateOrProvinceCode;
    }

    public void setStateOrProvinceCode(String stateOrProvinceCode) {
        this.stateOrProvinceCode = stateOrProvinceCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.addressLine1, address.addressLine1) && Objects.equals(this.addressLine2, address.addressLine2) && Objects.equals(this.city, address.city) && Objects.equals(this.companyName, address.companyName) && Objects.equals(this.countryCode, address.countryCode) && Objects.equals(this.districtOrCounty, address.districtOrCounty) && Objects.equals(this.email, address.email) && Objects.equals(this.name, address.name) && Objects.equals(this.phoneNumber, address.phoneNumber) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.stateOrProvinceCode, address.stateOrProvinceCode);
    }

    public int hashCode() {
        return Objects.hash(this.addressLine1, this.addressLine2, this.city, this.companyName, this.countryCode, this.districtOrCounty, this.email, this.name, this.phoneNumber, this.postalCode, this.stateOrProvinceCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    addressLine1: ").append(this.toIndentedString(this.addressLine1)).append("\n");
        sb.append("    addressLine2: ").append(this.toIndentedString(this.addressLine2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    districtOrCounty: ").append(this.toIndentedString(this.districtOrCounty)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    stateOrProvinceCode: ").append(this.toIndentedString(this.stateOrProvinceCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

