/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.finances.v2024_06_19.Currency;

@Schema(description="Breakdown provides details regarding the money movement under the financial transaction. Breakdowns get categorized further into breakdown types, breakdown amounts, and further breakdowns into a hierarchical structure.")
public class Breakdown {
    @SerializedName(value="breakdownType")
    private String breakdownType = null;
    @SerializedName(value="breakdownAmount")
    private Currency breakdownAmount = null;
    @SerializedName(value="breakdowns")
    private List<Breakdown> breakdowns = null;

    public Breakdown breakdownType(String breakdownType) {
        this.breakdownType = breakdownType;
        return this;
    }

    @Schema(description="The type of charge.")
    public String getBreakdownType() {
        return this.breakdownType;
    }

    public void setBreakdownType(String breakdownType) {
        this.breakdownType = breakdownType;
    }

    public Breakdown breakdownAmount(Currency breakdownAmount) {
        this.breakdownAmount = breakdownAmount;
        return this;
    }

    @Schema(description="")
    public Currency getBreakdownAmount() {
        return this.breakdownAmount;
    }

    public void setBreakdownAmount(Currency breakdownAmount) {
        this.breakdownAmount = breakdownAmount;
    }

    public Breakdown breakdowns(List<Breakdown> breakdowns) {
        this.breakdowns = breakdowns;
        return this;
    }

    public Breakdown addBreakdownsItem(Breakdown breakdownsItem) {
        if (this.breakdowns == null) {
            this.breakdowns = new ArrayList<Breakdown>();
        }
        this.breakdowns.add(breakdownsItem);
        return this;
    }

    @Schema(description="A list of breakdowns that detail how the total amount is calculated for the transaction.")
    public List<Breakdown> getBreakdowns() {
        return this.breakdowns;
    }

    public void setBreakdowns(List<Breakdown> breakdowns) {
        this.breakdowns = breakdowns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Breakdown breakdown = (Breakdown)o;
        return Objects.equals(this.breakdownType, breakdown.breakdownType) && Objects.equals(this.breakdownAmount, breakdown.breakdownAmount) && Objects.equals(this.breakdowns, breakdown.breakdowns);
    }

    public int hashCode() {
        return Objects.hash(this.breakdownType, this.breakdownAmount, this.breakdowns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Breakdown {\n");
        sb.append("    breakdownType: ").append(this.toIndentedString(this.breakdownType)).append("\n");
        sb.append("    breakdownAmount: ").append(this.toIndentedString(this.breakdownAmount)).append("\n");
        sb.append("    breakdowns: ").append(this.toIndentedString(this.breakdowns)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

