/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Additional information related to Amazon Pay.")
public class AmazonPayContext {
    @SerializedName(value="storeName")
    private String storeName = null;
    @SerializedName(value="orderType")
    private String orderType = null;
    @SerializedName(value="channel")
    private String channel = null;

    public AmazonPayContext storeName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    @Schema(description="Store name related to transaction.")
    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public AmazonPayContext orderType(String orderType) {
        this.orderType = orderType;
        return this;
    }

    @Schema(description="Order type of the transaction.")
    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public AmazonPayContext channel(String channel) {
        this.channel = channel;
        return this;
    }

    @Schema(description="Channel details of related transaction.")
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmazonPayContext amazonPayContext = (AmazonPayContext)o;
        return Objects.equals(this.storeName, amazonPayContext.storeName) && Objects.equals(this.orderType, amazonPayContext.orderType) && Objects.equals(this.channel, amazonPayContext.channel);
    }

    public int hashCode() {
        return Objects.hash(this.storeName, this.orderType, this.channel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AmazonPayContext {\n");
        sb.append("    storeName: ").append(this.toIndentedString(this.storeName)).append("\n");
        sb.append("    orderType: ").append(this.toIndentedString(this.orderType)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

