/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.RemovalShipmentItemList;

@Schema(description="A removal shipment event for a removal order.")
public class RemovalShipmentEvent {
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="MerchantOrderId")
    private String merchantOrderId = null;
    @SerializedName(value="OrderId")
    private String orderId = null;
    @SerializedName(value="TransactionType")
    private String transactionType = null;
    @SerializedName(value="StoreName")
    private String storeName = null;
    @SerializedName(value="RemovalShipmentItemList")
    private RemovalShipmentItemList removalShipmentItemList = null;

    public RemovalShipmentEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public RemovalShipmentEvent merchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
        return this;
    }

    @Schema(description="The merchant removal orderId.")
    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public RemovalShipmentEvent orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @Schema(description="The identifier for the removal shipment order.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public RemovalShipmentEvent transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(description="The type of removal order.  Possible values:  * WHOLESALE_LIQUIDATION")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public RemovalShipmentEvent storeName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    @Schema(description="The name of the store where the event occurred.")
    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public RemovalShipmentEvent removalShipmentItemList(RemovalShipmentItemList removalShipmentItemList) {
        this.removalShipmentItemList = removalShipmentItemList;
        return this;
    }

    @Schema(description="")
    public RemovalShipmentItemList getRemovalShipmentItemList() {
        return this.removalShipmentItemList;
    }

    public void setRemovalShipmentItemList(RemovalShipmentItemList removalShipmentItemList) {
        this.removalShipmentItemList = removalShipmentItemList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemovalShipmentEvent removalShipmentEvent = (RemovalShipmentEvent)o;
        return Objects.equals(this.postedDate, removalShipmentEvent.postedDate) && Objects.equals(this.merchantOrderId, removalShipmentEvent.merchantOrderId) && Objects.equals(this.orderId, removalShipmentEvent.orderId) && Objects.equals(this.transactionType, removalShipmentEvent.transactionType) && Objects.equals(this.storeName, removalShipmentEvent.storeName) && Objects.equals(this.removalShipmentItemList, removalShipmentEvent.removalShipmentItemList);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.merchantOrderId, this.orderId, this.transactionType, this.storeName, this.removalShipmentItemList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RemovalShipmentEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    merchantOrderId: ").append(this.toIndentedString(this.merchantOrderId)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("    storeName: ").append(this.toIndentedString(this.storeName)).append("\n");
        sb.append("    removalShipmentItemList: ").append(this.toIndentedString(this.removalShipmentItemList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

