/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="A promotion applied to an item.")
public class Promotion {
    @SerializedName(value="PromotionType")
    private String promotionType = null;
    @SerializedName(value="PromotionId")
    private String promotionId = null;
    @SerializedName(value="PromotionAmount")
    private Currency promotionAmount = null;

    public Promotion promotionType(String promotionType) {
        this.promotionType = promotionType;
        return this;
    }

    @Schema(description="The type of promotion.")
    public String getPromotionType() {
        return this.promotionType;
    }

    public void setPromotionType(String promotionType) {
        this.promotionType = promotionType;
    }

    public Promotion promotionId(String promotionId) {
        this.promotionId = promotionId;
        return this;
    }

    @Schema(description="The seller-specified identifier for the promotion.")
    public String getPromotionId() {
        return this.promotionId;
    }

    public void setPromotionId(String promotionId) {
        this.promotionId = promotionId;
    }

    public Promotion promotionAmount(Currency promotionAmount) {
        this.promotionAmount = promotionAmount;
        return this;
    }

    @Schema(description="")
    public Currency getPromotionAmount() {
        return this.promotionAmount;
    }

    public void setPromotionAmount(Currency promotionAmount) {
        this.promotionAmount = promotionAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Promotion promotion = (Promotion)o;
        return Objects.equals(this.promotionType, promotion.promotionType) && Objects.equals(this.promotionId, promotion.promotionId) && Objects.equals(this.promotionAmount, promotion.promotionAmount);
    }

    public int hashCode() {
        return Objects.hash(this.promotionType, this.promotionId, this.promotionAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Promotion {\n");
        sb.append("    promotionType: ").append(this.toIndentedString(this.promotionType)).append("\n");
        sb.append("    promotionId: ").append(this.toIndentedString(this.promotionId)).append("\n");
        sb.append("    promotionAmount: ").append(this.toIndentedString(this.promotionAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

