/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.ChargeRefundTransactions;

@Schema(description="An event related to charge refund.")
public class ChargeRefundEvent {
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="ReasonCode")
    private String reasonCode = null;
    @SerializedName(value="ReasonCodeDescription")
    private String reasonCodeDescription = null;
    @SerializedName(value="ChargeRefundTransactions")
    private ChargeRefundTransactions chargeRefundTransactions = null;

    public ChargeRefundEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public ChargeRefundEvent reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Schema(description="The reason given for a charge refund.  Example: `SubscriptionFeeCorrection`")
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public ChargeRefundEvent reasonCodeDescription(String reasonCodeDescription) {
        this.reasonCodeDescription = reasonCodeDescription;
        return this;
    }

    @Schema(description="A description of the Reason Code.   Example: `SubscriptionFeeCorrection`")
    public String getReasonCodeDescription() {
        return this.reasonCodeDescription;
    }

    public void setReasonCodeDescription(String reasonCodeDescription) {
        this.reasonCodeDescription = reasonCodeDescription;
    }

    public ChargeRefundEvent chargeRefundTransactions(ChargeRefundTransactions chargeRefundTransactions) {
        this.chargeRefundTransactions = chargeRefundTransactions;
        return this;
    }

    @Schema(description="")
    public ChargeRefundTransactions getChargeRefundTransactions() {
        return this.chargeRefundTransactions;
    }

    public void setChargeRefundTransactions(ChargeRefundTransactions chargeRefundTransactions) {
        this.chargeRefundTransactions = chargeRefundTransactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargeRefundEvent chargeRefundEvent = (ChargeRefundEvent)o;
        return Objects.equals(this.postedDate, chargeRefundEvent.postedDate) && Objects.equals(this.reasonCode, chargeRefundEvent.reasonCode) && Objects.equals(this.reasonCodeDescription, chargeRefundEvent.reasonCodeDescription) && Objects.equals(this.chargeRefundTransactions, chargeRefundEvent.chargeRefundTransactions);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.reasonCode, this.reasonCodeDescription, this.chargeRefundTransactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChargeRefundEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    reasonCodeDescription: ").append(this.toIndentedString(this.reasonCodeDescription)).append("\n");
        sb.append("    chargeRefundTransactions: ").append(this.toIndentedString(this.chargeRefundTransactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

