/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="An event related to an Adhoc Disbursement.")
public class AdhocDisbursementEvent {
    @SerializedName(value="TransactionType")
    private String transactionType = null;
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="TransactionId")
    private String transactionId = null;
    @SerializedName(value="TransactionAmount")
    private Currency transactionAmount = null;

    public AdhocDisbursementEvent transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(description="Indicates the type of transaction.  Example: \"Disbursed to Amazon Gift Card balance\"")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public AdhocDisbursementEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public AdhocDisbursementEvent transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Schema(description="The identifier for the transaction.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public AdhocDisbursementEvent transactionAmount(Currency transactionAmount) {
        this.transactionAmount = transactionAmount;
        return this;
    }

    @Schema(description="")
    public Currency getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(Currency transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdhocDisbursementEvent adhocDisbursementEvent = (AdhocDisbursementEvent)o;
        return Objects.equals(this.transactionType, adhocDisbursementEvent.transactionType) && Objects.equals(this.postedDate, adhocDisbursementEvent.postedDate) && Objects.equals(this.transactionId, adhocDisbursementEvent.transactionId) && Objects.equals(this.transactionAmount, adhocDisbursementEvent.transactionAmount);
    }

    public int hashCode() {
        return Objects.hash(this.transactionType, this.postedDate, this.transactionId, this.transactionAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdhocDisbursementEvent {\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionAmount: ").append(this.toIndentedString(this.transactionAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

