/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.feeds.v2021_06_30;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Information required for the feed document.")
public class FeedDocument {
    @SerializedName(value="feedDocumentId")
    private String feedDocumentId = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="compressionAlgorithm")
    private CompressionAlgorithmEnum compressionAlgorithm = null;

    public FeedDocument feedDocumentId(String feedDocumentId) {
        this.feedDocumentId = feedDocumentId;
        return this;
    }

    @Schema(required=true, description="The identifier for the feed document. This identifier is unique only in combination with a seller ID.")
    public String getFeedDocumentId() {
        return this.feedDocumentId;
    }

    public void setFeedDocumentId(String feedDocumentId) {
        this.feedDocumentId = feedDocumentId;
    }

    public FeedDocument url(String url) {
        this.url = url;
        return this;
    }

    @Schema(required=true, description="A presigned URL for the feed document. If `compressionAlgorithm` is not returned, you can download the feed directly from this URL. This URL expires after 5 minutes.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public FeedDocument compressionAlgorithm(CompressionAlgorithmEnum compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
        return this;
    }

    @Schema(description="If the feed document contents have been compressed, the compression algorithm used is returned in this property and you must decompress the feed when you download. Otherwise, you can download the feed directly. Refer to [Step 7. Download the feed processing report](doc:feeds-api-v2021-06-30-use-case-guide#step-7-download-the-feed-processing-report) in the use case guide, where sample code is provided.")
    public CompressionAlgorithmEnum getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(CompressionAlgorithmEnum compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedDocument feedDocument = (FeedDocument)o;
        return Objects.equals(this.feedDocumentId, feedDocument.feedDocumentId) && Objects.equals(this.url, feedDocument.url) && Objects.equals((Object)this.compressionAlgorithm, (Object)feedDocument.compressionAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feedDocumentId, this.url, this.compressionAlgorithm});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeedDocument {\n");
        sb.append("    feedDocumentId: ").append(this.toIndentedString(this.feedDocumentId)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    compressionAlgorithm: ").append(this.toIndentedString((Object)this.compressionAlgorithm)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CompressionAlgorithmEnum {
        GZIP("GZIP");

        private String value;

        private CompressionAlgorithmEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CompressionAlgorithmEnum fromValue(String input) {
            for (CompressionAlgorithmEnum b : CompressionAlgorithmEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CompressionAlgorithmEnum> {
            public void write(JsonWriter jsonWriter, CompressionAlgorithmEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public CompressionAlgorithmEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CompressionAlgorithmEnum.fromValue(value);
            }
        }
    }
}

