/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fba.inventory.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.fba.inventory.v1.ResearchingQuantity;
import software.amazon.spapi.models.fba.inventory.v1.ReservedQuantity;
import software.amazon.spapi.models.fba.inventory.v1.UnfulfillableQuantity;

@Schema(description="Summarized inventory details. This object will not appear if the details parameter in the request is false.")
public class InventoryDetails {
    @SerializedName(value="fulfillableQuantity")
    private Integer fulfillableQuantity = null;
    @SerializedName(value="inboundWorkingQuantity")
    private Integer inboundWorkingQuantity = null;
    @SerializedName(value="inboundShippedQuantity")
    private Integer inboundShippedQuantity = null;
    @SerializedName(value="inboundReceivingQuantity")
    private Integer inboundReceivingQuantity = null;
    @SerializedName(value="reservedQuantity")
    private ReservedQuantity reservedQuantity = null;
    @SerializedName(value="researchingQuantity")
    private ResearchingQuantity researchingQuantity = null;
    @SerializedName(value="unfulfillableQuantity")
    private UnfulfillableQuantity unfulfillableQuantity = null;

    public InventoryDetails fulfillableQuantity(Integer fulfillableQuantity) {
        this.fulfillableQuantity = fulfillableQuantity;
        return this;
    }

    @Schema(description="The item quantity that can be picked, packed, and shipped.")
    public Integer getFulfillableQuantity() {
        return this.fulfillableQuantity;
    }

    public void setFulfillableQuantity(Integer fulfillableQuantity) {
        this.fulfillableQuantity = fulfillableQuantity;
    }

    public InventoryDetails inboundWorkingQuantity(Integer inboundWorkingQuantity) {
        this.inboundWorkingQuantity = inboundWorkingQuantity;
        return this;
    }

    @Schema(description="The number of units in an inbound shipment for which you have notified Amazon.")
    public Integer getInboundWorkingQuantity() {
        return this.inboundWorkingQuantity;
    }

    public void setInboundWorkingQuantity(Integer inboundWorkingQuantity) {
        this.inboundWorkingQuantity = inboundWorkingQuantity;
    }

    public InventoryDetails inboundShippedQuantity(Integer inboundShippedQuantity) {
        this.inboundShippedQuantity = inboundShippedQuantity;
        return this;
    }

    @Schema(description="The number of units in an inbound shipment that you have notified Amazon about and have provided a tracking number.")
    public Integer getInboundShippedQuantity() {
        return this.inboundShippedQuantity;
    }

    public void setInboundShippedQuantity(Integer inboundShippedQuantity) {
        this.inboundShippedQuantity = inboundShippedQuantity;
    }

    public InventoryDetails inboundReceivingQuantity(Integer inboundReceivingQuantity) {
        this.inboundReceivingQuantity = inboundReceivingQuantity;
        return this;
    }

    @Schema(description="The number of units that have not yet been received at an Amazon fulfillment center for processing, but are part of an inbound shipment with some units that have already been received and processed.")
    public Integer getInboundReceivingQuantity() {
        return this.inboundReceivingQuantity;
    }

    public void setInboundReceivingQuantity(Integer inboundReceivingQuantity) {
        this.inboundReceivingQuantity = inboundReceivingQuantity;
    }

    public InventoryDetails reservedQuantity(ReservedQuantity reservedQuantity) {
        this.reservedQuantity = reservedQuantity;
        return this;
    }

    @Schema(description="")
    public ReservedQuantity getReservedQuantity() {
        return this.reservedQuantity;
    }

    public void setReservedQuantity(ReservedQuantity reservedQuantity) {
        this.reservedQuantity = reservedQuantity;
    }

    public InventoryDetails researchingQuantity(ResearchingQuantity researchingQuantity) {
        this.researchingQuantity = researchingQuantity;
        return this;
    }

    @Schema(description="")
    public ResearchingQuantity getResearchingQuantity() {
        return this.researchingQuantity;
    }

    public void setResearchingQuantity(ResearchingQuantity researchingQuantity) {
        this.researchingQuantity = researchingQuantity;
    }

    public InventoryDetails unfulfillableQuantity(UnfulfillableQuantity unfulfillableQuantity) {
        this.unfulfillableQuantity = unfulfillableQuantity;
        return this;
    }

    @Schema(description="")
    public UnfulfillableQuantity getUnfulfillableQuantity() {
        return this.unfulfillableQuantity;
    }

    public void setUnfulfillableQuantity(UnfulfillableQuantity unfulfillableQuantity) {
        this.unfulfillableQuantity = unfulfillableQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryDetails inventoryDetails = (InventoryDetails)o;
        return Objects.equals(this.fulfillableQuantity, inventoryDetails.fulfillableQuantity) && Objects.equals(this.inboundWorkingQuantity, inventoryDetails.inboundWorkingQuantity) && Objects.equals(this.inboundShippedQuantity, inventoryDetails.inboundShippedQuantity) && Objects.equals(this.inboundReceivingQuantity, inventoryDetails.inboundReceivingQuantity) && Objects.equals(this.reservedQuantity, inventoryDetails.reservedQuantity) && Objects.equals(this.researchingQuantity, inventoryDetails.researchingQuantity) && Objects.equals(this.unfulfillableQuantity, inventoryDetails.unfulfillableQuantity);
    }

    public int hashCode() {
        return Objects.hash(this.fulfillableQuantity, this.inboundWorkingQuantity, this.inboundShippedQuantity, this.inboundReceivingQuantity, this.reservedQuantity, this.researchingQuantity, this.unfulfillableQuantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventoryDetails {\n");
        sb.append("    fulfillableQuantity: ").append(this.toIndentedString(this.fulfillableQuantity)).append("\n");
        sb.append("    inboundWorkingQuantity: ").append(this.toIndentedString(this.inboundWorkingQuantity)).append("\n");
        sb.append("    inboundShippedQuantity: ").append(this.toIndentedString(this.inboundShippedQuantity)).append("\n");
        sb.append("    inboundReceivingQuantity: ").append(this.toIndentedString(this.inboundReceivingQuantity)).append("\n");
        sb.append("    reservedQuantity: ").append(this.toIndentedString(this.reservedQuantity)).append("\n");
        sb.append("    researchingQuantity: ").append(this.toIndentedString(this.researchingQuantity)).append("\n");
        sb.append("    unfulfillableQuantity: ").append(this.toIndentedString(this.unfulfillableQuantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

