/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fba.inventory.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Describes a granularity at which inventory data can be aggregated. For example, if you use Marketplace granularity, the fulfillable quantity will reflect inventory that could be fulfilled in the given marketplace.")
public class Granularity {
    @SerializedName(value="granularityType")
    private String granularityType = null;
    @SerializedName(value="granularityId")
    private String granularityId = null;

    public Granularity granularityType(String granularityType) {
        this.granularityType = granularityType;
        return this;
    }

    @Schema(description="The granularity type for the inventory aggregation level.")
    public String getGranularityType() {
        return this.granularityType;
    }

    public void setGranularityType(String granularityType) {
        this.granularityType = granularityType;
    }

    public Granularity granularityId(String granularityId) {
        this.granularityId = granularityId;
        return this;
    }

    @Schema(description="The granularity ID for the specified granularity type. When granularityType is Marketplace, specify the marketplaceId.")
    public String getGranularityId() {
        return this.granularityId;
    }

    public void setGranularityId(String granularityId) {
        this.granularityId = granularityId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Granularity granularity = (Granularity)o;
        return Objects.equals(this.granularityType, granularity.granularityType) && Objects.equals(this.granularityId, granularity.granularityId);
    }

    public int hashCode() {
        return Objects.hash(this.granularityType, this.granularityId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Granularity {\n");
        sb.append("    granularityType: ").append(this.toIndentedString(this.granularityType)).append("\n");
        sb.append("    granularityId: ").append(this.toIndentedString(this.granularityId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

