/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.easyship.v2022_03_23;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.easyship.v2022_03_23.ModelPackage;
import software.amazon.spapi.models.easyship.v2022_03_23.RejectedOrder;

@Schema(description="The response schema for the bulk scheduling API. It returns by the bulk scheduling API containing an array of the scheduled packtages, an optional list of orders we couldn't schedule with the reason, and a pre-signed URL for a ZIP file containing the associated shipping labels plus the documents enabled for your marketplace.")
public class CreateScheduledPackagesResponse {
    @SerializedName(value="scheduledPackages")
    private List<ModelPackage> scheduledPackages = null;
    @SerializedName(value="rejectedOrders")
    private List<RejectedOrder> rejectedOrders = null;
    @SerializedName(value="printableDocumentsUrl")
    private String printableDocumentsUrl = null;

    public CreateScheduledPackagesResponse scheduledPackages(List<ModelPackage> scheduledPackages) {
        this.scheduledPackages = scheduledPackages;
        return this;
    }

    public CreateScheduledPackagesResponse addScheduledPackagesItem(ModelPackage scheduledPackagesItem) {
        if (this.scheduledPackages == null) {
            this.scheduledPackages = new ArrayList<ModelPackage>();
        }
        this.scheduledPackages.add(scheduledPackagesItem);
        return this;
    }

    @Schema(description="A list of packages. Refer to the `Package` object.")
    public List<ModelPackage> getScheduledPackages() {
        return this.scheduledPackages;
    }

    public void setScheduledPackages(List<ModelPackage> scheduledPackages) {
        this.scheduledPackages = scheduledPackages;
    }

    public CreateScheduledPackagesResponse rejectedOrders(List<RejectedOrder> rejectedOrders) {
        this.rejectedOrders = rejectedOrders;
        return this;
    }

    public CreateScheduledPackagesResponse addRejectedOrdersItem(RejectedOrder rejectedOrdersItem) {
        if (this.rejectedOrders == null) {
            this.rejectedOrders = new ArrayList<RejectedOrder>();
        }
        this.rejectedOrders.add(rejectedOrdersItem);
        return this;
    }

    @Schema(description="A list of orders we couldn't scheduled on your behalf. Each element contains the reason and details on the error.")
    public List<RejectedOrder> getRejectedOrders() {
        return this.rejectedOrders;
    }

    public void setRejectedOrders(List<RejectedOrder> rejectedOrders) {
        this.rejectedOrders = rejectedOrders;
    }

    public CreateScheduledPackagesResponse printableDocumentsUrl(String printableDocumentsUrl) {
        this.printableDocumentsUrl = printableDocumentsUrl;
        return this;
    }

    @Schema(description="")
    public String getPrintableDocumentsUrl() {
        return this.printableDocumentsUrl;
    }

    public void setPrintableDocumentsUrl(String printableDocumentsUrl) {
        this.printableDocumentsUrl = printableDocumentsUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateScheduledPackagesResponse createScheduledPackagesResponse = (CreateScheduledPackagesResponse)o;
        return Objects.equals(this.scheduledPackages, createScheduledPackagesResponse.scheduledPackages) && Objects.equals(this.rejectedOrders, createScheduledPackagesResponse.rejectedOrders) && Objects.equals(this.printableDocumentsUrl, createScheduledPackagesResponse.printableDocumentsUrl);
    }

    public int hashCode() {
        return Objects.hash(this.scheduledPackages, this.rejectedOrders, this.printableDocumentsUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateScheduledPackagesResponse {\n");
        sb.append("    scheduledPackages: ").append(this.toIndentedString(this.scheduledPackages)).append("\n");
        sb.append("    rejectedOrders: ").append(this.toIndentedString(this.rejectedOrders)).append("\n");
        sb.append("    printableDocumentsUrl: ").append(this.toIndentedString(this.printableDocumentsUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

