/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.customerfeedback.v2024_06_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.ChildAsinMetrics;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.ItemReviewBrowseNodeMetrics;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.ItemReviewSubtopic;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.ItemReviewTopicMetrics;

@Schema(description="Details of item review topic.")
public class ItemReviewTopic {
    @SerializedName(value="topic")
    private String topic = null;
    @SerializedName(value="asinMetrics")
    private ItemReviewTopicMetrics asinMetrics = null;
    @SerializedName(value="parentAsinMetrics")
    private ItemReviewTopicMetrics parentAsinMetrics = null;
    @SerializedName(value="browseNodeMetrics")
    private ItemReviewBrowseNodeMetrics browseNodeMetrics = null;
    @SerializedName(value="childAsinMetrics")
    private ChildAsinMetrics childAsinMetrics = null;
    @SerializedName(value="reviewSnippets")
    private List<String> reviewSnippets = null;
    @SerializedName(value="subtopics")
    private List<ItemReviewSubtopic> subtopics = null;

    public ItemReviewTopic topic(String topic) {
        this.topic = topic;
        return this;
    }

    @Schema(required=true, description="The name of the item review topic.")
    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public ItemReviewTopic asinMetrics(ItemReviewTopicMetrics asinMetrics) {
        this.asinMetrics = asinMetrics;
        return this;
    }

    @Schema(required=true, description="")
    public ItemReviewTopicMetrics getAsinMetrics() {
        return this.asinMetrics;
    }

    public void setAsinMetrics(ItemReviewTopicMetrics asinMetrics) {
        this.asinMetrics = asinMetrics;
    }

    public ItemReviewTopic parentAsinMetrics(ItemReviewTopicMetrics parentAsinMetrics) {
        this.parentAsinMetrics = parentAsinMetrics;
        return this;
    }

    @Schema(description="")
    public ItemReviewTopicMetrics getParentAsinMetrics() {
        return this.parentAsinMetrics;
    }

    public void setParentAsinMetrics(ItemReviewTopicMetrics parentAsinMetrics) {
        this.parentAsinMetrics = parentAsinMetrics;
    }

    public ItemReviewTopic browseNodeMetrics(ItemReviewBrowseNodeMetrics browseNodeMetrics) {
        this.browseNodeMetrics = browseNodeMetrics;
        return this;
    }

    @Schema(description="")
    public ItemReviewBrowseNodeMetrics getBrowseNodeMetrics() {
        return this.browseNodeMetrics;
    }

    public void setBrowseNodeMetrics(ItemReviewBrowseNodeMetrics browseNodeMetrics) {
        this.browseNodeMetrics = browseNodeMetrics;
    }

    public ItemReviewTopic childAsinMetrics(ChildAsinMetrics childAsinMetrics) {
        this.childAsinMetrics = childAsinMetrics;
        return this;
    }

    @Schema(description="")
    public ChildAsinMetrics getChildAsinMetrics() {
        return this.childAsinMetrics;
    }

    public void setChildAsinMetrics(ChildAsinMetrics childAsinMetrics) {
        this.childAsinMetrics = childAsinMetrics;
    }

    public ItemReviewTopic reviewSnippets(List<String> reviewSnippets) {
        this.reviewSnippets = reviewSnippets;
        return this;
    }

    public ItemReviewTopic addReviewSnippetsItem(String reviewSnippetsItem) {
        if (this.reviewSnippets == null) {
            this.reviewSnippets = new ArrayList<String>();
        }
        this.reviewSnippets.add(reviewSnippetsItem);
        return this;
    }

    @Schema(description="A list of up to three snippets from reviews that contain the topic. This value is `null` if there aren't enough review snippets for the topic.")
    public List<String> getReviewSnippets() {
        return this.reviewSnippets;
    }

    public void setReviewSnippets(List<String> reviewSnippets) {
        this.reviewSnippets = reviewSnippets;
    }

    public ItemReviewTopic subtopics(List<ItemReviewSubtopic> subtopics) {
        this.subtopics = subtopics;
        return this;
    }

    public ItemReviewTopic addSubtopicsItem(ItemReviewSubtopic subtopicsItem) {
        if (this.subtopics == null) {
            this.subtopics = new ArrayList<ItemReviewSubtopic>();
        }
        this.subtopics.add(subtopicsItem);
        return this;
    }

    @Schema(description="A list of up to five top subtopics for the topic. The percentage of customer reviews that mention the subtopic determine the topic's placement in the list. This value is `null` if there are no subtopics.")
    public List<ItemReviewSubtopic> getSubtopics() {
        return this.subtopics;
    }

    public void setSubtopics(List<ItemReviewSubtopic> subtopics) {
        this.subtopics = subtopics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemReviewTopic itemReviewTopic = (ItemReviewTopic)o;
        return Objects.equals(this.topic, itemReviewTopic.topic) && Objects.equals(this.asinMetrics, itemReviewTopic.asinMetrics) && Objects.equals(this.parentAsinMetrics, itemReviewTopic.parentAsinMetrics) && Objects.equals(this.browseNodeMetrics, itemReviewTopic.browseNodeMetrics) && Objects.equals(this.childAsinMetrics, itemReviewTopic.childAsinMetrics) && Objects.equals(this.reviewSnippets, itemReviewTopic.reviewSnippets) && Objects.equals(this.subtopics, itemReviewTopic.subtopics);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.asinMetrics, this.parentAsinMetrics, this.browseNodeMetrics, this.childAsinMetrics, this.reviewSnippets, this.subtopics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemReviewTopic {\n");
        sb.append("    topic: ").append(this.toIndentedString(this.topic)).append("\n");
        sb.append("    asinMetrics: ").append(this.toIndentedString(this.asinMetrics)).append("\n");
        sb.append("    parentAsinMetrics: ").append(this.toIndentedString(this.parentAsinMetrics)).append("\n");
        sb.append("    browseNodeMetrics: ").append(this.toIndentedString(this.browseNodeMetrics)).append("\n");
        sb.append("    childAsinMetrics: ").append(this.toIndentedString(this.childAsinMetrics)).append("\n");
        sb.append("    reviewSnippets: ").append(this.toIndentedString(this.reviewSnippets)).append("\n");
        sb.append("    subtopics: ").append(this.toIndentedString(this.subtopics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

