/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.customerfeedback.v2024_06_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.ItemReviewSubtopicMetrics;

@Schema(description="Details of the subtopic for an item review topic.")
public class ItemReviewSubtopic {
    @SerializedName(value="subtopic")
    private String subtopic = null;
    @SerializedName(value="metrics")
    private ItemReviewSubtopicMetrics metrics = null;
    @SerializedName(value="reviewSnippets")
    private List<String> reviewSnippets = null;

    public ItemReviewSubtopic subtopic(String subtopic) {
        this.subtopic = subtopic;
        return this;
    }

    @Schema(required=true, description="The name of the subtopic.")
    public String getSubtopic() {
        return this.subtopic;
    }

    public void setSubtopic(String subtopic) {
        this.subtopic = subtopic;
    }

    public ItemReviewSubtopic metrics(ItemReviewSubtopicMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    @Schema(required=true, description="")
    public ItemReviewSubtopicMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(ItemReviewSubtopicMetrics metrics) {
        this.metrics = metrics;
    }

    public ItemReviewSubtopic reviewSnippets(List<String> reviewSnippets) {
        this.reviewSnippets = reviewSnippets;
        return this;
    }

    public ItemReviewSubtopic addReviewSnippetsItem(String reviewSnippetsItem) {
        if (this.reviewSnippets == null) {
            this.reviewSnippets = new ArrayList<String>();
        }
        this.reviewSnippets.add(reviewSnippetsItem);
        return this;
    }

    @Schema(description="A list of up to three snippets from reviews that contain the subtopic. This value is `null` if there aren't enough review snippets for the subtopic.")
    public List<String> getReviewSnippets() {
        return this.reviewSnippets;
    }

    public void setReviewSnippets(List<String> reviewSnippets) {
        this.reviewSnippets = reviewSnippets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemReviewSubtopic itemReviewSubtopic = (ItemReviewSubtopic)o;
        return Objects.equals(this.subtopic, itemReviewSubtopic.subtopic) && Objects.equals(this.metrics, itemReviewSubtopic.metrics) && Objects.equals(this.reviewSnippets, itemReviewSubtopic.reviewSnippets);
    }

    public int hashCode() {
        return Objects.hash(this.subtopic, this.metrics, this.reviewSnippets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemReviewSubtopic {\n");
        sb.append("    subtopic: ").append(this.toIndentedString(this.subtopic)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    reviewSnippets: ").append(this.toIndentedString(this.reviewSnippets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

