/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.catalogitems.v2022_04_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="The value of an individual dimension for an Amazon catalog item or item package.")
public class Dimension {
    @SerializedName(value="unit")
    private String unit = null;
    @SerializedName(value="value")
    private BigDecimal value = null;

    public Dimension unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Schema(description="Unit of measurement for the dimension value.")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Dimension value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @Schema(description="Numeric value of the dimension.")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dimension dimension = (Dimension)o;
        return Objects.equals(this.unit, dimension.unit) && Objects.equals(this.value, dimension.value);
    }

    public int hashCode() {
        return Objects.hash(this.unit, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Dimension {\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

