/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Represents one ineligibility reason for the order (there can be multiple reasons).")
public class OrderIneligibilityReason {
    @SerializedName(value="code")
    private String code = null;
    @SerializedName(value="description")
    private String description = null;

    public OrderIneligibilityReason code(String code) {
        this.code = code;
        return this;
    }

    @Schema(example="INVALID_MSKU", required=true, description="Code for the order ineligibility.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public OrderIneligibilityReason description(String description) {
        this.description = description;
        return this;
    }

    @Schema(example="The MSKU passed as part of order is invalid", required=true, description="Description detailing the ineligibility reason of the order.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderIneligibilityReason orderIneligibilityReason = (OrderIneligibilityReason)o;
        return Objects.equals(this.code, orderIneligibilityReason.code) && Objects.equals(this.description, orderIneligibilityReason.description);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderIneligibilityReason {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

