/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.awd.v2024_05_09.ExpirationDetails;
import software.amazon.spapi.models.awd.v2024_05_09.InventoryDetails;

@Schema(description="Summary of inventory per SKU.")
public class InventorySummary {
    @SerializedName(value="expirationDetails")
    private List<ExpirationDetails> expirationDetails = null;
    @SerializedName(value="inventoryDetails")
    private InventoryDetails inventoryDetails = null;
    @SerializedName(value="sku")
    private String sku = null;
    @SerializedName(value="totalInboundQuantity")
    private Long totalInboundQuantity = null;
    @SerializedName(value="totalOnhandQuantity")
    private Long totalOnhandQuantity = null;

    public InventorySummary expirationDetails(List<ExpirationDetails> expirationDetails) {
        this.expirationDetails = expirationDetails;
        return this;
    }

    public InventorySummary addExpirationDetailsItem(ExpirationDetails expirationDetailsItem) {
        if (this.expirationDetails == null) {
            this.expirationDetails = new ArrayList<ExpirationDetails>();
        }
        this.expirationDetails.add(expirationDetailsItem);
        return this;
    }

    @Schema(description="The expiration details of the inventory. This object will only appear if the `details` parameter in the request is set to `SHOW`.")
    public List<ExpirationDetails> getExpirationDetails() {
        return this.expirationDetails;
    }

    public void setExpirationDetails(List<ExpirationDetails> expirationDetails) {
        this.expirationDetails = expirationDetails;
    }

    public InventorySummary inventoryDetails(InventoryDetails inventoryDetails) {
        this.inventoryDetails = inventoryDetails;
        return this;
    }

    @Schema(description="")
    public InventoryDetails getInventoryDetails() {
        return this.inventoryDetails;
    }

    public void setInventoryDetails(InventoryDetails inventoryDetails) {
        this.inventoryDetails = inventoryDetails;
    }

    public InventorySummary sku(String sku) {
        this.sku = sku;
        return this;
    }

    @Schema(required=true, description="The seller or merchant SKU.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public InventorySummary totalInboundQuantity(Long totalInboundQuantity) {
        this.totalInboundQuantity = totalInboundQuantity;
        return this;
    }

    @Schema(description="Total quantity that is in-transit from the seller and has not yet been received at an AWD Distribution Center")
    public Long getTotalInboundQuantity() {
        return this.totalInboundQuantity;
    }

    public void setTotalInboundQuantity(Long totalInboundQuantity) {
        this.totalInboundQuantity = totalInboundQuantity;
    }

    public InventorySummary totalOnhandQuantity(Long totalOnhandQuantity) {
        this.totalOnhandQuantity = totalOnhandQuantity;
        return this;
    }

    @Schema(description="Total quantity that is present in AWD distribution centers.")
    public Long getTotalOnhandQuantity() {
        return this.totalOnhandQuantity;
    }

    public void setTotalOnhandQuantity(Long totalOnhandQuantity) {
        this.totalOnhandQuantity = totalOnhandQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventorySummary inventorySummary = (InventorySummary)o;
        return Objects.equals(this.expirationDetails, inventorySummary.expirationDetails) && Objects.equals(this.inventoryDetails, inventorySummary.inventoryDetails) && Objects.equals(this.sku, inventorySummary.sku) && Objects.equals(this.totalInboundQuantity, inventorySummary.totalInboundQuantity) && Objects.equals(this.totalOnhandQuantity, inventorySummary.totalOnhandQuantity);
    }

    public int hashCode() {
        return Objects.hash(this.expirationDetails, this.inventoryDetails, this.sku, this.totalInboundQuantity, this.totalOnhandQuantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventorySummary {\n");
        sb.append("    expirationDetails: ").append(this.toIndentedString(this.expirationDetails)).append("\n");
        sb.append("    inventoryDetails: ").append(this.toIndentedString(this.inventoryDetails)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    totalInboundQuantity: ").append(this.toIndentedString(this.totalInboundQuantity)).append("\n");
        sb.append("    totalOnhandQuantity: ").append(this.toIndentedString(this.totalOnhandQuantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

