/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.awd.v2024_05_09.DistributionPackageQuantity;
import software.amazon.spapi.models.awd.v2024_05_09.ProductQuantity;

@Schema(description="Represents the contents inside a package, which can be products or a nested package.")
public class DistributionPackageContents {
    @SerializedName(value="packages")
    private List<DistributionPackageQuantity> packages = null;
    @SerializedName(value="products")
    private List<ProductQuantity> products = null;

    public DistributionPackageContents packages(List<DistributionPackageQuantity> packages) {
        this.packages = packages;
        return this;
    }

    public DistributionPackageContents addPackagesItem(DistributionPackageQuantity packagesItem) {
        if (this.packages == null) {
            this.packages = new ArrayList<DistributionPackageQuantity>();
        }
        this.packages.add(packagesItem);
        return this;
    }

    @Schema(description="This is required only when `DistributionPackageType=PALLET`.")
    public List<DistributionPackageQuantity> getPackages() {
        return this.packages;
    }

    public void setPackages(List<DistributionPackageQuantity> packages) {
        this.packages = packages;
    }

    public DistributionPackageContents products(List<ProductQuantity> products) {
        this.products = products;
        return this;
    }

    public DistributionPackageContents addProductsItem(ProductQuantity productsItem) {
        if (this.products == null) {
            this.products = new ArrayList<ProductQuantity>();
        }
        this.products.add(productsItem);
        return this;
    }

    @Schema(description="This is required only when `DistributionPackageType=CASE`.")
    public List<ProductQuantity> getProducts() {
        return this.products;
    }

    public void setProducts(List<ProductQuantity> products) {
        this.products = products;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributionPackageContents distributionPackageContents = (DistributionPackageContents)o;
        return Objects.equals(this.packages, distributionPackageContents.packages) && Objects.equals(this.products, distributionPackageContents.products);
    }

    public int hashCode() {
        return Objects.hash(this.packages, this.products);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DistributionPackageContents {\n");
        sb.append("    packages: ").append(this.toIndentedString(this.packages)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

