/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.appintegrations.v2024_04_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="The request for the `deleteNotifications` operation.")
public class DeleteNotificationsRequest {
    @SerializedName(value="templateId")
    private String templateId = null;
    @SerializedName(value="deletionReason")
    private DeletionReasonEnum deletionReason = null;

    public DeleteNotificationsRequest templateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    @Schema(required=true, description="The unique identifier of the notification template you used to onboard your application.")
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public DeleteNotificationsRequest deletionReason(DeletionReasonEnum deletionReason) {
        this.deletionReason = deletionReason;
        return this;
    }

    @Schema(required=true, description="The unique identifier that maps each notification status to a reason code.")
    public DeletionReasonEnum getDeletionReason() {
        return this.deletionReason;
    }

    public void setDeletionReason(DeletionReasonEnum deletionReason) {
        this.deletionReason = deletionReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteNotificationsRequest deleteNotificationsRequest = (DeleteNotificationsRequest)o;
        return Objects.equals(this.templateId, deleteNotificationsRequest.templateId) && Objects.equals((Object)this.deletionReason, (Object)deleteNotificationsRequest.deletionReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.templateId, this.deletionReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteNotificationsRequest {\n");
        sb.append("    templateId: ").append(this.toIndentedString(this.templateId)).append("\n");
        sb.append("    deletionReason: ").append(this.toIndentedString((Object)this.deletionReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DeletionReasonEnum {
        CONTENT("INCORRECT_CONTENT"),
        RECIPIENT("INCORRECT_RECIPIENT");

        private String value;

        private DeletionReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DeletionReasonEnum fromValue(String input) {
            for (DeletionReasonEnum b : DeletionReasonEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DeletionReasonEnum> {
            public void write(JsonWriter jsonWriter, DeletionReasonEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public DeletionReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DeletionReasonEnum.fromValue(value);
            }
        }
    }
}

