/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.apluscontent.v2020_11_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.apluscontent.v2020_11_01.ImageComponent;
import software.amazon.spapi.models.apluscontent.v2020_11_01.PlainTextItem;

@Schema(description="The A+ Content standard comparison product block.")
public class StandardComparisonProductBlock {
    @SerializedName(value="position")
    private Integer position = null;
    @SerializedName(value="image")
    private ImageComponent image = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="highlight")
    private Boolean highlight = null;
    @SerializedName(value="metrics")
    private List<PlainTextItem> metrics = null;

    public StandardComparisonProductBlock position(Integer position) {
        this.position = position;
        return this;
    }

    @Schema(required=true, description="The rank or index of this comparison product block within the module. Different blocks cannot occupy the same position within a single module.")
    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public StandardComparisonProductBlock image(ImageComponent image) {
        this.image = image;
        return this;
    }

    @Schema(description="")
    public ImageComponent getImage() {
        return this.image;
    }

    public void setImage(ImageComponent image) {
        this.image = image;
    }

    public StandardComparisonProductBlock title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="The comparison product title.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public StandardComparisonProductBlock asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(description="")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public StandardComparisonProductBlock highlight(Boolean highlight) {
        this.highlight = highlight;
        return this;
    }

    @Schema(description="When true, indicates that this content block is visually highlighted.")
    public Boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(Boolean highlight) {
        this.highlight = highlight;
    }

    public StandardComparisonProductBlock metrics(List<PlainTextItem> metrics) {
        this.metrics = metrics;
        return this;
    }

    public StandardComparisonProductBlock addMetricsItem(PlainTextItem metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<PlainTextItem>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @Schema(description="Comparison metrics for the product.")
    public List<PlainTextItem> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<PlainTextItem> metrics) {
        this.metrics = metrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardComparisonProductBlock standardComparisonProductBlock = (StandardComparisonProductBlock)o;
        return Objects.equals(this.position, standardComparisonProductBlock.position) && Objects.equals(this.image, standardComparisonProductBlock.image) && Objects.equals(this.title, standardComparisonProductBlock.title) && Objects.equals(this.asin, standardComparisonProductBlock.asin) && Objects.equals(this.highlight, standardComparisonProductBlock.highlight) && Objects.equals(this.metrics, standardComparisonProductBlock.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.image, this.title, this.asin, this.highlight, this.metrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StandardComparisonProductBlock {\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    highlight: ").append(this.toIndentedString(this.highlight)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

