/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.apluscontent.v2020_11_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.apluscontent.v2020_11_01.ImageCropSpecification;

@Schema(description="A reference to an image, hosted in the A+ Content media library.")
public class ImageComponent {
    @SerializedName(value="uploadDestinationId")
    private String uploadDestinationId = null;
    @SerializedName(value="imageCropSpecification")
    private ImageCropSpecification imageCropSpecification = null;
    @SerializedName(value="altText")
    private String altText = null;

    public ImageComponent uploadDestinationId(String uploadDestinationId) {
        this.uploadDestinationId = uploadDestinationId;
        return this;
    }

    @Schema(required=true, description="This identifier is provided by the [Uploads API](https://developer-docs.amazon.com/sp-api/reference/welcome-to-api-references).")
    public String getUploadDestinationId() {
        return this.uploadDestinationId;
    }

    public void setUploadDestinationId(String uploadDestinationId) {
        this.uploadDestinationId = uploadDestinationId;
    }

    public ImageComponent imageCropSpecification(ImageCropSpecification imageCropSpecification) {
        this.imageCropSpecification = imageCropSpecification;
        return this;
    }

    @Schema(required=true, description="")
    public ImageCropSpecification getImageCropSpecification() {
        return this.imageCropSpecification;
    }

    public void setImageCropSpecification(ImageCropSpecification imageCropSpecification) {
        this.imageCropSpecification = imageCropSpecification;
    }

    public ImageComponent altText(String altText) {
        this.altText = altText;
        return this;
    }

    @Schema(required=true, description="The alternative text for the image.")
    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageComponent imageComponent = (ImageComponent)o;
        return Objects.equals(this.uploadDestinationId, imageComponent.uploadDestinationId) && Objects.equals(this.imageCropSpecification, imageComponent.imageCropSpecification) && Objects.equals(this.altText, imageComponent.altText);
    }

    public int hashCode() {
        return Objects.hash(this.uploadDestinationId, this.imageCropSpecification, this.altText);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageComponent {\n");
        sb.append("    uploadDestinationId: ").append(this.toIndentedString(this.uploadDestinationId)).append("\n");
        sb.append("    imageCropSpecification: ").append(this.toIndentedString(this.imageCropSpecification)).append("\n");
        sb.append("    altText: ").append(this.toIndentedString(this.altText)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

