/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.supplysources.v2020_07_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.supplysources.v2020_07_01.CreateSupplySourceRequest;
import software.amazon.spapi.models.supplysources.v2020_07_01.CreateSupplySourceResponse;
import software.amazon.spapi.models.supplysources.v2020_07_01.ErrorList;
import software.amazon.spapi.models.supplysources.v2020_07_01.GetSupplySourcesResponse;
import software.amazon.spapi.models.supplysources.v2020_07_01.SupplySource;
import software.amazon.spapi.models.supplysources.v2020_07_01.UpdateSupplySourceRequest;
import software.amazon.spapi.models.supplysources.v2020_07_01.UpdateSupplySourceStatusRequest;

public class SupplySourcesApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket archiveSupplySourceBucket = Bucket.builder().addLimit(this.config.getLimit("SupplySourcesApi-archiveSupplySource")).build();
    public final Bucket createSupplySourceBucket = Bucket.builder().addLimit(this.config.getLimit("SupplySourcesApi-createSupplySource")).build();
    public final Bucket getSupplySourceBucket = Bucket.builder().addLimit(this.config.getLimit("SupplySourcesApi-getSupplySource")).build();
    public final Bucket getSupplySourcesBucket = Bucket.builder().addLimit(this.config.getLimit("SupplySourcesApi-getSupplySources")).build();
    public final Bucket updateSupplySourceBucket = Bucket.builder().addLimit(this.config.getLimit("SupplySourcesApi-updateSupplySource")).build();
    public final Bucket updateSupplySourceStatusBucket = Bucket.builder().addLimit(this.config.getLimit("SupplySourcesApi-updateSupplySourceStatus")).build();

    public SupplySourcesApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call archiveSupplySourceCall(String supplySourceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/supplySources/2020-07-01/supplySources/{supplySourceId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/supplySources/2020-07-01/supplySources/{supplySourceId}".replaceAll("\\{supplySourceId\\}", supplySourceId.toString()) : "/supplySources/2020-07-01/supplySources/{supplySourceId}".replaceAll("\\{supplySourceId\\}", this.apiClient.escapeString(supplySourceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call archiveSupplySourceValidateBeforeCall(String supplySourceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (supplySourceId == null) {
            throw new ApiException("Missing the required parameter 'supplySourceId' when calling archiveSupplySource(Async)");
        }
        return this.archiveSupplySourceCall(supplySourceId, progressRequestListener);
    }

    public ErrorList archiveSupplySource(String supplySourceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ErrorList> resp = this.archiveSupplySourceWithHttpInfo(supplySourceId, restrictedDataToken);
        return resp.getData();
    }

    public ErrorList archiveSupplySource(String supplySourceId) throws ApiException, LWAException {
        ApiResponse<ErrorList> resp = this.archiveSupplySourceWithHttpInfo(supplySourceId, null);
        return resp.getData();
    }

    public ApiResponse<ErrorList> archiveSupplySourceWithHttpInfo(String supplySourceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.archiveSupplySourceValidateBeforeCall(supplySourceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SupplySourcesApi-archiveSupplySource");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.archiveSupplySourceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ErrorList>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("archiveSupplySource operation exceeds rate limit");
    }

    public ApiResponse<ErrorList> archiveSupplySourceWithHttpInfo(String supplySourceId) throws ApiException, LWAException {
        return this.archiveSupplySourceWithHttpInfo(supplySourceId, null);
    }

    public Call archiveSupplySourceAsync(String supplySourceId, ApiCallback<ErrorList> callback) throws ApiException, LWAException {
        return this.archiveSupplySourceAsync(supplySourceId, callback, null);
    }

    public Call archiveSupplySourceAsync(String supplySourceId, ApiCallback<ErrorList> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.archiveSupplySourceValidateBeforeCall(supplySourceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SupplySourcesApi-archiveSupplySource");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.archiveSupplySourceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ErrorList>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("archiveSupplySource operation exceeds rate limit");
    }

    private Call createSupplySourceCall(CreateSupplySourceRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateSupplySourceRequest localVarPostBody = body;
        String localVarPath = "/supplySources/2020-07-01/supplySources".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/supplySources/2020-07-01/supplySources" : "/supplySources/2020-07-01/supplySources";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createSupplySourceValidateBeforeCall(CreateSupplySourceRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createSupplySource(Async)");
        }
        return this.createSupplySourceCall(body, progressRequestListener);
    }

    public CreateSupplySourceResponse createSupplySource(CreateSupplySourceRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateSupplySourceResponse> resp = this.createSupplySourceWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateSupplySourceResponse createSupplySource(CreateSupplySourceRequest body) throws ApiException, LWAException {
        ApiResponse<CreateSupplySourceResponse> resp = this.createSupplySourceWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateSupplySourceResponse> createSupplySourceWithHttpInfo(CreateSupplySourceRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createSupplySourceValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SupplySourcesApi-createSupplySource");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createSupplySourceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateSupplySourceResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createSupplySource operation exceeds rate limit");
    }

    public ApiResponse<CreateSupplySourceResponse> createSupplySourceWithHttpInfo(CreateSupplySourceRequest body) throws ApiException, LWAException {
        return this.createSupplySourceWithHttpInfo(body, null);
    }

    public Call createSupplySourceAsync(CreateSupplySourceRequest body, ApiCallback<CreateSupplySourceResponse> callback) throws ApiException, LWAException {
        return this.createSupplySourceAsync(body, callback, null);
    }

    public Call createSupplySourceAsync(CreateSupplySourceRequest body, ApiCallback<CreateSupplySourceResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createSupplySourceValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SupplySourcesApi-createSupplySource");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createSupplySourceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateSupplySourceResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createSupplySource operation exceeds rate limit");
    }

    private Call getSupplySourceCall(String supplySourceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/supplySources/2020-07-01/supplySources/{supplySourceId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/supplySources/2020-07-01/supplySources/{supplySourceId}".replaceAll("\\{supplySourceId\\}", supplySourceId.toString()) : "/supplySources/2020-07-01/supplySources/{supplySourceId}".replaceAll("\\{supplySourceId\\}", this.apiClient.escapeString(supplySourceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getSupplySourceValidateBeforeCall(String supplySourceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (supplySourceId == null) {
            throw new ApiException("Missing the required parameter 'supplySourceId' when calling getSupplySource(Async)");
        }
        return this.getSupplySourceCall(supplySourceId, progressRequestListener);
    }

    public SupplySource getSupplySource(String supplySourceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<SupplySource> resp = this.getSupplySourceWithHttpInfo(supplySourceId, restrictedDataToken);
        return resp.getData();
    }

    public SupplySource getSupplySource(String supplySourceId) throws ApiException, LWAException {
        ApiResponse<SupplySource> resp = this.getSupplySourceWithHttpInfo(supplySourceId, null);
        return resp.getData();
    }

    public ApiResponse<SupplySource> getSupplySourceWithHttpInfo(String supplySourceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getSupplySourceValidateBeforeCall(supplySourceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SupplySourcesApi-getSupplySource");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getSupplySourceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SupplySource>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getSupplySource operation exceeds rate limit");
    }

    public ApiResponse<SupplySource> getSupplySourceWithHttpInfo(String supplySourceId) throws ApiException, LWAException {
        return this.getSupplySourceWithHttpInfo(supplySourceId, null);
    }

    public Call getSupplySourceAsync(String supplySourceId, ApiCallback<SupplySource> callback) throws ApiException, LWAException {
        return this.getSupplySourceAsync(supplySourceId, callback, null);
    }

    public Call getSupplySourceAsync(String supplySourceId, ApiCallback<SupplySource> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getSupplySourceValidateBeforeCall(supplySourceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SupplySourcesApi-getSupplySource");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getSupplySourceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SupplySource>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getSupplySource operation exceeds rate limit");
    }

    private Call getSupplySourcesCall(String nextPageToken, BigDecimal pageSize, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/supplySources/2020-07-01/supplySources".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/supplySources/2020-07-01/supplySources" : "/supplySources/2020-07-01/supplySources";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (nextPageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextPageToken", nextPageToken));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getSupplySourcesValidateBeforeCall(String nextPageToken, BigDecimal pageSize, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getSupplySourcesCall(nextPageToken, pageSize, progressRequestListener);
    }

    public GetSupplySourcesResponse getSupplySources(String nextPageToken, BigDecimal pageSize, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetSupplySourcesResponse> resp = this.getSupplySourcesWithHttpInfo(nextPageToken, pageSize, restrictedDataToken);
        return resp.getData();
    }

    public GetSupplySourcesResponse getSupplySources(String nextPageToken, BigDecimal pageSize) throws ApiException, LWAException {
        ApiResponse<GetSupplySourcesResponse> resp = this.getSupplySourcesWithHttpInfo(nextPageToken, pageSize, null);
        return resp.getData();
    }

    public ApiResponse<GetSupplySourcesResponse> getSupplySourcesWithHttpInfo(String nextPageToken, BigDecimal pageSize, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getSupplySourcesValidateBeforeCall(nextPageToken, pageSize, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SupplySourcesApi-getSupplySources");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getSupplySourcesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetSupplySourcesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getSupplySources operation exceeds rate limit");
    }

    public ApiResponse<GetSupplySourcesResponse> getSupplySourcesWithHttpInfo(String nextPageToken, BigDecimal pageSize) throws ApiException, LWAException {
        return this.getSupplySourcesWithHttpInfo(nextPageToken, pageSize, null);
    }

    public Call getSupplySourcesAsync(String nextPageToken, BigDecimal pageSize, ApiCallback<GetSupplySourcesResponse> callback) throws ApiException, LWAException {
        return this.getSupplySourcesAsync(nextPageToken, pageSize, callback, null);
    }

    public Call getSupplySourcesAsync(String nextPageToken, BigDecimal pageSize, ApiCallback<GetSupplySourcesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getSupplySourcesValidateBeforeCall(nextPageToken, pageSize, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SupplySourcesApi-getSupplySources");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getSupplySourcesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetSupplySourcesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getSupplySources operation exceeds rate limit");
    }

    private Call updateSupplySourceCall(String supplySourceId, UpdateSupplySourceRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        UpdateSupplySourceRequest localVarPostBody = body;
        String localVarPath = "/supplySources/2020-07-01/supplySources/{supplySourceId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/supplySources/2020-07-01/supplySources/{supplySourceId}".replaceAll("\\{supplySourceId\\}", supplySourceId.toString()) : "/supplySources/2020-07-01/supplySources/{supplySourceId}".replaceAll("\\{supplySourceId\\}", this.apiClient.escapeString(supplySourceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call updateSupplySourceValidateBeforeCall(String supplySourceId, UpdateSupplySourceRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (supplySourceId == null) {
            throw new ApiException("Missing the required parameter 'supplySourceId' when calling updateSupplySource(Async)");
        }
        return this.updateSupplySourceCall(supplySourceId, body, progressRequestListener);
    }

    public ErrorList updateSupplySource(String supplySourceId, UpdateSupplySourceRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ErrorList> resp = this.updateSupplySourceWithHttpInfo(supplySourceId, body, restrictedDataToken);
        return resp.getData();
    }

    public ErrorList updateSupplySource(String supplySourceId, UpdateSupplySourceRequest body) throws ApiException, LWAException {
        ApiResponse<ErrorList> resp = this.updateSupplySourceWithHttpInfo(supplySourceId, body, null);
        return resp.getData();
    }

    public ApiResponse<ErrorList> updateSupplySourceWithHttpInfo(String supplySourceId, UpdateSupplySourceRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.updateSupplySourceValidateBeforeCall(supplySourceId, body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SupplySourcesApi-updateSupplySource");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateSupplySourceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ErrorList>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("updateSupplySource operation exceeds rate limit");
    }

    public ApiResponse<ErrorList> updateSupplySourceWithHttpInfo(String supplySourceId, UpdateSupplySourceRequest body) throws ApiException, LWAException {
        return this.updateSupplySourceWithHttpInfo(supplySourceId, body, null);
    }

    public Call updateSupplySourceAsync(String supplySourceId, UpdateSupplySourceRequest body, ApiCallback<ErrorList> callback) throws ApiException, LWAException {
        return this.updateSupplySourceAsync(supplySourceId, body, callback, null);
    }

    public Call updateSupplySourceAsync(String supplySourceId, UpdateSupplySourceRequest body, ApiCallback<ErrorList> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.updateSupplySourceValidateBeforeCall(supplySourceId, body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SupplySourcesApi-updateSupplySource");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateSupplySourceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ErrorList>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("updateSupplySource operation exceeds rate limit");
    }

    private Call updateSupplySourceStatusCall(String supplySourceId, UpdateSupplySourceStatusRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        UpdateSupplySourceStatusRequest localVarPostBody = body;
        String localVarPath = "/supplySources/2020-07-01/supplySources/{supplySourceId}/status".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/supplySources/2020-07-01/supplySources/{supplySourceId}/status".replaceAll("\\{supplySourceId\\}", supplySourceId.toString()) : "/supplySources/2020-07-01/supplySources/{supplySourceId}/status".replaceAll("\\{supplySourceId\\}", this.apiClient.escapeString(supplySourceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call updateSupplySourceStatusValidateBeforeCall(String supplySourceId, UpdateSupplySourceStatusRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (supplySourceId == null) {
            throw new ApiException("Missing the required parameter 'supplySourceId' when calling updateSupplySourceStatus(Async)");
        }
        return this.updateSupplySourceStatusCall(supplySourceId, body, progressRequestListener);
    }

    public ErrorList updateSupplySourceStatus(String supplySourceId, UpdateSupplySourceStatusRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ErrorList> resp = this.updateSupplySourceStatusWithHttpInfo(supplySourceId, body, restrictedDataToken);
        return resp.getData();
    }

    public ErrorList updateSupplySourceStatus(String supplySourceId, UpdateSupplySourceStatusRequest body) throws ApiException, LWAException {
        ApiResponse<ErrorList> resp = this.updateSupplySourceStatusWithHttpInfo(supplySourceId, body, null);
        return resp.getData();
    }

    public ApiResponse<ErrorList> updateSupplySourceStatusWithHttpInfo(String supplySourceId, UpdateSupplySourceStatusRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.updateSupplySourceStatusValidateBeforeCall(supplySourceId, body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SupplySourcesApi-updateSupplySourceStatus");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateSupplySourceStatusBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ErrorList>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("updateSupplySourceStatus operation exceeds rate limit");
    }

    public ApiResponse<ErrorList> updateSupplySourceStatusWithHttpInfo(String supplySourceId, UpdateSupplySourceStatusRequest body) throws ApiException, LWAException {
        return this.updateSupplySourceStatusWithHttpInfo(supplySourceId, body, null);
    }

    public Call updateSupplySourceStatusAsync(String supplySourceId, UpdateSupplySourceStatusRequest body, ApiCallback<ErrorList> callback) throws ApiException, LWAException {
        return this.updateSupplySourceStatusAsync(supplySourceId, body, callback, null);
    }

    public Call updateSupplySourceStatusAsync(String supplySourceId, UpdateSupplySourceStatusRequest body, ApiCallback<ErrorList> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.updateSupplySourceStatusValidateBeforeCall(supplySourceId, body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SupplySourcesApi-updateSupplySourceStatus");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateSupplySourceStatusBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ErrorList>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("updateSupplySourceStatus operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public SupplySourcesApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new SupplySourcesApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

