/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.shipping.v2;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.shipping.v2.CancelShipmentResponse;
import software.amazon.spapi.models.shipping.v2.CreateClaimRequest;
import software.amazon.spapi.models.shipping.v2.CreateClaimResponse;
import software.amazon.spapi.models.shipping.v2.DirectPurchaseRequest;
import software.amazon.spapi.models.shipping.v2.DirectPurchaseResponse;
import software.amazon.spapi.models.shipping.v2.GenerateCollectionFormRequest;
import software.amazon.spapi.models.shipping.v2.GenerateCollectionFormResponse;
import software.amazon.spapi.models.shipping.v2.GetAccessPointsResponse;
import software.amazon.spapi.models.shipping.v2.GetAdditionalInputsResponse;
import software.amazon.spapi.models.shipping.v2.GetCarrierAccountFormInputsResponse;
import software.amazon.spapi.models.shipping.v2.GetCarrierAccountsRequest;
import software.amazon.spapi.models.shipping.v2.GetCarrierAccountsResponse;
import software.amazon.spapi.models.shipping.v2.GetCollectionFormHistoryRequest;
import software.amazon.spapi.models.shipping.v2.GetCollectionFormHistoryResponse;
import software.amazon.spapi.models.shipping.v2.GetCollectionFormResponse;
import software.amazon.spapi.models.shipping.v2.GetRatesRequest;
import software.amazon.spapi.models.shipping.v2.GetRatesResponse;
import software.amazon.spapi.models.shipping.v2.GetShipmentDocumentsResponse;
import software.amazon.spapi.models.shipping.v2.GetTrackingResponse;
import software.amazon.spapi.models.shipping.v2.GetUnmanifestedShipmentsRequest;
import software.amazon.spapi.models.shipping.v2.GetUnmanifestedShipmentsResponse;
import software.amazon.spapi.models.shipping.v2.LinkCarrierAccountRequest;
import software.amazon.spapi.models.shipping.v2.LinkCarrierAccountResponse;
import software.amazon.spapi.models.shipping.v2.OneClickShipmentRequest;
import software.amazon.spapi.models.shipping.v2.OneClickShipmentResponse;
import software.amazon.spapi.models.shipping.v2.PurchaseShipmentRequest;
import software.amazon.spapi.models.shipping.v2.PurchaseShipmentResponse;
import software.amazon.spapi.models.shipping.v2.SubmitNdrFeedbackRequest;
import software.amazon.spapi.models.shipping.v2.UnlinkCarrierAccountRequest;
import software.amazon.spapi.models.shipping.v2.UnlinkCarrierAccountResponse;

public class ShippingApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket cancelShipmentBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-cancelShipment")).build();
    public final Bucket createClaimBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-createClaim")).build();
    public final Bucket directPurchaseShipmentBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-directPurchaseShipment")).build();
    public final Bucket generateCollectionFormBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-generateCollectionForm")).build();
    public final Bucket getAccessPointsBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-getAccessPoints")).build();
    public final Bucket getAdditionalInputsBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-getAdditionalInputs")).build();
    public final Bucket getCarrierAccountFormInputsBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-getCarrierAccountFormInputs")).build();
    public final Bucket getCarrierAccountsBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-getCarrierAccounts")).build();
    public final Bucket getCollectionFormBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-getCollectionForm")).build();
    public final Bucket getCollectionFormHistoryBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-getCollectionFormHistory")).build();
    public final Bucket getRatesBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-getRates")).build();
    public final Bucket getShipmentDocumentsBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-getShipmentDocuments")).build();
    public final Bucket getTrackingBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-getTracking")).build();
    public final Bucket getUnmanifestedShipmentsBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-getUnmanifestedShipments")).build();
    public final Bucket linkCarrierAccountBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-linkCarrierAccount")).build();
    public final Bucket linkCarrierAccount_0Bucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-linkCarrierAccount_0")).build();
    public final Bucket oneClickShipmentBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-oneClickShipment")).build();
    public final Bucket purchaseShipmentBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-purchaseShipment")).build();
    public final Bucket submitNdrFeedbackBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-submitNdrFeedback")).build();
    public final Bucket unlinkCarrierAccountBucket = Bucket.builder().addLimit(this.config.getLimit("ShippingApi-unlinkCarrierAccount")).build();

    public ShippingApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call cancelShipmentCall(String shipmentId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/shipping/v2/shipments/{shipmentId}/cancel".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/shipments/{shipmentId}/cancel".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/shipping/v2/shipments/{shipmentId}/cancel".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call cancelShipmentValidateBeforeCall(String shipmentId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling cancelShipment(Async)");
        }
        return this.cancelShipmentCall(shipmentId, xAmznShippingBusinessId, progressRequestListener);
    }

    public CancelShipmentResponse cancelShipment(String shipmentId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CancelShipmentResponse> resp = this.cancelShipmentWithHttpInfo(shipmentId, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public CancelShipmentResponse cancelShipment(String shipmentId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<CancelShipmentResponse> resp = this.cancelShipmentWithHttpInfo(shipmentId, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<CancelShipmentResponse> cancelShipmentWithHttpInfo(String shipmentId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.cancelShipmentValidateBeforeCall(shipmentId, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-cancelShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CancelShipmentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("cancelShipment operation exceeds rate limit");
    }

    public ApiResponse<CancelShipmentResponse> cancelShipmentWithHttpInfo(String shipmentId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.cancelShipmentWithHttpInfo(shipmentId, xAmznShippingBusinessId, null);
    }

    public Call cancelShipmentAsync(String shipmentId, String xAmznShippingBusinessId, ApiCallback<CancelShipmentResponse> callback) throws ApiException, LWAException {
        return this.cancelShipmentAsync(shipmentId, xAmznShippingBusinessId, callback, null);
    }

    public Call cancelShipmentAsync(String shipmentId, String xAmznShippingBusinessId, ApiCallback<CancelShipmentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.cancelShipmentValidateBeforeCall(shipmentId, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-cancelShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CancelShipmentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("cancelShipment operation exceeds rate limit");
    }

    private Call createClaimCall(CreateClaimRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateClaimRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/claims".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/claims" : "/shipping/v2/claims";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createClaimValidateBeforeCall(CreateClaimRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createClaim(Async)");
        }
        return this.createClaimCall(body, xAmznShippingBusinessId, progressRequestListener);
    }

    public CreateClaimResponse createClaim(CreateClaimRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateClaimResponse> resp = this.createClaimWithHttpInfo(body, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public CreateClaimResponse createClaim(CreateClaimRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<CreateClaimResponse> resp = this.createClaimWithHttpInfo(body, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<CreateClaimResponse> createClaimWithHttpInfo(CreateClaimRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createClaimValidateBeforeCall(body, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-createClaim");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createClaimBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateClaimResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createClaim operation exceeds rate limit");
    }

    public ApiResponse<CreateClaimResponse> createClaimWithHttpInfo(CreateClaimRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.createClaimWithHttpInfo(body, xAmznShippingBusinessId, null);
    }

    public Call createClaimAsync(CreateClaimRequest body, String xAmznShippingBusinessId, ApiCallback<CreateClaimResponse> callback) throws ApiException, LWAException {
        return this.createClaimAsync(body, xAmznShippingBusinessId, callback, null);
    }

    public Call createClaimAsync(CreateClaimRequest body, String xAmznShippingBusinessId, ApiCallback<CreateClaimResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createClaimValidateBeforeCall(body, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-createClaim");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createClaimBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateClaimResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createClaim operation exceeds rate limit");
    }

    private Call directPurchaseShipmentCall(DirectPurchaseRequest body, String xAmznIdempotencyKey, String locale, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        DirectPurchaseRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/shipments/directPurchase".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/shipments/directPurchase" : "/shipping/v2/shipments/directPurchase";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznIdempotencyKey != null) {
            localVarHeaderParams.put("x-amzn-IdempotencyKey", this.apiClient.parameterToString(xAmznIdempotencyKey));
        }
        if (locale != null) {
            localVarHeaderParams.put("locale", this.apiClient.parameterToString(locale));
        }
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call directPurchaseShipmentValidateBeforeCall(DirectPurchaseRequest body, String xAmznIdempotencyKey, String locale, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling directPurchaseShipment(Async)");
        }
        return this.directPurchaseShipmentCall(body, xAmznIdempotencyKey, locale, xAmznShippingBusinessId, progressRequestListener);
    }

    public DirectPurchaseResponse directPurchaseShipment(DirectPurchaseRequest body, String xAmznIdempotencyKey, String locale, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<DirectPurchaseResponse> resp = this.directPurchaseShipmentWithHttpInfo(body, xAmznIdempotencyKey, locale, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public DirectPurchaseResponse directPurchaseShipment(DirectPurchaseRequest body, String xAmznIdempotencyKey, String locale, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<DirectPurchaseResponse> resp = this.directPurchaseShipmentWithHttpInfo(body, xAmznIdempotencyKey, locale, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<DirectPurchaseResponse> directPurchaseShipmentWithHttpInfo(DirectPurchaseRequest body, String xAmznIdempotencyKey, String locale, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.directPurchaseShipmentValidateBeforeCall(body, xAmznIdempotencyKey, locale, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-directPurchaseShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.directPurchaseShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<DirectPurchaseResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("directPurchaseShipment operation exceeds rate limit");
    }

    public ApiResponse<DirectPurchaseResponse> directPurchaseShipmentWithHttpInfo(DirectPurchaseRequest body, String xAmznIdempotencyKey, String locale, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.directPurchaseShipmentWithHttpInfo(body, xAmznIdempotencyKey, locale, xAmznShippingBusinessId, null);
    }

    public Call directPurchaseShipmentAsync(DirectPurchaseRequest body, String xAmznIdempotencyKey, String locale, String xAmznShippingBusinessId, ApiCallback<DirectPurchaseResponse> callback) throws ApiException, LWAException {
        return this.directPurchaseShipmentAsync(body, xAmznIdempotencyKey, locale, xAmznShippingBusinessId, callback, null);
    }

    public Call directPurchaseShipmentAsync(DirectPurchaseRequest body, String xAmznIdempotencyKey, String locale, String xAmznShippingBusinessId, ApiCallback<DirectPurchaseResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.directPurchaseShipmentValidateBeforeCall(body, xAmznIdempotencyKey, locale, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-directPurchaseShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.directPurchaseShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<DirectPurchaseResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("directPurchaseShipment operation exceeds rate limit");
    }

    private Call generateCollectionFormCall(GenerateCollectionFormRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GenerateCollectionFormRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/collectionForms".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/collectionForms" : "/shipping/v2/collectionForms";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznIdempotencyKey != null) {
            localVarHeaderParams.put("x-amzn-IdempotencyKey", this.apiClient.parameterToString(xAmznIdempotencyKey));
        }
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call generateCollectionFormValidateBeforeCall(GenerateCollectionFormRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling generateCollectionForm(Async)");
        }
        return this.generateCollectionFormCall(body, xAmznIdempotencyKey, xAmznShippingBusinessId, progressRequestListener);
    }

    public GenerateCollectionFormResponse generateCollectionForm(GenerateCollectionFormRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GenerateCollectionFormResponse> resp = this.generateCollectionFormWithHttpInfo(body, xAmznIdempotencyKey, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public GenerateCollectionFormResponse generateCollectionForm(GenerateCollectionFormRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<GenerateCollectionFormResponse> resp = this.generateCollectionFormWithHttpInfo(body, xAmznIdempotencyKey, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<GenerateCollectionFormResponse> generateCollectionFormWithHttpInfo(GenerateCollectionFormRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.generateCollectionFormValidateBeforeCall(body, xAmznIdempotencyKey, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-generateCollectionForm");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.generateCollectionFormBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GenerateCollectionFormResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("generateCollectionForm operation exceeds rate limit");
    }

    public ApiResponse<GenerateCollectionFormResponse> generateCollectionFormWithHttpInfo(GenerateCollectionFormRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.generateCollectionFormWithHttpInfo(body, xAmznIdempotencyKey, xAmznShippingBusinessId, null);
    }

    public Call generateCollectionFormAsync(GenerateCollectionFormRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId, ApiCallback<GenerateCollectionFormResponse> callback) throws ApiException, LWAException {
        return this.generateCollectionFormAsync(body, xAmznIdempotencyKey, xAmznShippingBusinessId, callback, null);
    }

    public Call generateCollectionFormAsync(GenerateCollectionFormRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId, ApiCallback<GenerateCollectionFormResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.generateCollectionFormValidateBeforeCall(body, xAmznIdempotencyKey, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-generateCollectionForm");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.generateCollectionFormBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GenerateCollectionFormResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("generateCollectionForm operation exceeds rate limit");
    }

    private Call getAccessPointsCall(List<String> accessPointTypes, String countryCode, String postalCode, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/shipping/v2/accessPoints".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/accessPoints" : "/shipping/v2/accessPoints";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accessPointTypes != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "accessPointTypes", accessPointTypes));
        }
        if (countryCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("countryCode", countryCode));
        }
        if (postalCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("postalCode", postalCode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getAccessPointsValidateBeforeCall(List<String> accessPointTypes, String countryCode, String postalCode, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (accessPointTypes == null) {
            throw new ApiException("Missing the required parameter 'accessPointTypes' when calling getAccessPoints(Async)");
        }
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling getAccessPoints(Async)");
        }
        if (postalCode == null) {
            throw new ApiException("Missing the required parameter 'postalCode' when calling getAccessPoints(Async)");
        }
        return this.getAccessPointsCall(accessPointTypes, countryCode, postalCode, xAmznShippingBusinessId, progressRequestListener);
    }

    public GetAccessPointsResponse getAccessPoints(List<String> accessPointTypes, String countryCode, String postalCode, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetAccessPointsResponse> resp = this.getAccessPointsWithHttpInfo(accessPointTypes, countryCode, postalCode, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public GetAccessPointsResponse getAccessPoints(List<String> accessPointTypes, String countryCode, String postalCode, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<GetAccessPointsResponse> resp = this.getAccessPointsWithHttpInfo(accessPointTypes, countryCode, postalCode, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<GetAccessPointsResponse> getAccessPointsWithHttpInfo(List<String> accessPointTypes, String countryCode, String postalCode, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getAccessPointsValidateBeforeCall(accessPointTypes, countryCode, postalCode, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getAccessPoints");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAccessPointsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAccessPointsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getAccessPoints operation exceeds rate limit");
    }

    public ApiResponse<GetAccessPointsResponse> getAccessPointsWithHttpInfo(List<String> accessPointTypes, String countryCode, String postalCode, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.getAccessPointsWithHttpInfo(accessPointTypes, countryCode, postalCode, xAmznShippingBusinessId, null);
    }

    public Call getAccessPointsAsync(List<String> accessPointTypes, String countryCode, String postalCode, String xAmznShippingBusinessId, ApiCallback<GetAccessPointsResponse> callback) throws ApiException, LWAException {
        return this.getAccessPointsAsync(accessPointTypes, countryCode, postalCode, xAmznShippingBusinessId, callback, null);
    }

    public Call getAccessPointsAsync(List<String> accessPointTypes, String countryCode, String postalCode, String xAmznShippingBusinessId, ApiCallback<GetAccessPointsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getAccessPointsValidateBeforeCall(accessPointTypes, countryCode, postalCode, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getAccessPoints");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAccessPointsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAccessPointsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getAccessPoints operation exceeds rate limit");
    }

    private Call getAdditionalInputsCall(String requestToken, String rateId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/shipping/v2/shipments/additionalInputs/schema".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/shipments/additionalInputs/schema" : "/shipping/v2/shipments/additionalInputs/schema";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (requestToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("requestToken", requestToken));
        }
        if (rateId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("rateId", rateId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getAdditionalInputsValidateBeforeCall(String requestToken, String rateId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (requestToken == null) {
            throw new ApiException("Missing the required parameter 'requestToken' when calling getAdditionalInputs(Async)");
        }
        if (rateId == null) {
            throw new ApiException("Missing the required parameter 'rateId' when calling getAdditionalInputs(Async)");
        }
        return this.getAdditionalInputsCall(requestToken, rateId, xAmznShippingBusinessId, progressRequestListener);
    }

    public GetAdditionalInputsResponse getAdditionalInputs(String requestToken, String rateId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetAdditionalInputsResponse> resp = this.getAdditionalInputsWithHttpInfo(requestToken, rateId, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public GetAdditionalInputsResponse getAdditionalInputs(String requestToken, String rateId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<GetAdditionalInputsResponse> resp = this.getAdditionalInputsWithHttpInfo(requestToken, rateId, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<GetAdditionalInputsResponse> getAdditionalInputsWithHttpInfo(String requestToken, String rateId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getAdditionalInputsValidateBeforeCall(requestToken, rateId, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getAdditionalInputs");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAdditionalInputsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAdditionalInputsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getAdditionalInputs operation exceeds rate limit");
    }

    public ApiResponse<GetAdditionalInputsResponse> getAdditionalInputsWithHttpInfo(String requestToken, String rateId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.getAdditionalInputsWithHttpInfo(requestToken, rateId, xAmznShippingBusinessId, null);
    }

    public Call getAdditionalInputsAsync(String requestToken, String rateId, String xAmznShippingBusinessId, ApiCallback<GetAdditionalInputsResponse> callback) throws ApiException, LWAException {
        return this.getAdditionalInputsAsync(requestToken, rateId, xAmznShippingBusinessId, callback, null);
    }

    public Call getAdditionalInputsAsync(String requestToken, String rateId, String xAmznShippingBusinessId, ApiCallback<GetAdditionalInputsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getAdditionalInputsValidateBeforeCall(requestToken, rateId, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getAdditionalInputs");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAdditionalInputsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAdditionalInputsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getAdditionalInputs operation exceeds rate limit");
    }

    private Call getCarrierAccountFormInputsCall(String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/shipping/v2/carrierAccountFormInputs".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/carrierAccountFormInputs" : "/shipping/v2/carrierAccountFormInputs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getCarrierAccountFormInputsValidateBeforeCall(String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getCarrierAccountFormInputsCall(xAmznShippingBusinessId, progressRequestListener);
    }

    public GetCarrierAccountFormInputsResponse getCarrierAccountFormInputs(String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetCarrierAccountFormInputsResponse> resp = this.getCarrierAccountFormInputsWithHttpInfo(xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public GetCarrierAccountFormInputsResponse getCarrierAccountFormInputs(String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<GetCarrierAccountFormInputsResponse> resp = this.getCarrierAccountFormInputsWithHttpInfo(xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<GetCarrierAccountFormInputsResponse> getCarrierAccountFormInputsWithHttpInfo(String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getCarrierAccountFormInputsValidateBeforeCall(xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getCarrierAccountFormInputs");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCarrierAccountFormInputsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetCarrierAccountFormInputsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getCarrierAccountFormInputs operation exceeds rate limit");
    }

    public ApiResponse<GetCarrierAccountFormInputsResponse> getCarrierAccountFormInputsWithHttpInfo(String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.getCarrierAccountFormInputsWithHttpInfo(xAmznShippingBusinessId, null);
    }

    public Call getCarrierAccountFormInputsAsync(String xAmznShippingBusinessId, ApiCallback<GetCarrierAccountFormInputsResponse> callback) throws ApiException, LWAException {
        return this.getCarrierAccountFormInputsAsync(xAmznShippingBusinessId, callback, null);
    }

    public Call getCarrierAccountFormInputsAsync(String xAmznShippingBusinessId, ApiCallback<GetCarrierAccountFormInputsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getCarrierAccountFormInputsValidateBeforeCall(xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getCarrierAccountFormInputs");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCarrierAccountFormInputsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetCarrierAccountFormInputsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getCarrierAccountFormInputs operation exceeds rate limit");
    }

    private Call getCarrierAccountsCall(GetCarrierAccountsRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetCarrierAccountsRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/carrierAccounts".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/carrierAccounts" : "/shipping/v2/carrierAccounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getCarrierAccountsValidateBeforeCall(GetCarrierAccountsRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getCarrierAccounts(Async)");
        }
        return this.getCarrierAccountsCall(body, xAmznShippingBusinessId, progressRequestListener);
    }

    public GetCarrierAccountsResponse getCarrierAccounts(GetCarrierAccountsRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetCarrierAccountsResponse> resp = this.getCarrierAccountsWithHttpInfo(body, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public GetCarrierAccountsResponse getCarrierAccounts(GetCarrierAccountsRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<GetCarrierAccountsResponse> resp = this.getCarrierAccountsWithHttpInfo(body, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<GetCarrierAccountsResponse> getCarrierAccountsWithHttpInfo(GetCarrierAccountsRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getCarrierAccountsValidateBeforeCall(body, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getCarrierAccounts");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCarrierAccountsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetCarrierAccountsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getCarrierAccounts operation exceeds rate limit");
    }

    public ApiResponse<GetCarrierAccountsResponse> getCarrierAccountsWithHttpInfo(GetCarrierAccountsRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.getCarrierAccountsWithHttpInfo(body, xAmznShippingBusinessId, null);
    }

    public Call getCarrierAccountsAsync(GetCarrierAccountsRequest body, String xAmznShippingBusinessId, ApiCallback<GetCarrierAccountsResponse> callback) throws ApiException, LWAException {
        return this.getCarrierAccountsAsync(body, xAmznShippingBusinessId, callback, null);
    }

    public Call getCarrierAccountsAsync(GetCarrierAccountsRequest body, String xAmznShippingBusinessId, ApiCallback<GetCarrierAccountsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getCarrierAccountsValidateBeforeCall(body, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getCarrierAccounts");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCarrierAccountsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetCarrierAccountsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getCarrierAccounts operation exceeds rate limit");
    }

    private Call getCollectionFormCall(String collectionFormId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/shipping/v2/collectionForms/{collectionFormId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/collectionForms/{collectionFormId}".replaceAll("\\{collectionFormId\\}", collectionFormId.toString()) : "/shipping/v2/collectionForms/{collectionFormId}".replaceAll("\\{collectionFormId\\}", this.apiClient.escapeString(collectionFormId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getCollectionFormValidateBeforeCall(String collectionFormId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (collectionFormId == null) {
            throw new ApiException("Missing the required parameter 'collectionFormId' when calling getCollectionForm(Async)");
        }
        return this.getCollectionFormCall(collectionFormId, xAmznShippingBusinessId, progressRequestListener);
    }

    public GetCollectionFormResponse getCollectionForm(String collectionFormId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetCollectionFormResponse> resp = this.getCollectionFormWithHttpInfo(collectionFormId, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public GetCollectionFormResponse getCollectionForm(String collectionFormId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<GetCollectionFormResponse> resp = this.getCollectionFormWithHttpInfo(collectionFormId, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<GetCollectionFormResponse> getCollectionFormWithHttpInfo(String collectionFormId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getCollectionFormValidateBeforeCall(collectionFormId, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getCollectionForm");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCollectionFormBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetCollectionFormResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getCollectionForm operation exceeds rate limit");
    }

    public ApiResponse<GetCollectionFormResponse> getCollectionFormWithHttpInfo(String collectionFormId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.getCollectionFormWithHttpInfo(collectionFormId, xAmznShippingBusinessId, null);
    }

    public Call getCollectionFormAsync(String collectionFormId, String xAmznShippingBusinessId, ApiCallback<GetCollectionFormResponse> callback) throws ApiException, LWAException {
        return this.getCollectionFormAsync(collectionFormId, xAmznShippingBusinessId, callback, null);
    }

    public Call getCollectionFormAsync(String collectionFormId, String xAmznShippingBusinessId, ApiCallback<GetCollectionFormResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getCollectionFormValidateBeforeCall(collectionFormId, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getCollectionForm");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCollectionFormBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetCollectionFormResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getCollectionForm operation exceeds rate limit");
    }

    private Call getCollectionFormHistoryCall(GetCollectionFormHistoryRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetCollectionFormHistoryRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/collectionForms/history".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/collectionForms/history" : "/shipping/v2/collectionForms/history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getCollectionFormHistoryValidateBeforeCall(GetCollectionFormHistoryRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getCollectionFormHistory(Async)");
        }
        return this.getCollectionFormHistoryCall(body, xAmznShippingBusinessId, progressRequestListener);
    }

    public GetCollectionFormHistoryResponse getCollectionFormHistory(GetCollectionFormHistoryRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetCollectionFormHistoryResponse> resp = this.getCollectionFormHistoryWithHttpInfo(body, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public GetCollectionFormHistoryResponse getCollectionFormHistory(GetCollectionFormHistoryRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<GetCollectionFormHistoryResponse> resp = this.getCollectionFormHistoryWithHttpInfo(body, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<GetCollectionFormHistoryResponse> getCollectionFormHistoryWithHttpInfo(GetCollectionFormHistoryRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getCollectionFormHistoryValidateBeforeCall(body, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getCollectionFormHistory");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCollectionFormHistoryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetCollectionFormHistoryResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getCollectionFormHistory operation exceeds rate limit");
    }

    public ApiResponse<GetCollectionFormHistoryResponse> getCollectionFormHistoryWithHttpInfo(GetCollectionFormHistoryRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.getCollectionFormHistoryWithHttpInfo(body, xAmznShippingBusinessId, null);
    }

    public Call getCollectionFormHistoryAsync(GetCollectionFormHistoryRequest body, String xAmznShippingBusinessId, ApiCallback<GetCollectionFormHistoryResponse> callback) throws ApiException, LWAException {
        return this.getCollectionFormHistoryAsync(body, xAmznShippingBusinessId, callback, null);
    }

    public Call getCollectionFormHistoryAsync(GetCollectionFormHistoryRequest body, String xAmznShippingBusinessId, ApiCallback<GetCollectionFormHistoryResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getCollectionFormHistoryValidateBeforeCall(body, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getCollectionFormHistory");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCollectionFormHistoryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetCollectionFormHistoryResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getCollectionFormHistory operation exceeds rate limit");
    }

    private Call getRatesCall(GetRatesRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetRatesRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/shipments/rates".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/shipments/rates" : "/shipping/v2/shipments/rates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getRatesValidateBeforeCall(GetRatesRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getRates(Async)");
        }
        return this.getRatesCall(body, xAmznShippingBusinessId, progressRequestListener);
    }

    public GetRatesResponse getRates(GetRatesRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetRatesResponse> resp = this.getRatesWithHttpInfo(body, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public GetRatesResponse getRates(GetRatesRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<GetRatesResponse> resp = this.getRatesWithHttpInfo(body, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<GetRatesResponse> getRatesWithHttpInfo(GetRatesRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getRatesValidateBeforeCall(body, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getRates");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getRatesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetRatesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getRates operation exceeds rate limit");
    }

    public ApiResponse<GetRatesResponse> getRatesWithHttpInfo(GetRatesRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.getRatesWithHttpInfo(body, xAmznShippingBusinessId, null);
    }

    public Call getRatesAsync(GetRatesRequest body, String xAmznShippingBusinessId, ApiCallback<GetRatesResponse> callback) throws ApiException, LWAException {
        return this.getRatesAsync(body, xAmznShippingBusinessId, callback, null);
    }

    public Call getRatesAsync(GetRatesRequest body, String xAmznShippingBusinessId, ApiCallback<GetRatesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getRatesValidateBeforeCall(body, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getRates");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getRatesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetRatesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getRates operation exceeds rate limit");
    }

    private Call getShipmentDocumentsCall(String shipmentId, String packageClientReferenceId, String format, BigDecimal dpi, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/shipping/v2/shipments/{shipmentId}/documents".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/shipments/{shipmentId}/documents".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/shipping/v2/shipments/{shipmentId}/documents".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (packageClientReferenceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("packageClientReferenceId", packageClientReferenceId));
        }
        if (format != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("format", format));
        }
        if (dpi != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dpi", dpi));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getShipmentDocumentsValidateBeforeCall(String shipmentId, String packageClientReferenceId, String format, BigDecimal dpi, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling getShipmentDocuments(Async)");
        }
        if (packageClientReferenceId == null) {
            throw new ApiException("Missing the required parameter 'packageClientReferenceId' when calling getShipmentDocuments(Async)");
        }
        return this.getShipmentDocumentsCall(shipmentId, packageClientReferenceId, format, dpi, xAmznShippingBusinessId, progressRequestListener);
    }

    public GetShipmentDocumentsResponse getShipmentDocuments(String shipmentId, String packageClientReferenceId, String format, BigDecimal dpi, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetShipmentDocumentsResponse> resp = this.getShipmentDocumentsWithHttpInfo(shipmentId, packageClientReferenceId, format, dpi, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public GetShipmentDocumentsResponse getShipmentDocuments(String shipmentId, String packageClientReferenceId, String format, BigDecimal dpi, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<GetShipmentDocumentsResponse> resp = this.getShipmentDocumentsWithHttpInfo(shipmentId, packageClientReferenceId, format, dpi, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<GetShipmentDocumentsResponse> getShipmentDocumentsWithHttpInfo(String shipmentId, String packageClientReferenceId, String format, BigDecimal dpi, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getShipmentDocumentsValidateBeforeCall(shipmentId, packageClientReferenceId, format, dpi, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getShipmentDocuments");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentDocumentsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentDocumentsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getShipmentDocuments operation exceeds rate limit");
    }

    public ApiResponse<GetShipmentDocumentsResponse> getShipmentDocumentsWithHttpInfo(String shipmentId, String packageClientReferenceId, String format, BigDecimal dpi, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.getShipmentDocumentsWithHttpInfo(shipmentId, packageClientReferenceId, format, dpi, xAmznShippingBusinessId, null);
    }

    public Call getShipmentDocumentsAsync(String shipmentId, String packageClientReferenceId, String format, BigDecimal dpi, String xAmznShippingBusinessId, ApiCallback<GetShipmentDocumentsResponse> callback) throws ApiException, LWAException {
        return this.getShipmentDocumentsAsync(shipmentId, packageClientReferenceId, format, dpi, xAmznShippingBusinessId, callback, null);
    }

    public Call getShipmentDocumentsAsync(String shipmentId, String packageClientReferenceId, String format, BigDecimal dpi, String xAmznShippingBusinessId, ApiCallback<GetShipmentDocumentsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getShipmentDocumentsValidateBeforeCall(shipmentId, packageClientReferenceId, format, dpi, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getShipmentDocuments");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentDocumentsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentDocumentsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getShipmentDocuments operation exceeds rate limit");
    }

    private Call getTrackingCall(String trackingId, String carrierId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/shipping/v2/tracking".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/tracking" : "/shipping/v2/tracking";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (trackingId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("trackingId", trackingId));
        }
        if (carrierId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("carrierId", carrierId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getTrackingValidateBeforeCall(String trackingId, String carrierId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (trackingId == null) {
            throw new ApiException("Missing the required parameter 'trackingId' when calling getTracking(Async)");
        }
        if (carrierId == null) {
            throw new ApiException("Missing the required parameter 'carrierId' when calling getTracking(Async)");
        }
        return this.getTrackingCall(trackingId, carrierId, xAmznShippingBusinessId, progressRequestListener);
    }

    public GetTrackingResponse getTracking(String trackingId, String carrierId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetTrackingResponse> resp = this.getTrackingWithHttpInfo(trackingId, carrierId, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public GetTrackingResponse getTracking(String trackingId, String carrierId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<GetTrackingResponse> resp = this.getTrackingWithHttpInfo(trackingId, carrierId, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<GetTrackingResponse> getTrackingWithHttpInfo(String trackingId, String carrierId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getTrackingValidateBeforeCall(trackingId, carrierId, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getTracking");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getTrackingBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetTrackingResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getTracking operation exceeds rate limit");
    }

    public ApiResponse<GetTrackingResponse> getTrackingWithHttpInfo(String trackingId, String carrierId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.getTrackingWithHttpInfo(trackingId, carrierId, xAmznShippingBusinessId, null);
    }

    public Call getTrackingAsync(String trackingId, String carrierId, String xAmznShippingBusinessId, ApiCallback<GetTrackingResponse> callback) throws ApiException, LWAException {
        return this.getTrackingAsync(trackingId, carrierId, xAmznShippingBusinessId, callback, null);
    }

    public Call getTrackingAsync(String trackingId, String carrierId, String xAmznShippingBusinessId, ApiCallback<GetTrackingResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getTrackingValidateBeforeCall(trackingId, carrierId, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getTracking");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getTrackingBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetTrackingResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getTracking operation exceeds rate limit");
    }

    private Call getUnmanifestedShipmentsCall(GetUnmanifestedShipmentsRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetUnmanifestedShipmentsRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/unmanifestedShipments".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/unmanifestedShipments" : "/shipping/v2/unmanifestedShipments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getUnmanifestedShipmentsValidateBeforeCall(GetUnmanifestedShipmentsRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getUnmanifestedShipments(Async)");
        }
        return this.getUnmanifestedShipmentsCall(body, xAmznShippingBusinessId, progressRequestListener);
    }

    public GetUnmanifestedShipmentsResponse getUnmanifestedShipments(GetUnmanifestedShipmentsRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetUnmanifestedShipmentsResponse> resp = this.getUnmanifestedShipmentsWithHttpInfo(body, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public GetUnmanifestedShipmentsResponse getUnmanifestedShipments(GetUnmanifestedShipmentsRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<GetUnmanifestedShipmentsResponse> resp = this.getUnmanifestedShipmentsWithHttpInfo(body, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<GetUnmanifestedShipmentsResponse> getUnmanifestedShipmentsWithHttpInfo(GetUnmanifestedShipmentsRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getUnmanifestedShipmentsValidateBeforeCall(body, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getUnmanifestedShipments");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getUnmanifestedShipmentsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetUnmanifestedShipmentsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getUnmanifestedShipments operation exceeds rate limit");
    }

    public ApiResponse<GetUnmanifestedShipmentsResponse> getUnmanifestedShipmentsWithHttpInfo(GetUnmanifestedShipmentsRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.getUnmanifestedShipmentsWithHttpInfo(body, xAmznShippingBusinessId, null);
    }

    public Call getUnmanifestedShipmentsAsync(GetUnmanifestedShipmentsRequest body, String xAmznShippingBusinessId, ApiCallback<GetUnmanifestedShipmentsResponse> callback) throws ApiException, LWAException {
        return this.getUnmanifestedShipmentsAsync(body, xAmznShippingBusinessId, callback, null);
    }

    public Call getUnmanifestedShipmentsAsync(GetUnmanifestedShipmentsRequest body, String xAmznShippingBusinessId, ApiCallback<GetUnmanifestedShipmentsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getUnmanifestedShipmentsValidateBeforeCall(body, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-getUnmanifestedShipments");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getUnmanifestedShipmentsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetUnmanifestedShipmentsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getUnmanifestedShipments operation exceeds rate limit");
    }

    private Call linkCarrierAccountCall(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        LinkCarrierAccountRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/carrierAccounts/{carrierId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/carrierAccounts/{carrierId}".replaceAll("\\{carrierId\\}", carrierId.toString()) : "/shipping/v2/carrierAccounts/{carrierId}".replaceAll("\\{carrierId\\}", this.apiClient.escapeString(carrierId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call linkCarrierAccountValidateBeforeCall(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling linkCarrierAccount(Async)");
        }
        if (carrierId == null) {
            throw new ApiException("Missing the required parameter 'carrierId' when calling linkCarrierAccount(Async)");
        }
        return this.linkCarrierAccountCall(body, carrierId, xAmznShippingBusinessId, progressRequestListener);
    }

    public LinkCarrierAccountResponse linkCarrierAccount(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<LinkCarrierAccountResponse> resp = this.linkCarrierAccountWithHttpInfo(body, carrierId, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public LinkCarrierAccountResponse linkCarrierAccount(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<LinkCarrierAccountResponse> resp = this.linkCarrierAccountWithHttpInfo(body, carrierId, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<LinkCarrierAccountResponse> linkCarrierAccountWithHttpInfo(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.linkCarrierAccountValidateBeforeCall(body, carrierId, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-linkCarrierAccount");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.linkCarrierAccountBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<LinkCarrierAccountResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("linkCarrierAccount operation exceeds rate limit");
    }

    public ApiResponse<LinkCarrierAccountResponse> linkCarrierAccountWithHttpInfo(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.linkCarrierAccountWithHttpInfo(body, carrierId, xAmznShippingBusinessId, null);
    }

    public Call linkCarrierAccountAsync(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, ApiCallback<LinkCarrierAccountResponse> callback) throws ApiException, LWAException {
        return this.linkCarrierAccountAsync(body, carrierId, xAmznShippingBusinessId, callback, null);
    }

    public Call linkCarrierAccountAsync(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, ApiCallback<LinkCarrierAccountResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.linkCarrierAccountValidateBeforeCall(body, carrierId, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-linkCarrierAccount");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.linkCarrierAccountBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<LinkCarrierAccountResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("linkCarrierAccount operation exceeds rate limit");
    }

    private Call linkCarrierAccount_0Call(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        LinkCarrierAccountRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/carrierAccounts/{carrierId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/carrierAccounts/{carrierId}".replaceAll("\\{carrierId\\}", carrierId.toString()) : "/shipping/v2/carrierAccounts/{carrierId}".replaceAll("\\{carrierId\\}", this.apiClient.escapeString(carrierId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call linkCarrierAccount_0ValidateBeforeCall(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling linkCarrierAccount_0(Async)");
        }
        if (carrierId == null) {
            throw new ApiException("Missing the required parameter 'carrierId' when calling linkCarrierAccount_0(Async)");
        }
        return this.linkCarrierAccount_0Call(body, carrierId, xAmznShippingBusinessId, progressRequestListener);
    }

    public LinkCarrierAccountResponse linkCarrierAccount_0(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<LinkCarrierAccountResponse> resp = this.linkCarrierAccount_0WithHttpInfo(body, carrierId, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public LinkCarrierAccountResponse linkCarrierAccount_0(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<LinkCarrierAccountResponse> resp = this.linkCarrierAccount_0WithHttpInfo(body, carrierId, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<LinkCarrierAccountResponse> linkCarrierAccount_0WithHttpInfo(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.linkCarrierAccount_0ValidateBeforeCall(body, carrierId, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-linkCarrierAccount_0");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.linkCarrierAccount_0Bucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<LinkCarrierAccountResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("linkCarrierAccount_0 operation exceeds rate limit");
    }

    public ApiResponse<LinkCarrierAccountResponse> linkCarrierAccount_0WithHttpInfo(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.linkCarrierAccount_0WithHttpInfo(body, carrierId, xAmznShippingBusinessId, null);
    }

    public Call linkCarrierAccount_0Async(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, ApiCallback<LinkCarrierAccountResponse> callback) throws ApiException, LWAException {
        return this.linkCarrierAccount_0Async(body, carrierId, xAmznShippingBusinessId, callback, null);
    }

    public Call linkCarrierAccount_0Async(LinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, ApiCallback<LinkCarrierAccountResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.linkCarrierAccount_0ValidateBeforeCall(body, carrierId, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-linkCarrierAccount_0");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.linkCarrierAccount_0Bucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<LinkCarrierAccountResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("linkCarrierAccount_0 operation exceeds rate limit");
    }

    private Call oneClickShipmentCall(OneClickShipmentRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        OneClickShipmentRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/oneClickShipment".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/oneClickShipment" : "/shipping/v2/oneClickShipment";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call oneClickShipmentValidateBeforeCall(OneClickShipmentRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling oneClickShipment(Async)");
        }
        return this.oneClickShipmentCall(body, xAmznShippingBusinessId, progressRequestListener);
    }

    public OneClickShipmentResponse oneClickShipment(OneClickShipmentRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<OneClickShipmentResponse> resp = this.oneClickShipmentWithHttpInfo(body, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public OneClickShipmentResponse oneClickShipment(OneClickShipmentRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<OneClickShipmentResponse> resp = this.oneClickShipmentWithHttpInfo(body, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<OneClickShipmentResponse> oneClickShipmentWithHttpInfo(OneClickShipmentRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.oneClickShipmentValidateBeforeCall(body, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-oneClickShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.oneClickShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<OneClickShipmentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("oneClickShipment operation exceeds rate limit");
    }

    public ApiResponse<OneClickShipmentResponse> oneClickShipmentWithHttpInfo(OneClickShipmentRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.oneClickShipmentWithHttpInfo(body, xAmznShippingBusinessId, null);
    }

    public Call oneClickShipmentAsync(OneClickShipmentRequest body, String xAmznShippingBusinessId, ApiCallback<OneClickShipmentResponse> callback) throws ApiException, LWAException {
        return this.oneClickShipmentAsync(body, xAmznShippingBusinessId, callback, null);
    }

    public Call oneClickShipmentAsync(OneClickShipmentRequest body, String xAmznShippingBusinessId, ApiCallback<OneClickShipmentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.oneClickShipmentValidateBeforeCall(body, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-oneClickShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.oneClickShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<OneClickShipmentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("oneClickShipment operation exceeds rate limit");
    }

    private Call purchaseShipmentCall(PurchaseShipmentRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        PurchaseShipmentRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/shipments".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/shipments" : "/shipping/v2/shipments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznIdempotencyKey != null) {
            localVarHeaderParams.put("x-amzn-IdempotencyKey", this.apiClient.parameterToString(xAmznIdempotencyKey));
        }
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call purchaseShipmentValidateBeforeCall(PurchaseShipmentRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling purchaseShipment(Async)");
        }
        return this.purchaseShipmentCall(body, xAmznIdempotencyKey, xAmznShippingBusinessId, progressRequestListener);
    }

    public PurchaseShipmentResponse purchaseShipment(PurchaseShipmentRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<PurchaseShipmentResponse> resp = this.purchaseShipmentWithHttpInfo(body, xAmznIdempotencyKey, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public PurchaseShipmentResponse purchaseShipment(PurchaseShipmentRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<PurchaseShipmentResponse> resp = this.purchaseShipmentWithHttpInfo(body, xAmznIdempotencyKey, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<PurchaseShipmentResponse> purchaseShipmentWithHttpInfo(PurchaseShipmentRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.purchaseShipmentValidateBeforeCall(body, xAmznIdempotencyKey, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-purchaseShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.purchaseShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PurchaseShipmentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("purchaseShipment operation exceeds rate limit");
    }

    public ApiResponse<PurchaseShipmentResponse> purchaseShipmentWithHttpInfo(PurchaseShipmentRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.purchaseShipmentWithHttpInfo(body, xAmznIdempotencyKey, xAmznShippingBusinessId, null);
    }

    public Call purchaseShipmentAsync(PurchaseShipmentRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId, ApiCallback<PurchaseShipmentResponse> callback) throws ApiException, LWAException {
        return this.purchaseShipmentAsync(body, xAmznIdempotencyKey, xAmznShippingBusinessId, callback, null);
    }

    public Call purchaseShipmentAsync(PurchaseShipmentRequest body, String xAmznIdempotencyKey, String xAmznShippingBusinessId, ApiCallback<PurchaseShipmentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.purchaseShipmentValidateBeforeCall(body, xAmznIdempotencyKey, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-purchaseShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.purchaseShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PurchaseShipmentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("purchaseShipment operation exceeds rate limit");
    }

    private Call submitNdrFeedbackCall(SubmitNdrFeedbackRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        SubmitNdrFeedbackRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/ndrFeedback".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/ndrFeedback" : "/shipping/v2/ndrFeedback";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call submitNdrFeedbackValidateBeforeCall(SubmitNdrFeedbackRequest body, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling submitNdrFeedback(Async)");
        }
        return this.submitNdrFeedbackCall(body, xAmznShippingBusinessId, progressRequestListener);
    }

    public void submitNdrFeedback(SubmitNdrFeedbackRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        this.submitNdrFeedbackWithHttpInfo(body, xAmznShippingBusinessId, restrictedDataToken);
    }

    public void submitNdrFeedback(SubmitNdrFeedbackRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        this.submitNdrFeedbackWithHttpInfo(body, xAmznShippingBusinessId, null);
    }

    public ApiResponse<Void> submitNdrFeedbackWithHttpInfo(SubmitNdrFeedbackRequest body, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.submitNdrFeedbackValidateBeforeCall(body, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-submitNdrFeedback");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitNdrFeedbackBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("submitNdrFeedback operation exceeds rate limit");
    }

    public ApiResponse<Void> submitNdrFeedbackWithHttpInfo(SubmitNdrFeedbackRequest body, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.submitNdrFeedbackWithHttpInfo(body, xAmznShippingBusinessId, null);
    }

    public Call submitNdrFeedbackAsync(SubmitNdrFeedbackRequest body, String xAmznShippingBusinessId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.submitNdrFeedbackAsync(body, xAmznShippingBusinessId, callback, null);
    }

    public Call submitNdrFeedbackAsync(SubmitNdrFeedbackRequest body, String xAmznShippingBusinessId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.submitNdrFeedbackValidateBeforeCall(body, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-submitNdrFeedback");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitNdrFeedbackBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("submitNdrFeedback operation exceeds rate limit");
    }

    private Call unlinkCarrierAccountCall(UnlinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        UnlinkCarrierAccountRequest localVarPostBody = body;
        String localVarPath = "/shipping/v2/carrierAccounts/{carrierId}/unlink".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/shipping/v2/carrierAccounts/{carrierId}/unlink".replaceAll("\\{carrierId\\}", carrierId.toString()) : "/shipping/v2/carrierAccounts/{carrierId}/unlink".replaceAll("\\{carrierId\\}", this.apiClient.escapeString(carrierId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xAmznShippingBusinessId != null) {
            localVarHeaderParams.put("x-amzn-shipping-business-id", this.apiClient.parameterToString(xAmznShippingBusinessId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call unlinkCarrierAccountValidateBeforeCall(UnlinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling unlinkCarrierAccount(Async)");
        }
        if (carrierId == null) {
            throw new ApiException("Missing the required parameter 'carrierId' when calling unlinkCarrierAccount(Async)");
        }
        return this.unlinkCarrierAccountCall(body, carrierId, xAmznShippingBusinessId, progressRequestListener);
    }

    public UnlinkCarrierAccountResponse unlinkCarrierAccount(UnlinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<UnlinkCarrierAccountResponse> resp = this.unlinkCarrierAccountWithHttpInfo(body, carrierId, xAmznShippingBusinessId, restrictedDataToken);
        return resp.getData();
    }

    public UnlinkCarrierAccountResponse unlinkCarrierAccount(UnlinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        ApiResponse<UnlinkCarrierAccountResponse> resp = this.unlinkCarrierAccountWithHttpInfo(body, carrierId, xAmznShippingBusinessId, null);
        return resp.getData();
    }

    public ApiResponse<UnlinkCarrierAccountResponse> unlinkCarrierAccountWithHttpInfo(UnlinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.unlinkCarrierAccountValidateBeforeCall(body, carrierId, xAmznShippingBusinessId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-unlinkCarrierAccount");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.unlinkCarrierAccountBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<UnlinkCarrierAccountResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("unlinkCarrierAccount operation exceeds rate limit");
    }

    public ApiResponse<UnlinkCarrierAccountResponse> unlinkCarrierAccountWithHttpInfo(UnlinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId) throws ApiException, LWAException {
        return this.unlinkCarrierAccountWithHttpInfo(body, carrierId, xAmznShippingBusinessId, null);
    }

    public Call unlinkCarrierAccountAsync(UnlinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, ApiCallback<UnlinkCarrierAccountResponse> callback) throws ApiException, LWAException {
        return this.unlinkCarrierAccountAsync(body, carrierId, xAmznShippingBusinessId, callback, null);
    }

    public Call unlinkCarrierAccountAsync(UnlinkCarrierAccountRequest body, String carrierId, String xAmznShippingBusinessId, ApiCallback<UnlinkCarrierAccountResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.unlinkCarrierAccountValidateBeforeCall(body, carrierId, xAmznShippingBusinessId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShippingApi-unlinkCarrierAccount");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.unlinkCarrierAccountBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<UnlinkCarrierAccountResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("unlinkCarrierAccount operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public ShippingApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new ShippingApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

