/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.pricing.v2022_05_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.pricing.v2022_05_01.CompetitiveSummaryBatchRequest;
import software.amazon.spapi.models.pricing.v2022_05_01.CompetitiveSummaryBatchResponse;
import software.amazon.spapi.models.pricing.v2022_05_01.GetFeaturedOfferExpectedPriceBatchRequest;
import software.amazon.spapi.models.pricing.v2022_05_01.GetFeaturedOfferExpectedPriceBatchResponse;

public class ProductPricingApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getCompetitiveSummaryBucket = Bucket.builder().addLimit(this.config.getLimit("ProductPricingApi-getCompetitiveSummary")).build();
    public final Bucket getFeaturedOfferExpectedPriceBatchBucket = Bucket.builder().addLimit(this.config.getLimit("ProductPricingApi-getFeaturedOfferExpectedPriceBatch")).build();

    public ProductPricingApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getCompetitiveSummaryCall(CompetitiveSummaryBatchRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CompetitiveSummaryBatchRequest localVarPostBody = body;
        String localVarPath = "/batches/products/pricing/2022-05-01/items/competitiveSummary".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/batches/products/pricing/2022-05-01/items/competitiveSummary" : "/batches/products/pricing/2022-05-01/items/competitiveSummary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getCompetitiveSummaryValidateBeforeCall(CompetitiveSummaryBatchRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getCompetitiveSummary(Async)");
        }
        return this.getCompetitiveSummaryCall(body, progressRequestListener);
    }

    public CompetitiveSummaryBatchResponse getCompetitiveSummary(CompetitiveSummaryBatchRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CompetitiveSummaryBatchResponse> resp = this.getCompetitiveSummaryWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CompetitiveSummaryBatchResponse getCompetitiveSummary(CompetitiveSummaryBatchRequest body) throws ApiException, LWAException {
        ApiResponse<CompetitiveSummaryBatchResponse> resp = this.getCompetitiveSummaryWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CompetitiveSummaryBatchResponse> getCompetitiveSummaryWithHttpInfo(CompetitiveSummaryBatchRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getCompetitiveSummaryValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getCompetitiveSummary");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCompetitiveSummaryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CompetitiveSummaryBatchResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getCompetitiveSummary operation exceeds rate limit");
    }

    public ApiResponse<CompetitiveSummaryBatchResponse> getCompetitiveSummaryWithHttpInfo(CompetitiveSummaryBatchRequest body) throws ApiException, LWAException {
        return this.getCompetitiveSummaryWithHttpInfo(body, null);
    }

    public Call getCompetitiveSummaryAsync(CompetitiveSummaryBatchRequest body, ApiCallback<CompetitiveSummaryBatchResponse> callback) throws ApiException, LWAException {
        return this.getCompetitiveSummaryAsync(body, callback, null);
    }

    public Call getCompetitiveSummaryAsync(CompetitiveSummaryBatchRequest body, ApiCallback<CompetitiveSummaryBatchResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getCompetitiveSummaryValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getCompetitiveSummary");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCompetitiveSummaryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CompetitiveSummaryBatchResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getCompetitiveSummary operation exceeds rate limit");
    }

    private Call getFeaturedOfferExpectedPriceBatchCall(GetFeaturedOfferExpectedPriceBatchRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetFeaturedOfferExpectedPriceBatchRequest localVarPostBody = body;
        String localVarPath = "/batches/products/pricing/2022-05-01/offer/featuredOfferExpectedPrice".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/batches/products/pricing/2022-05-01/offer/featuredOfferExpectedPrice" : "/batches/products/pricing/2022-05-01/offer/featuredOfferExpectedPrice";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getFeaturedOfferExpectedPriceBatchValidateBeforeCall(GetFeaturedOfferExpectedPriceBatchRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getFeaturedOfferExpectedPriceBatch(Async)");
        }
        return this.getFeaturedOfferExpectedPriceBatchCall(body, progressRequestListener);
    }

    public GetFeaturedOfferExpectedPriceBatchResponse getFeaturedOfferExpectedPriceBatch(GetFeaturedOfferExpectedPriceBatchRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetFeaturedOfferExpectedPriceBatchResponse> resp = this.getFeaturedOfferExpectedPriceBatchWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public GetFeaturedOfferExpectedPriceBatchResponse getFeaturedOfferExpectedPriceBatch(GetFeaturedOfferExpectedPriceBatchRequest body) throws ApiException, LWAException {
        ApiResponse<GetFeaturedOfferExpectedPriceBatchResponse> resp = this.getFeaturedOfferExpectedPriceBatchWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<GetFeaturedOfferExpectedPriceBatchResponse> getFeaturedOfferExpectedPriceBatchWithHttpInfo(GetFeaturedOfferExpectedPriceBatchRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getFeaturedOfferExpectedPriceBatchValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getFeaturedOfferExpectedPriceBatch");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeaturedOfferExpectedPriceBatchBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFeaturedOfferExpectedPriceBatchResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getFeaturedOfferExpectedPriceBatch operation exceeds rate limit");
    }

    public ApiResponse<GetFeaturedOfferExpectedPriceBatchResponse> getFeaturedOfferExpectedPriceBatchWithHttpInfo(GetFeaturedOfferExpectedPriceBatchRequest body) throws ApiException, LWAException {
        return this.getFeaturedOfferExpectedPriceBatchWithHttpInfo(body, null);
    }

    public Call getFeaturedOfferExpectedPriceBatchAsync(GetFeaturedOfferExpectedPriceBatchRequest body, ApiCallback<GetFeaturedOfferExpectedPriceBatchResponse> callback) throws ApiException, LWAException {
        return this.getFeaturedOfferExpectedPriceBatchAsync(body, callback, null);
    }

    public Call getFeaturedOfferExpectedPriceBatchAsync(GetFeaturedOfferExpectedPriceBatchRequest body, ApiCallback<GetFeaturedOfferExpectedPriceBatchResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getFeaturedOfferExpectedPriceBatchValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ProductPricingApi-getFeaturedOfferExpectedPriceBatch");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeaturedOfferExpectedPriceBatchBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFeaturedOfferExpectedPriceBatchResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getFeaturedOfferExpectedPriceBatch operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public ProductPricingApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new ProductPricingApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

