/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.messaging.v1;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.messaging.v1.CreateAmazonMotorsRequest;
import software.amazon.spapi.models.messaging.v1.CreateAmazonMotorsResponse;
import software.amazon.spapi.models.messaging.v1.CreateConfirmCustomizationDetailsRequest;
import software.amazon.spapi.models.messaging.v1.CreateConfirmCustomizationDetailsResponse;
import software.amazon.spapi.models.messaging.v1.CreateConfirmDeliveryDetailsRequest;
import software.amazon.spapi.models.messaging.v1.CreateConfirmDeliveryDetailsResponse;
import software.amazon.spapi.models.messaging.v1.CreateConfirmOrderDetailsRequest;
import software.amazon.spapi.models.messaging.v1.CreateConfirmOrderDetailsResponse;
import software.amazon.spapi.models.messaging.v1.CreateConfirmServiceDetailsRequest;
import software.amazon.spapi.models.messaging.v1.CreateConfirmServiceDetailsResponse;
import software.amazon.spapi.models.messaging.v1.CreateDigitalAccessKeyRequest;
import software.amazon.spapi.models.messaging.v1.CreateDigitalAccessKeyResponse;
import software.amazon.spapi.models.messaging.v1.CreateLegalDisclosureRequest;
import software.amazon.spapi.models.messaging.v1.CreateLegalDisclosureResponse;
import software.amazon.spapi.models.messaging.v1.CreateUnexpectedProblemRequest;
import software.amazon.spapi.models.messaging.v1.CreateUnexpectedProblemResponse;
import software.amazon.spapi.models.messaging.v1.CreateWarrantyRequest;
import software.amazon.spapi.models.messaging.v1.CreateWarrantyResponse;
import software.amazon.spapi.models.messaging.v1.GetAttributesResponse;
import software.amazon.spapi.models.messaging.v1.GetMessagingActionsForOrderResponse;
import software.amazon.spapi.models.messaging.v1.InvoiceRequest;
import software.amazon.spapi.models.messaging.v1.InvoiceResponse;

public class MessagingApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket confirmCustomizationDetailsBucket = Bucket.builder().addLimit(this.config.getLimit("MessagingApi-confirmCustomizationDetails")).build();
    public final Bucket createAmazonMotorsBucket = Bucket.builder().addLimit(this.config.getLimit("MessagingApi-createAmazonMotors")).build();
    public final Bucket createConfirmDeliveryDetailsBucket = Bucket.builder().addLimit(this.config.getLimit("MessagingApi-createConfirmDeliveryDetails")).build();
    public final Bucket createConfirmOrderDetailsBucket = Bucket.builder().addLimit(this.config.getLimit("MessagingApi-createConfirmOrderDetails")).build();
    public final Bucket createConfirmServiceDetailsBucket = Bucket.builder().addLimit(this.config.getLimit("MessagingApi-createConfirmServiceDetails")).build();
    public final Bucket createDigitalAccessKeyBucket = Bucket.builder().addLimit(this.config.getLimit("MessagingApi-createDigitalAccessKey")).build();
    public final Bucket createLegalDisclosureBucket = Bucket.builder().addLimit(this.config.getLimit("MessagingApi-createLegalDisclosure")).build();
    public final Bucket createUnexpectedProblemBucket = Bucket.builder().addLimit(this.config.getLimit("MessagingApi-createUnexpectedProblem")).build();
    public final Bucket createWarrantyBucket = Bucket.builder().addLimit(this.config.getLimit("MessagingApi-createWarranty")).build();
    public final Bucket getAttributesBucket = Bucket.builder().addLimit(this.config.getLimit("MessagingApi-getAttributes")).build();
    public final Bucket getMessagingActionsForOrderBucket = Bucket.builder().addLimit(this.config.getLimit("MessagingApi-getMessagingActionsForOrder")).build();
    public final Bucket sendInvoiceBucket = Bucket.builder().addLimit(this.config.getLimit("MessagingApi-sendInvoice")).build();

    public MessagingApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call confirmCustomizationDetailsCall(CreateConfirmCustomizationDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateConfirmCustomizationDetailsRequest localVarPostBody = body;
        String localVarPath = "/messaging/v1/orders/{amazonOrderId}/messages/confirmCustomizationDetails".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/messaging/v1/orders/{amazonOrderId}/messages/confirmCustomizationDetails".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/messaging/v1/orders/{amazonOrderId}/messages/confirmCustomizationDetails".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call confirmCustomizationDetailsValidateBeforeCall(CreateConfirmCustomizationDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling confirmCustomizationDetails(Async)");
        }
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling confirmCustomizationDetails(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling confirmCustomizationDetails(Async)");
        }
        return this.confirmCustomizationDetailsCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public CreateConfirmCustomizationDetailsResponse confirmCustomizationDetails(CreateConfirmCustomizationDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateConfirmCustomizationDetailsResponse> resp = this.confirmCustomizationDetailsWithHttpInfo(body, amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public CreateConfirmCustomizationDetailsResponse confirmCustomizationDetails(CreateConfirmCustomizationDetailsRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<CreateConfirmCustomizationDetailsResponse> resp = this.confirmCustomizationDetailsWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<CreateConfirmCustomizationDetailsResponse> confirmCustomizationDetailsWithHttpInfo(CreateConfirmCustomizationDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.confirmCustomizationDetailsValidateBeforeCall(body, amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-confirmCustomizationDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.confirmCustomizationDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateConfirmCustomizationDetailsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("confirmCustomizationDetails operation exceeds rate limit");
    }

    public ApiResponse<CreateConfirmCustomizationDetailsResponse> confirmCustomizationDetailsWithHttpInfo(CreateConfirmCustomizationDetailsRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.confirmCustomizationDetailsWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
    }

    public Call confirmCustomizationDetailsAsync(CreateConfirmCustomizationDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateConfirmCustomizationDetailsResponse> callback) throws ApiException, LWAException {
        return this.confirmCustomizationDetailsAsync(body, amazonOrderId, marketplaceIds, callback, null);
    }

    public Call confirmCustomizationDetailsAsync(CreateConfirmCustomizationDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateConfirmCustomizationDetailsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.confirmCustomizationDetailsValidateBeforeCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-confirmCustomizationDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.confirmCustomizationDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateConfirmCustomizationDetailsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("confirmCustomizationDetails operation exceeds rate limit");
    }

    private Call createAmazonMotorsCall(CreateAmazonMotorsRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateAmazonMotorsRequest localVarPostBody = body;
        String localVarPath = "/messaging/v1/orders/{amazonOrderId}/messages/amazonMotors".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/messaging/v1/orders/{amazonOrderId}/messages/amazonMotors".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/messaging/v1/orders/{amazonOrderId}/messages/amazonMotors".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createAmazonMotorsValidateBeforeCall(CreateAmazonMotorsRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createAmazonMotors(Async)");
        }
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling createAmazonMotors(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling createAmazonMotors(Async)");
        }
        return this.createAmazonMotorsCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public CreateAmazonMotorsResponse createAmazonMotors(CreateAmazonMotorsRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateAmazonMotorsResponse> resp = this.createAmazonMotorsWithHttpInfo(body, amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public CreateAmazonMotorsResponse createAmazonMotors(CreateAmazonMotorsRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<CreateAmazonMotorsResponse> resp = this.createAmazonMotorsWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<CreateAmazonMotorsResponse> createAmazonMotorsWithHttpInfo(CreateAmazonMotorsRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createAmazonMotorsValidateBeforeCall(body, amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createAmazonMotors");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createAmazonMotorsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateAmazonMotorsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createAmazonMotors operation exceeds rate limit");
    }

    public ApiResponse<CreateAmazonMotorsResponse> createAmazonMotorsWithHttpInfo(CreateAmazonMotorsRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.createAmazonMotorsWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
    }

    public Call createAmazonMotorsAsync(CreateAmazonMotorsRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateAmazonMotorsResponse> callback) throws ApiException, LWAException {
        return this.createAmazonMotorsAsync(body, amazonOrderId, marketplaceIds, callback, null);
    }

    public Call createAmazonMotorsAsync(CreateAmazonMotorsRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateAmazonMotorsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createAmazonMotorsValidateBeforeCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createAmazonMotors");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createAmazonMotorsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateAmazonMotorsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createAmazonMotors operation exceeds rate limit");
    }

    private Call createConfirmDeliveryDetailsCall(CreateConfirmDeliveryDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateConfirmDeliveryDetailsRequest localVarPostBody = body;
        String localVarPath = "/messaging/v1/orders/{amazonOrderId}/messages/confirmDeliveryDetails".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/messaging/v1/orders/{amazonOrderId}/messages/confirmDeliveryDetails".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/messaging/v1/orders/{amazonOrderId}/messages/confirmDeliveryDetails".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createConfirmDeliveryDetailsValidateBeforeCall(CreateConfirmDeliveryDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createConfirmDeliveryDetails(Async)");
        }
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling createConfirmDeliveryDetails(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling createConfirmDeliveryDetails(Async)");
        }
        return this.createConfirmDeliveryDetailsCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public CreateConfirmDeliveryDetailsResponse createConfirmDeliveryDetails(CreateConfirmDeliveryDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateConfirmDeliveryDetailsResponse> resp = this.createConfirmDeliveryDetailsWithHttpInfo(body, amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public CreateConfirmDeliveryDetailsResponse createConfirmDeliveryDetails(CreateConfirmDeliveryDetailsRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<CreateConfirmDeliveryDetailsResponse> resp = this.createConfirmDeliveryDetailsWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<CreateConfirmDeliveryDetailsResponse> createConfirmDeliveryDetailsWithHttpInfo(CreateConfirmDeliveryDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createConfirmDeliveryDetailsValidateBeforeCall(body, amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createConfirmDeliveryDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createConfirmDeliveryDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateConfirmDeliveryDetailsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createConfirmDeliveryDetails operation exceeds rate limit");
    }

    public ApiResponse<CreateConfirmDeliveryDetailsResponse> createConfirmDeliveryDetailsWithHttpInfo(CreateConfirmDeliveryDetailsRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.createConfirmDeliveryDetailsWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
    }

    public Call createConfirmDeliveryDetailsAsync(CreateConfirmDeliveryDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateConfirmDeliveryDetailsResponse> callback) throws ApiException, LWAException {
        return this.createConfirmDeliveryDetailsAsync(body, amazonOrderId, marketplaceIds, callback, null);
    }

    public Call createConfirmDeliveryDetailsAsync(CreateConfirmDeliveryDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateConfirmDeliveryDetailsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createConfirmDeliveryDetailsValidateBeforeCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createConfirmDeliveryDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createConfirmDeliveryDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateConfirmDeliveryDetailsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createConfirmDeliveryDetails operation exceeds rate limit");
    }

    private Call createConfirmOrderDetailsCall(CreateConfirmOrderDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateConfirmOrderDetailsRequest localVarPostBody = body;
        String localVarPath = "/messaging/v1/orders/{amazonOrderId}/messages/confirmOrderDetails".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/messaging/v1/orders/{amazonOrderId}/messages/confirmOrderDetails".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/messaging/v1/orders/{amazonOrderId}/messages/confirmOrderDetails".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createConfirmOrderDetailsValidateBeforeCall(CreateConfirmOrderDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createConfirmOrderDetails(Async)");
        }
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling createConfirmOrderDetails(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling createConfirmOrderDetails(Async)");
        }
        return this.createConfirmOrderDetailsCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public CreateConfirmOrderDetailsResponse createConfirmOrderDetails(CreateConfirmOrderDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateConfirmOrderDetailsResponse> resp = this.createConfirmOrderDetailsWithHttpInfo(body, amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public CreateConfirmOrderDetailsResponse createConfirmOrderDetails(CreateConfirmOrderDetailsRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<CreateConfirmOrderDetailsResponse> resp = this.createConfirmOrderDetailsWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<CreateConfirmOrderDetailsResponse> createConfirmOrderDetailsWithHttpInfo(CreateConfirmOrderDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createConfirmOrderDetailsValidateBeforeCall(body, amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createConfirmOrderDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createConfirmOrderDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateConfirmOrderDetailsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createConfirmOrderDetails operation exceeds rate limit");
    }

    public ApiResponse<CreateConfirmOrderDetailsResponse> createConfirmOrderDetailsWithHttpInfo(CreateConfirmOrderDetailsRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.createConfirmOrderDetailsWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
    }

    public Call createConfirmOrderDetailsAsync(CreateConfirmOrderDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateConfirmOrderDetailsResponse> callback) throws ApiException, LWAException {
        return this.createConfirmOrderDetailsAsync(body, amazonOrderId, marketplaceIds, callback, null);
    }

    public Call createConfirmOrderDetailsAsync(CreateConfirmOrderDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateConfirmOrderDetailsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createConfirmOrderDetailsValidateBeforeCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createConfirmOrderDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createConfirmOrderDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateConfirmOrderDetailsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createConfirmOrderDetails operation exceeds rate limit");
    }

    private Call createConfirmServiceDetailsCall(CreateConfirmServiceDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateConfirmServiceDetailsRequest localVarPostBody = body;
        String localVarPath = "/messaging/v1/orders/{amazonOrderId}/messages/confirmServiceDetails".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/messaging/v1/orders/{amazonOrderId}/messages/confirmServiceDetails".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/messaging/v1/orders/{amazonOrderId}/messages/confirmServiceDetails".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createConfirmServiceDetailsValidateBeforeCall(CreateConfirmServiceDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createConfirmServiceDetails(Async)");
        }
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling createConfirmServiceDetails(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling createConfirmServiceDetails(Async)");
        }
        return this.createConfirmServiceDetailsCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public CreateConfirmServiceDetailsResponse createConfirmServiceDetails(CreateConfirmServiceDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateConfirmServiceDetailsResponse> resp = this.createConfirmServiceDetailsWithHttpInfo(body, amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public CreateConfirmServiceDetailsResponse createConfirmServiceDetails(CreateConfirmServiceDetailsRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<CreateConfirmServiceDetailsResponse> resp = this.createConfirmServiceDetailsWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<CreateConfirmServiceDetailsResponse> createConfirmServiceDetailsWithHttpInfo(CreateConfirmServiceDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createConfirmServiceDetailsValidateBeforeCall(body, amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createConfirmServiceDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createConfirmServiceDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateConfirmServiceDetailsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createConfirmServiceDetails operation exceeds rate limit");
    }

    public ApiResponse<CreateConfirmServiceDetailsResponse> createConfirmServiceDetailsWithHttpInfo(CreateConfirmServiceDetailsRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.createConfirmServiceDetailsWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
    }

    public Call createConfirmServiceDetailsAsync(CreateConfirmServiceDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateConfirmServiceDetailsResponse> callback) throws ApiException, LWAException {
        return this.createConfirmServiceDetailsAsync(body, amazonOrderId, marketplaceIds, callback, null);
    }

    public Call createConfirmServiceDetailsAsync(CreateConfirmServiceDetailsRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateConfirmServiceDetailsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createConfirmServiceDetailsValidateBeforeCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createConfirmServiceDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createConfirmServiceDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateConfirmServiceDetailsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createConfirmServiceDetails operation exceeds rate limit");
    }

    private Call createDigitalAccessKeyCall(CreateDigitalAccessKeyRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateDigitalAccessKeyRequest localVarPostBody = body;
        String localVarPath = "/messaging/v1/orders/{amazonOrderId}/messages/digitalAccessKey".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/messaging/v1/orders/{amazonOrderId}/messages/digitalAccessKey".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/messaging/v1/orders/{amazonOrderId}/messages/digitalAccessKey".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createDigitalAccessKeyValidateBeforeCall(CreateDigitalAccessKeyRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDigitalAccessKey(Async)");
        }
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling createDigitalAccessKey(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling createDigitalAccessKey(Async)");
        }
        return this.createDigitalAccessKeyCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public CreateDigitalAccessKeyResponse createDigitalAccessKey(CreateDigitalAccessKeyRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateDigitalAccessKeyResponse> resp = this.createDigitalAccessKeyWithHttpInfo(body, amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public CreateDigitalAccessKeyResponse createDigitalAccessKey(CreateDigitalAccessKeyRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<CreateDigitalAccessKeyResponse> resp = this.createDigitalAccessKeyWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<CreateDigitalAccessKeyResponse> createDigitalAccessKeyWithHttpInfo(CreateDigitalAccessKeyRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createDigitalAccessKeyValidateBeforeCall(body, amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createDigitalAccessKey");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createDigitalAccessKeyBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateDigitalAccessKeyResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createDigitalAccessKey operation exceeds rate limit");
    }

    public ApiResponse<CreateDigitalAccessKeyResponse> createDigitalAccessKeyWithHttpInfo(CreateDigitalAccessKeyRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.createDigitalAccessKeyWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
    }

    public Call createDigitalAccessKeyAsync(CreateDigitalAccessKeyRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateDigitalAccessKeyResponse> callback) throws ApiException, LWAException {
        return this.createDigitalAccessKeyAsync(body, amazonOrderId, marketplaceIds, callback, null);
    }

    public Call createDigitalAccessKeyAsync(CreateDigitalAccessKeyRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateDigitalAccessKeyResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createDigitalAccessKeyValidateBeforeCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createDigitalAccessKey");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createDigitalAccessKeyBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateDigitalAccessKeyResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createDigitalAccessKey operation exceeds rate limit");
    }

    private Call createLegalDisclosureCall(CreateLegalDisclosureRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateLegalDisclosureRequest localVarPostBody = body;
        String localVarPath = "/messaging/v1/orders/{amazonOrderId}/messages/legalDisclosure".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/messaging/v1/orders/{amazonOrderId}/messages/legalDisclosure".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/messaging/v1/orders/{amazonOrderId}/messages/legalDisclosure".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createLegalDisclosureValidateBeforeCall(CreateLegalDisclosureRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createLegalDisclosure(Async)");
        }
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling createLegalDisclosure(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling createLegalDisclosure(Async)");
        }
        return this.createLegalDisclosureCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public CreateLegalDisclosureResponse createLegalDisclosure(CreateLegalDisclosureRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateLegalDisclosureResponse> resp = this.createLegalDisclosureWithHttpInfo(body, amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public CreateLegalDisclosureResponse createLegalDisclosure(CreateLegalDisclosureRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<CreateLegalDisclosureResponse> resp = this.createLegalDisclosureWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<CreateLegalDisclosureResponse> createLegalDisclosureWithHttpInfo(CreateLegalDisclosureRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createLegalDisclosureValidateBeforeCall(body, amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createLegalDisclosure");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createLegalDisclosureBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateLegalDisclosureResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createLegalDisclosure operation exceeds rate limit");
    }

    public ApiResponse<CreateLegalDisclosureResponse> createLegalDisclosureWithHttpInfo(CreateLegalDisclosureRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.createLegalDisclosureWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
    }

    public Call createLegalDisclosureAsync(CreateLegalDisclosureRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateLegalDisclosureResponse> callback) throws ApiException, LWAException {
        return this.createLegalDisclosureAsync(body, amazonOrderId, marketplaceIds, callback, null);
    }

    public Call createLegalDisclosureAsync(CreateLegalDisclosureRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateLegalDisclosureResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createLegalDisclosureValidateBeforeCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createLegalDisclosure");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createLegalDisclosureBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateLegalDisclosureResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createLegalDisclosure operation exceeds rate limit");
    }

    private Call createUnexpectedProblemCall(CreateUnexpectedProblemRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateUnexpectedProblemRequest localVarPostBody = body;
        String localVarPath = "/messaging/v1/orders/{amazonOrderId}/messages/unexpectedProblem".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/messaging/v1/orders/{amazonOrderId}/messages/unexpectedProblem".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/messaging/v1/orders/{amazonOrderId}/messages/unexpectedProblem".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createUnexpectedProblemValidateBeforeCall(CreateUnexpectedProblemRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createUnexpectedProblem(Async)");
        }
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling createUnexpectedProblem(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling createUnexpectedProblem(Async)");
        }
        return this.createUnexpectedProblemCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public CreateUnexpectedProblemResponse createUnexpectedProblem(CreateUnexpectedProblemRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateUnexpectedProblemResponse> resp = this.createUnexpectedProblemWithHttpInfo(body, amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public CreateUnexpectedProblemResponse createUnexpectedProblem(CreateUnexpectedProblemRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<CreateUnexpectedProblemResponse> resp = this.createUnexpectedProblemWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<CreateUnexpectedProblemResponse> createUnexpectedProblemWithHttpInfo(CreateUnexpectedProblemRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createUnexpectedProblemValidateBeforeCall(body, amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createUnexpectedProblem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createUnexpectedProblemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateUnexpectedProblemResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createUnexpectedProblem operation exceeds rate limit");
    }

    public ApiResponse<CreateUnexpectedProblemResponse> createUnexpectedProblemWithHttpInfo(CreateUnexpectedProblemRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.createUnexpectedProblemWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
    }

    public Call createUnexpectedProblemAsync(CreateUnexpectedProblemRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateUnexpectedProblemResponse> callback) throws ApiException, LWAException {
        return this.createUnexpectedProblemAsync(body, amazonOrderId, marketplaceIds, callback, null);
    }

    public Call createUnexpectedProblemAsync(CreateUnexpectedProblemRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateUnexpectedProblemResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createUnexpectedProblemValidateBeforeCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createUnexpectedProblem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createUnexpectedProblemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateUnexpectedProblemResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createUnexpectedProblem operation exceeds rate limit");
    }

    private Call createWarrantyCall(CreateWarrantyRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateWarrantyRequest localVarPostBody = body;
        String localVarPath = "/messaging/v1/orders/{amazonOrderId}/messages/warranty".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/messaging/v1/orders/{amazonOrderId}/messages/warranty".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/messaging/v1/orders/{amazonOrderId}/messages/warranty".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createWarrantyValidateBeforeCall(CreateWarrantyRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createWarranty(Async)");
        }
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling createWarranty(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling createWarranty(Async)");
        }
        return this.createWarrantyCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public CreateWarrantyResponse createWarranty(CreateWarrantyRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateWarrantyResponse> resp = this.createWarrantyWithHttpInfo(body, amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public CreateWarrantyResponse createWarranty(CreateWarrantyRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<CreateWarrantyResponse> resp = this.createWarrantyWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<CreateWarrantyResponse> createWarrantyWithHttpInfo(CreateWarrantyRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createWarrantyValidateBeforeCall(body, amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createWarranty");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createWarrantyBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateWarrantyResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createWarranty operation exceeds rate limit");
    }

    public ApiResponse<CreateWarrantyResponse> createWarrantyWithHttpInfo(CreateWarrantyRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.createWarrantyWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
    }

    public Call createWarrantyAsync(CreateWarrantyRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateWarrantyResponse> callback) throws ApiException, LWAException {
        return this.createWarrantyAsync(body, amazonOrderId, marketplaceIds, callback, null);
    }

    public Call createWarrantyAsync(CreateWarrantyRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateWarrantyResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createWarrantyValidateBeforeCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-createWarranty");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createWarrantyBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateWarrantyResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createWarranty operation exceeds rate limit");
    }

    private Call getAttributesCall(String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/messaging/v1/orders/{amazonOrderId}/attributes".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/messaging/v1/orders/{amazonOrderId}/attributes".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/messaging/v1/orders/{amazonOrderId}/attributes".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getAttributesValidateBeforeCall(String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling getAttributes(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getAttributes(Async)");
        }
        return this.getAttributesCall(amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public GetAttributesResponse getAttributes(String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetAttributesResponse> resp = this.getAttributesWithHttpInfo(amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public GetAttributesResponse getAttributes(String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<GetAttributesResponse> resp = this.getAttributesWithHttpInfo(amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<GetAttributesResponse> getAttributesWithHttpInfo(String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getAttributesValidateBeforeCall(amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-getAttributes");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAttributesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAttributesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getAttributes operation exceeds rate limit");
    }

    public ApiResponse<GetAttributesResponse> getAttributesWithHttpInfo(String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.getAttributesWithHttpInfo(amazonOrderId, marketplaceIds, null);
    }

    public Call getAttributesAsync(String amazonOrderId, List<String> marketplaceIds, ApiCallback<GetAttributesResponse> callback) throws ApiException, LWAException {
        return this.getAttributesAsync(amazonOrderId, marketplaceIds, callback, null);
    }

    public Call getAttributesAsync(String amazonOrderId, List<String> marketplaceIds, ApiCallback<GetAttributesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getAttributesValidateBeforeCall(amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-getAttributes");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAttributesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAttributesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getAttributes operation exceeds rate limit");
    }

    private Call getMessagingActionsForOrderCall(String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/messaging/v1/orders/{amazonOrderId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/messaging/v1/orders/{amazonOrderId}".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/messaging/v1/orders/{amazonOrderId}".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getMessagingActionsForOrderValidateBeforeCall(String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling getMessagingActionsForOrder(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getMessagingActionsForOrder(Async)");
        }
        return this.getMessagingActionsForOrderCall(amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public GetMessagingActionsForOrderResponse getMessagingActionsForOrder(String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetMessagingActionsForOrderResponse> resp = this.getMessagingActionsForOrderWithHttpInfo(amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public GetMessagingActionsForOrderResponse getMessagingActionsForOrder(String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<GetMessagingActionsForOrderResponse> resp = this.getMessagingActionsForOrderWithHttpInfo(amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<GetMessagingActionsForOrderResponse> getMessagingActionsForOrderWithHttpInfo(String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getMessagingActionsForOrderValidateBeforeCall(amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-getMessagingActionsForOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getMessagingActionsForOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetMessagingActionsForOrderResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getMessagingActionsForOrder operation exceeds rate limit");
    }

    public ApiResponse<GetMessagingActionsForOrderResponse> getMessagingActionsForOrderWithHttpInfo(String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.getMessagingActionsForOrderWithHttpInfo(amazonOrderId, marketplaceIds, null);
    }

    public Call getMessagingActionsForOrderAsync(String amazonOrderId, List<String> marketplaceIds, ApiCallback<GetMessagingActionsForOrderResponse> callback) throws ApiException, LWAException {
        return this.getMessagingActionsForOrderAsync(amazonOrderId, marketplaceIds, callback, null);
    }

    public Call getMessagingActionsForOrderAsync(String amazonOrderId, List<String> marketplaceIds, ApiCallback<GetMessagingActionsForOrderResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getMessagingActionsForOrderValidateBeforeCall(amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-getMessagingActionsForOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getMessagingActionsForOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetMessagingActionsForOrderResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getMessagingActionsForOrder operation exceeds rate limit");
    }

    private Call sendInvoiceCall(InvoiceRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        InvoiceRequest localVarPostBody = body;
        String localVarPath = "/messaging/v1/orders/{amazonOrderId}/messages/invoice".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/messaging/v1/orders/{amazonOrderId}/messages/invoice".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/messaging/v1/orders/{amazonOrderId}/messages/invoice".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call sendInvoiceValidateBeforeCall(InvoiceRequest body, String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling sendInvoice(Async)");
        }
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling sendInvoice(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling sendInvoice(Async)");
        }
        return this.sendInvoiceCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public InvoiceResponse sendInvoice(InvoiceRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<InvoiceResponse> resp = this.sendInvoiceWithHttpInfo(body, amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public InvoiceResponse sendInvoice(InvoiceRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<InvoiceResponse> resp = this.sendInvoiceWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<InvoiceResponse> sendInvoiceWithHttpInfo(InvoiceRequest body, String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.sendInvoiceValidateBeforeCall(body, amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-sendInvoice");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.sendInvoiceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InvoiceResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("sendInvoice operation exceeds rate limit");
    }

    public ApiResponse<InvoiceResponse> sendInvoiceWithHttpInfo(InvoiceRequest body, String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.sendInvoiceWithHttpInfo(body, amazonOrderId, marketplaceIds, null);
    }

    public Call sendInvoiceAsync(InvoiceRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<InvoiceResponse> callback) throws ApiException, LWAException {
        return this.sendInvoiceAsync(body, amazonOrderId, marketplaceIds, callback, null);
    }

    public Call sendInvoiceAsync(InvoiceRequest body, String amazonOrderId, List<String> marketplaceIds, ApiCallback<InvoiceResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.sendInvoiceValidateBeforeCall(body, amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MessagingApi-sendInvoice");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.sendInvoiceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InvoiceResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("sendInvoice operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public MessagingApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new MessagingApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

