/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.fulfillment.outbound.v2020_07_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.CancelFulfillmentOrderResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.CreateFulfillmentOrderRequest;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.CreateFulfillmentOrderResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.CreateFulfillmentReturnRequest;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.CreateFulfillmentReturnResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.GetDeliveryOffersRequest;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.GetDeliveryOffersResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.GetFeatureInventoryResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.GetFeatureSkuResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.GetFeaturesResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.GetFulfillmentOrderResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.GetFulfillmentPreviewRequest;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.GetFulfillmentPreviewResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.GetPackageTrackingDetailsResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.ListAllFulfillmentOrdersResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.ListReturnReasonCodesResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.SubmitFulfillmentOrderStatusUpdateRequest;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.SubmitFulfillmentOrderStatusUpdateResponse;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.UpdateFulfillmentOrderRequest;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.UpdateFulfillmentOrderResponse;

public class FbaOutboundApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket cancelFulfillmentOrderBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-cancelFulfillmentOrder")).build();
    public final Bucket createFulfillmentOrderBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-createFulfillmentOrder")).build();
    public final Bucket createFulfillmentReturnBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-createFulfillmentReturn")).build();
    public final Bucket deliveryOffersBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-deliveryOffers")).build();
    public final Bucket getFeatureInventoryBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-getFeatureInventory")).build();
    public final Bucket getFeatureSKUBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-getFeatureSKU")).build();
    public final Bucket getFeaturesBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-getFeatures")).build();
    public final Bucket getFulfillmentOrderBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-getFulfillmentOrder")).build();
    public final Bucket getFulfillmentPreviewBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-getFulfillmentPreview")).build();
    public final Bucket getPackageTrackingDetailsBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-getPackageTrackingDetails")).build();
    public final Bucket listAllFulfillmentOrdersBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-listAllFulfillmentOrders")).build();
    public final Bucket listReturnReasonCodesBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-listReturnReasonCodes")).build();
    public final Bucket submitFulfillmentOrderStatusUpdateBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-submitFulfillmentOrderStatusUpdate")).build();
    public final Bucket updateFulfillmentOrderBucket = Bucket.builder().addLimit(this.config.getLimit("FbaOutboundApi-updateFulfillmentOrder")).build();

    public FbaOutboundApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call cancelFulfillmentOrderCall(String sellerFulfillmentOrderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}/cancel".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}/cancel".replaceAll("\\{sellerFulfillmentOrderId\\}", sellerFulfillmentOrderId.toString()) : "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}/cancel".replaceAll("\\{sellerFulfillmentOrderId\\}", this.apiClient.escapeString(sellerFulfillmentOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call cancelFulfillmentOrderValidateBeforeCall(String sellerFulfillmentOrderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (sellerFulfillmentOrderId == null) {
            throw new ApiException("Missing the required parameter 'sellerFulfillmentOrderId' when calling cancelFulfillmentOrder(Async)");
        }
        return this.cancelFulfillmentOrderCall(sellerFulfillmentOrderId, progressRequestListener);
    }

    public CancelFulfillmentOrderResponse cancelFulfillmentOrder(String sellerFulfillmentOrderId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CancelFulfillmentOrderResponse> resp = this.cancelFulfillmentOrderWithHttpInfo(sellerFulfillmentOrderId, restrictedDataToken);
        return resp.getData();
    }

    public CancelFulfillmentOrderResponse cancelFulfillmentOrder(String sellerFulfillmentOrderId) throws ApiException, LWAException {
        ApiResponse<CancelFulfillmentOrderResponse> resp = this.cancelFulfillmentOrderWithHttpInfo(sellerFulfillmentOrderId, null);
        return resp.getData();
    }

    public ApiResponse<CancelFulfillmentOrderResponse> cancelFulfillmentOrderWithHttpInfo(String sellerFulfillmentOrderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.cancelFulfillmentOrderValidateBeforeCall(sellerFulfillmentOrderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-cancelFulfillmentOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelFulfillmentOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CancelFulfillmentOrderResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("cancelFulfillmentOrder operation exceeds rate limit");
    }

    public ApiResponse<CancelFulfillmentOrderResponse> cancelFulfillmentOrderWithHttpInfo(String sellerFulfillmentOrderId) throws ApiException, LWAException {
        return this.cancelFulfillmentOrderWithHttpInfo(sellerFulfillmentOrderId, null);
    }

    public Call cancelFulfillmentOrderAsync(String sellerFulfillmentOrderId, ApiCallback<CancelFulfillmentOrderResponse> callback) throws ApiException, LWAException {
        return this.cancelFulfillmentOrderAsync(sellerFulfillmentOrderId, callback, null);
    }

    public Call cancelFulfillmentOrderAsync(String sellerFulfillmentOrderId, ApiCallback<CancelFulfillmentOrderResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.cancelFulfillmentOrderValidateBeforeCall(sellerFulfillmentOrderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-cancelFulfillmentOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelFulfillmentOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CancelFulfillmentOrderResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("cancelFulfillmentOrder operation exceeds rate limit");
    }

    private Call createFulfillmentOrderCall(CreateFulfillmentOrderRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateFulfillmentOrderRequest localVarPostBody = body;
        String localVarPath = "/fba/outbound/2020-07-01/fulfillmentOrders".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/fulfillmentOrders" : "/fba/outbound/2020-07-01/fulfillmentOrders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createFulfillmentOrderValidateBeforeCall(CreateFulfillmentOrderRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createFulfillmentOrder(Async)");
        }
        return this.createFulfillmentOrderCall(body, progressRequestListener);
    }

    public CreateFulfillmentOrderResponse createFulfillmentOrder(CreateFulfillmentOrderRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateFulfillmentOrderResponse> resp = this.createFulfillmentOrderWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateFulfillmentOrderResponse createFulfillmentOrder(CreateFulfillmentOrderRequest body) throws ApiException, LWAException {
        ApiResponse<CreateFulfillmentOrderResponse> resp = this.createFulfillmentOrderWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateFulfillmentOrderResponse> createFulfillmentOrderWithHttpInfo(CreateFulfillmentOrderRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createFulfillmentOrderValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-createFulfillmentOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createFulfillmentOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateFulfillmentOrderResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createFulfillmentOrder operation exceeds rate limit");
    }

    public ApiResponse<CreateFulfillmentOrderResponse> createFulfillmentOrderWithHttpInfo(CreateFulfillmentOrderRequest body) throws ApiException, LWAException {
        return this.createFulfillmentOrderWithHttpInfo(body, null);
    }

    public Call createFulfillmentOrderAsync(CreateFulfillmentOrderRequest body, ApiCallback<CreateFulfillmentOrderResponse> callback) throws ApiException, LWAException {
        return this.createFulfillmentOrderAsync(body, callback, null);
    }

    public Call createFulfillmentOrderAsync(CreateFulfillmentOrderRequest body, ApiCallback<CreateFulfillmentOrderResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createFulfillmentOrderValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-createFulfillmentOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createFulfillmentOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateFulfillmentOrderResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createFulfillmentOrder operation exceeds rate limit");
    }

    private Call createFulfillmentReturnCall(CreateFulfillmentReturnRequest body, String sellerFulfillmentOrderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateFulfillmentReturnRequest localVarPostBody = body;
        String localVarPath = "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}/return".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}/return".replaceAll("\\{sellerFulfillmentOrderId\\}", sellerFulfillmentOrderId.toString()) : "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}/return".replaceAll("\\{sellerFulfillmentOrderId\\}", this.apiClient.escapeString(sellerFulfillmentOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createFulfillmentReturnValidateBeforeCall(CreateFulfillmentReturnRequest body, String sellerFulfillmentOrderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createFulfillmentReturn(Async)");
        }
        if (sellerFulfillmentOrderId == null) {
            throw new ApiException("Missing the required parameter 'sellerFulfillmentOrderId' when calling createFulfillmentReturn(Async)");
        }
        return this.createFulfillmentReturnCall(body, sellerFulfillmentOrderId, progressRequestListener);
    }

    public CreateFulfillmentReturnResponse createFulfillmentReturn(CreateFulfillmentReturnRequest body, String sellerFulfillmentOrderId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateFulfillmentReturnResponse> resp = this.createFulfillmentReturnWithHttpInfo(body, sellerFulfillmentOrderId, restrictedDataToken);
        return resp.getData();
    }

    public CreateFulfillmentReturnResponse createFulfillmentReturn(CreateFulfillmentReturnRequest body, String sellerFulfillmentOrderId) throws ApiException, LWAException {
        ApiResponse<CreateFulfillmentReturnResponse> resp = this.createFulfillmentReturnWithHttpInfo(body, sellerFulfillmentOrderId, null);
        return resp.getData();
    }

    public ApiResponse<CreateFulfillmentReturnResponse> createFulfillmentReturnWithHttpInfo(CreateFulfillmentReturnRequest body, String sellerFulfillmentOrderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createFulfillmentReturnValidateBeforeCall(body, sellerFulfillmentOrderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-createFulfillmentReturn");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createFulfillmentReturnBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateFulfillmentReturnResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createFulfillmentReturn operation exceeds rate limit");
    }

    public ApiResponse<CreateFulfillmentReturnResponse> createFulfillmentReturnWithHttpInfo(CreateFulfillmentReturnRequest body, String sellerFulfillmentOrderId) throws ApiException, LWAException {
        return this.createFulfillmentReturnWithHttpInfo(body, sellerFulfillmentOrderId, null);
    }

    public Call createFulfillmentReturnAsync(CreateFulfillmentReturnRequest body, String sellerFulfillmentOrderId, ApiCallback<CreateFulfillmentReturnResponse> callback) throws ApiException, LWAException {
        return this.createFulfillmentReturnAsync(body, sellerFulfillmentOrderId, callback, null);
    }

    public Call createFulfillmentReturnAsync(CreateFulfillmentReturnRequest body, String sellerFulfillmentOrderId, ApiCallback<CreateFulfillmentReturnResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createFulfillmentReturnValidateBeforeCall(body, sellerFulfillmentOrderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-createFulfillmentReturn");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createFulfillmentReturnBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateFulfillmentReturnResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createFulfillmentReturn operation exceeds rate limit");
    }

    private Call deliveryOffersCall(GetDeliveryOffersRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetDeliveryOffersRequest localVarPostBody = body;
        String localVarPath = "/fba/outbound/2020-07-01/deliveryOffers".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/deliveryOffers" : "/fba/outbound/2020-07-01/deliveryOffers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call deliveryOffersValidateBeforeCall(GetDeliveryOffersRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling deliveryOffers(Async)");
        }
        return this.deliveryOffersCall(body, progressRequestListener);
    }

    public GetDeliveryOffersResponse deliveryOffers(GetDeliveryOffersRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetDeliveryOffersResponse> resp = this.deliveryOffersWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public GetDeliveryOffersResponse deliveryOffers(GetDeliveryOffersRequest body) throws ApiException, LWAException {
        ApiResponse<GetDeliveryOffersResponse> resp = this.deliveryOffersWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<GetDeliveryOffersResponse> deliveryOffersWithHttpInfo(GetDeliveryOffersRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.deliveryOffersValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-deliveryOffers");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deliveryOffersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetDeliveryOffersResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("deliveryOffers operation exceeds rate limit");
    }

    public ApiResponse<GetDeliveryOffersResponse> deliveryOffersWithHttpInfo(GetDeliveryOffersRequest body) throws ApiException, LWAException {
        return this.deliveryOffersWithHttpInfo(body, null);
    }

    public Call deliveryOffersAsync(GetDeliveryOffersRequest body, ApiCallback<GetDeliveryOffersResponse> callback) throws ApiException, LWAException {
        return this.deliveryOffersAsync(body, callback, null);
    }

    public Call deliveryOffersAsync(GetDeliveryOffersRequest body, ApiCallback<GetDeliveryOffersResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.deliveryOffersValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-deliveryOffers");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deliveryOffersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetDeliveryOffersResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("deliveryOffers operation exceeds rate limit");
    }

    private Call getFeatureInventoryCall(String marketplaceId, String featureName, String nextToken, OffsetDateTime queryStartDate, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/outbound/2020-07-01/features/inventory/{featureName}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/features/inventory/{featureName}".replaceAll("\\{featureName\\}", featureName.toString()) : "/fba/outbound/2020-07-01/features/inventory/{featureName}".replaceAll("\\{featureName\\}", this.apiClient.escapeString(featureName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        if (queryStartDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("queryStartDate", queryStartDate));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getFeatureInventoryValidateBeforeCall(String marketplaceId, String featureName, String nextToken, OffsetDateTime queryStartDate, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getFeatureInventory(Async)");
        }
        if (featureName == null) {
            throw new ApiException("Missing the required parameter 'featureName' when calling getFeatureInventory(Async)");
        }
        return this.getFeatureInventoryCall(marketplaceId, featureName, nextToken, queryStartDate, progressRequestListener);
    }

    public GetFeatureInventoryResponse getFeatureInventory(String marketplaceId, String featureName, String nextToken, OffsetDateTime queryStartDate, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetFeatureInventoryResponse> resp = this.getFeatureInventoryWithHttpInfo(marketplaceId, featureName, nextToken, queryStartDate, restrictedDataToken);
        return resp.getData();
    }

    public GetFeatureInventoryResponse getFeatureInventory(String marketplaceId, String featureName, String nextToken, OffsetDateTime queryStartDate) throws ApiException, LWAException {
        ApiResponse<GetFeatureInventoryResponse> resp = this.getFeatureInventoryWithHttpInfo(marketplaceId, featureName, nextToken, queryStartDate, null);
        return resp.getData();
    }

    public ApiResponse<GetFeatureInventoryResponse> getFeatureInventoryWithHttpInfo(String marketplaceId, String featureName, String nextToken, OffsetDateTime queryStartDate, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getFeatureInventoryValidateBeforeCall(marketplaceId, featureName, nextToken, queryStartDate, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-getFeatureInventory");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeatureInventoryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFeatureInventoryResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getFeatureInventory operation exceeds rate limit");
    }

    public ApiResponse<GetFeatureInventoryResponse> getFeatureInventoryWithHttpInfo(String marketplaceId, String featureName, String nextToken, OffsetDateTime queryStartDate) throws ApiException, LWAException {
        return this.getFeatureInventoryWithHttpInfo(marketplaceId, featureName, nextToken, queryStartDate, null);
    }

    public Call getFeatureInventoryAsync(String marketplaceId, String featureName, String nextToken, OffsetDateTime queryStartDate, ApiCallback<GetFeatureInventoryResponse> callback) throws ApiException, LWAException {
        return this.getFeatureInventoryAsync(marketplaceId, featureName, nextToken, queryStartDate, callback, null);
    }

    public Call getFeatureInventoryAsync(String marketplaceId, String featureName, String nextToken, OffsetDateTime queryStartDate, ApiCallback<GetFeatureInventoryResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getFeatureInventoryValidateBeforeCall(marketplaceId, featureName, nextToken, queryStartDate, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-getFeatureInventory");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeatureInventoryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFeatureInventoryResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getFeatureInventory operation exceeds rate limit");
    }

    private Call getFeatureSKUCall(String marketplaceId, String featureName, String sellerSku, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/outbound/2020-07-01/features/inventory/{featureName}/{sellerSku}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/features/inventory/{featureName}/{sellerSku}".replaceAll("\\{featureName\\}", featureName.toString()).replaceAll("\\{sellerSku\\}", sellerSku.toString()) : "/fba/outbound/2020-07-01/features/inventory/{featureName}/{sellerSku}".replaceAll("\\{featureName\\}", this.apiClient.escapeString(featureName.toString())).replaceAll("\\{sellerSku\\}", this.apiClient.escapeString(sellerSku.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getFeatureSKUValidateBeforeCall(String marketplaceId, String featureName, String sellerSku, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getFeatureSKU(Async)");
        }
        if (featureName == null) {
            throw new ApiException("Missing the required parameter 'featureName' when calling getFeatureSKU(Async)");
        }
        if (sellerSku == null) {
            throw new ApiException("Missing the required parameter 'sellerSku' when calling getFeatureSKU(Async)");
        }
        return this.getFeatureSKUCall(marketplaceId, featureName, sellerSku, progressRequestListener);
    }

    public GetFeatureSkuResponse getFeatureSKU(String marketplaceId, String featureName, String sellerSku, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetFeatureSkuResponse> resp = this.getFeatureSKUWithHttpInfo(marketplaceId, featureName, sellerSku, restrictedDataToken);
        return resp.getData();
    }

    public GetFeatureSkuResponse getFeatureSKU(String marketplaceId, String featureName, String sellerSku) throws ApiException, LWAException {
        ApiResponse<GetFeatureSkuResponse> resp = this.getFeatureSKUWithHttpInfo(marketplaceId, featureName, sellerSku, null);
        return resp.getData();
    }

    public ApiResponse<GetFeatureSkuResponse> getFeatureSKUWithHttpInfo(String marketplaceId, String featureName, String sellerSku, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getFeatureSKUValidateBeforeCall(marketplaceId, featureName, sellerSku, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-getFeatureSKU");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeatureSKUBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFeatureSkuResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getFeatureSKU operation exceeds rate limit");
    }

    public ApiResponse<GetFeatureSkuResponse> getFeatureSKUWithHttpInfo(String marketplaceId, String featureName, String sellerSku) throws ApiException, LWAException {
        return this.getFeatureSKUWithHttpInfo(marketplaceId, featureName, sellerSku, null);
    }

    public Call getFeatureSKUAsync(String marketplaceId, String featureName, String sellerSku, ApiCallback<GetFeatureSkuResponse> callback) throws ApiException, LWAException {
        return this.getFeatureSKUAsync(marketplaceId, featureName, sellerSku, callback, null);
    }

    public Call getFeatureSKUAsync(String marketplaceId, String featureName, String sellerSku, ApiCallback<GetFeatureSkuResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getFeatureSKUValidateBeforeCall(marketplaceId, featureName, sellerSku, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-getFeatureSKU");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeatureSKUBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFeatureSkuResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getFeatureSKU operation exceeds rate limit");
    }

    private Call getFeaturesCall(String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/outbound/2020-07-01/features".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/features" : "/fba/outbound/2020-07-01/features";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getFeaturesValidateBeforeCall(String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getFeatures(Async)");
        }
        return this.getFeaturesCall(marketplaceId, progressRequestListener);
    }

    public GetFeaturesResponse getFeatures(String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetFeaturesResponse> resp = this.getFeaturesWithHttpInfo(marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public GetFeaturesResponse getFeatures(String marketplaceId) throws ApiException, LWAException {
        ApiResponse<GetFeaturesResponse> resp = this.getFeaturesWithHttpInfo(marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<GetFeaturesResponse> getFeaturesWithHttpInfo(String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getFeaturesValidateBeforeCall(marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-getFeatures");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeaturesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFeaturesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getFeatures operation exceeds rate limit");
    }

    public ApiResponse<GetFeaturesResponse> getFeaturesWithHttpInfo(String marketplaceId) throws ApiException, LWAException {
        return this.getFeaturesWithHttpInfo(marketplaceId, null);
    }

    public Call getFeaturesAsync(String marketplaceId, ApiCallback<GetFeaturesResponse> callback) throws ApiException, LWAException {
        return this.getFeaturesAsync(marketplaceId, callback, null);
    }

    public Call getFeaturesAsync(String marketplaceId, ApiCallback<GetFeaturesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getFeaturesValidateBeforeCall(marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-getFeatures");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFeaturesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFeaturesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getFeatures operation exceeds rate limit");
    }

    private Call getFulfillmentOrderCall(String sellerFulfillmentOrderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}".replaceAll("\\{sellerFulfillmentOrderId\\}", sellerFulfillmentOrderId.toString()) : "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}".replaceAll("\\{sellerFulfillmentOrderId\\}", this.apiClient.escapeString(sellerFulfillmentOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getFulfillmentOrderValidateBeforeCall(String sellerFulfillmentOrderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (sellerFulfillmentOrderId == null) {
            throw new ApiException("Missing the required parameter 'sellerFulfillmentOrderId' when calling getFulfillmentOrder(Async)");
        }
        return this.getFulfillmentOrderCall(sellerFulfillmentOrderId, progressRequestListener);
    }

    public GetFulfillmentOrderResponse getFulfillmentOrder(String sellerFulfillmentOrderId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetFulfillmentOrderResponse> resp = this.getFulfillmentOrderWithHttpInfo(sellerFulfillmentOrderId, restrictedDataToken);
        return resp.getData();
    }

    public GetFulfillmentOrderResponse getFulfillmentOrder(String sellerFulfillmentOrderId) throws ApiException, LWAException {
        ApiResponse<GetFulfillmentOrderResponse> resp = this.getFulfillmentOrderWithHttpInfo(sellerFulfillmentOrderId, null);
        return resp.getData();
    }

    public ApiResponse<GetFulfillmentOrderResponse> getFulfillmentOrderWithHttpInfo(String sellerFulfillmentOrderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getFulfillmentOrderValidateBeforeCall(sellerFulfillmentOrderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-getFulfillmentOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFulfillmentOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFulfillmentOrderResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getFulfillmentOrder operation exceeds rate limit");
    }

    public ApiResponse<GetFulfillmentOrderResponse> getFulfillmentOrderWithHttpInfo(String sellerFulfillmentOrderId) throws ApiException, LWAException {
        return this.getFulfillmentOrderWithHttpInfo(sellerFulfillmentOrderId, null);
    }

    public Call getFulfillmentOrderAsync(String sellerFulfillmentOrderId, ApiCallback<GetFulfillmentOrderResponse> callback) throws ApiException, LWAException {
        return this.getFulfillmentOrderAsync(sellerFulfillmentOrderId, callback, null);
    }

    public Call getFulfillmentOrderAsync(String sellerFulfillmentOrderId, ApiCallback<GetFulfillmentOrderResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getFulfillmentOrderValidateBeforeCall(sellerFulfillmentOrderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-getFulfillmentOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFulfillmentOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFulfillmentOrderResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getFulfillmentOrder operation exceeds rate limit");
    }

    private Call getFulfillmentPreviewCall(GetFulfillmentPreviewRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetFulfillmentPreviewRequest localVarPostBody = body;
        String localVarPath = "/fba/outbound/2020-07-01/fulfillmentOrders/preview".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/fulfillmentOrders/preview" : "/fba/outbound/2020-07-01/fulfillmentOrders/preview";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getFulfillmentPreviewValidateBeforeCall(GetFulfillmentPreviewRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getFulfillmentPreview(Async)");
        }
        return this.getFulfillmentPreviewCall(body, progressRequestListener);
    }

    public GetFulfillmentPreviewResponse getFulfillmentPreview(GetFulfillmentPreviewRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetFulfillmentPreviewResponse> resp = this.getFulfillmentPreviewWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public GetFulfillmentPreviewResponse getFulfillmentPreview(GetFulfillmentPreviewRequest body) throws ApiException, LWAException {
        ApiResponse<GetFulfillmentPreviewResponse> resp = this.getFulfillmentPreviewWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<GetFulfillmentPreviewResponse> getFulfillmentPreviewWithHttpInfo(GetFulfillmentPreviewRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getFulfillmentPreviewValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-getFulfillmentPreview");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFulfillmentPreviewBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFulfillmentPreviewResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getFulfillmentPreview operation exceeds rate limit");
    }

    public ApiResponse<GetFulfillmentPreviewResponse> getFulfillmentPreviewWithHttpInfo(GetFulfillmentPreviewRequest body) throws ApiException, LWAException {
        return this.getFulfillmentPreviewWithHttpInfo(body, null);
    }

    public Call getFulfillmentPreviewAsync(GetFulfillmentPreviewRequest body, ApiCallback<GetFulfillmentPreviewResponse> callback) throws ApiException, LWAException {
        return this.getFulfillmentPreviewAsync(body, callback, null);
    }

    public Call getFulfillmentPreviewAsync(GetFulfillmentPreviewRequest body, ApiCallback<GetFulfillmentPreviewResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getFulfillmentPreviewValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-getFulfillmentPreview");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFulfillmentPreviewBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetFulfillmentPreviewResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getFulfillmentPreview operation exceeds rate limit");
    }

    private Call getPackageTrackingDetailsCall(Integer packageNumber, String amazonFulfillmentTrackingNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/outbound/2020-07-01/tracking".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/tracking" : "/fba/outbound/2020-07-01/tracking";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (packageNumber != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("packageNumber", packageNumber));
        }
        if (amazonFulfillmentTrackingNumber != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("amazonFulfillmentTrackingNumber", amazonFulfillmentTrackingNumber));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getPackageTrackingDetailsValidateBeforeCall(Integer packageNumber, String amazonFulfillmentTrackingNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getPackageTrackingDetailsCall(packageNumber, amazonFulfillmentTrackingNumber, progressRequestListener);
    }

    public GetPackageTrackingDetailsResponse getPackageTrackingDetails(Integer packageNumber, String amazonFulfillmentTrackingNumber, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetPackageTrackingDetailsResponse> resp = this.getPackageTrackingDetailsWithHttpInfo(packageNumber, amazonFulfillmentTrackingNumber, restrictedDataToken);
        return resp.getData();
    }

    public GetPackageTrackingDetailsResponse getPackageTrackingDetails(Integer packageNumber, String amazonFulfillmentTrackingNumber) throws ApiException, LWAException {
        ApiResponse<GetPackageTrackingDetailsResponse> resp = this.getPackageTrackingDetailsWithHttpInfo(packageNumber, amazonFulfillmentTrackingNumber, null);
        return resp.getData();
    }

    public ApiResponse<GetPackageTrackingDetailsResponse> getPackageTrackingDetailsWithHttpInfo(Integer packageNumber, String amazonFulfillmentTrackingNumber, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getPackageTrackingDetailsValidateBeforeCall(packageNumber, amazonFulfillmentTrackingNumber, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-getPackageTrackingDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPackageTrackingDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPackageTrackingDetailsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getPackageTrackingDetails operation exceeds rate limit");
    }

    public ApiResponse<GetPackageTrackingDetailsResponse> getPackageTrackingDetailsWithHttpInfo(Integer packageNumber, String amazonFulfillmentTrackingNumber) throws ApiException, LWAException {
        return this.getPackageTrackingDetailsWithHttpInfo(packageNumber, amazonFulfillmentTrackingNumber, null);
    }

    public Call getPackageTrackingDetailsAsync(Integer packageNumber, String amazonFulfillmentTrackingNumber, ApiCallback<GetPackageTrackingDetailsResponse> callback) throws ApiException, LWAException {
        return this.getPackageTrackingDetailsAsync(packageNumber, amazonFulfillmentTrackingNumber, callback, null);
    }

    public Call getPackageTrackingDetailsAsync(Integer packageNumber, String amazonFulfillmentTrackingNumber, ApiCallback<GetPackageTrackingDetailsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getPackageTrackingDetailsValidateBeforeCall(packageNumber, amazonFulfillmentTrackingNumber, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-getPackageTrackingDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPackageTrackingDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPackageTrackingDetailsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getPackageTrackingDetails operation exceeds rate limit");
    }

    private Call listAllFulfillmentOrdersCall(OffsetDateTime queryStartDate, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/outbound/2020-07-01/fulfillmentOrders".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/fulfillmentOrders" : "/fba/outbound/2020-07-01/fulfillmentOrders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (queryStartDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("queryStartDate", queryStartDate));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listAllFulfillmentOrdersValidateBeforeCall(OffsetDateTime queryStartDate, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.listAllFulfillmentOrdersCall(queryStartDate, nextToken, progressRequestListener);
    }

    public ListAllFulfillmentOrdersResponse listAllFulfillmentOrders(OffsetDateTime queryStartDate, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListAllFulfillmentOrdersResponse> resp = this.listAllFulfillmentOrdersWithHttpInfo(queryStartDate, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public ListAllFulfillmentOrdersResponse listAllFulfillmentOrders(OffsetDateTime queryStartDate, String nextToken) throws ApiException, LWAException {
        ApiResponse<ListAllFulfillmentOrdersResponse> resp = this.listAllFulfillmentOrdersWithHttpInfo(queryStartDate, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<ListAllFulfillmentOrdersResponse> listAllFulfillmentOrdersWithHttpInfo(OffsetDateTime queryStartDate, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listAllFulfillmentOrdersValidateBeforeCall(queryStartDate, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-listAllFulfillmentOrders");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listAllFulfillmentOrdersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListAllFulfillmentOrdersResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listAllFulfillmentOrders operation exceeds rate limit");
    }

    public ApiResponse<ListAllFulfillmentOrdersResponse> listAllFulfillmentOrdersWithHttpInfo(OffsetDateTime queryStartDate, String nextToken) throws ApiException, LWAException {
        return this.listAllFulfillmentOrdersWithHttpInfo(queryStartDate, nextToken, null);
    }

    public Call listAllFulfillmentOrdersAsync(OffsetDateTime queryStartDate, String nextToken, ApiCallback<ListAllFulfillmentOrdersResponse> callback) throws ApiException, LWAException {
        return this.listAllFulfillmentOrdersAsync(queryStartDate, nextToken, callback, null);
    }

    public Call listAllFulfillmentOrdersAsync(OffsetDateTime queryStartDate, String nextToken, ApiCallback<ListAllFulfillmentOrdersResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listAllFulfillmentOrdersValidateBeforeCall(queryStartDate, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-listAllFulfillmentOrders");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listAllFulfillmentOrdersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListAllFulfillmentOrdersResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listAllFulfillmentOrders operation exceeds rate limit");
    }

    private Call listReturnReasonCodesCall(String sellerSku, String marketplaceId, String sellerFulfillmentOrderId, String language, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/outbound/2020-07-01/returnReasonCodes".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/returnReasonCodes" : "/fba/outbound/2020-07-01/returnReasonCodes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sellerSku != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sellerSku", sellerSku));
        }
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (sellerFulfillmentOrderId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sellerFulfillmentOrderId", sellerFulfillmentOrderId));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listReturnReasonCodesValidateBeforeCall(String sellerSku, String marketplaceId, String sellerFulfillmentOrderId, String language, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (sellerSku == null) {
            throw new ApiException("Missing the required parameter 'sellerSku' when calling listReturnReasonCodes(Async)");
        }
        return this.listReturnReasonCodesCall(sellerSku, marketplaceId, sellerFulfillmentOrderId, language, progressRequestListener);
    }

    public ListReturnReasonCodesResponse listReturnReasonCodes(String sellerSku, String marketplaceId, String sellerFulfillmentOrderId, String language, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListReturnReasonCodesResponse> resp = this.listReturnReasonCodesWithHttpInfo(sellerSku, marketplaceId, sellerFulfillmentOrderId, language, restrictedDataToken);
        return resp.getData();
    }

    public ListReturnReasonCodesResponse listReturnReasonCodes(String sellerSku, String marketplaceId, String sellerFulfillmentOrderId, String language) throws ApiException, LWAException {
        ApiResponse<ListReturnReasonCodesResponse> resp = this.listReturnReasonCodesWithHttpInfo(sellerSku, marketplaceId, sellerFulfillmentOrderId, language, null);
        return resp.getData();
    }

    public ApiResponse<ListReturnReasonCodesResponse> listReturnReasonCodesWithHttpInfo(String sellerSku, String marketplaceId, String sellerFulfillmentOrderId, String language, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listReturnReasonCodesValidateBeforeCall(sellerSku, marketplaceId, sellerFulfillmentOrderId, language, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-listReturnReasonCodes");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listReturnReasonCodesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListReturnReasonCodesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listReturnReasonCodes operation exceeds rate limit");
    }

    public ApiResponse<ListReturnReasonCodesResponse> listReturnReasonCodesWithHttpInfo(String sellerSku, String marketplaceId, String sellerFulfillmentOrderId, String language) throws ApiException, LWAException {
        return this.listReturnReasonCodesWithHttpInfo(sellerSku, marketplaceId, sellerFulfillmentOrderId, language, null);
    }

    public Call listReturnReasonCodesAsync(String sellerSku, String marketplaceId, String sellerFulfillmentOrderId, String language, ApiCallback<ListReturnReasonCodesResponse> callback) throws ApiException, LWAException {
        return this.listReturnReasonCodesAsync(sellerSku, marketplaceId, sellerFulfillmentOrderId, language, callback, null);
    }

    public Call listReturnReasonCodesAsync(String sellerSku, String marketplaceId, String sellerFulfillmentOrderId, String language, ApiCallback<ListReturnReasonCodesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listReturnReasonCodesValidateBeforeCall(sellerSku, marketplaceId, sellerFulfillmentOrderId, language, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-listReturnReasonCodes");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listReturnReasonCodesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListReturnReasonCodesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listReturnReasonCodes operation exceeds rate limit");
    }

    private Call submitFulfillmentOrderStatusUpdateCall(SubmitFulfillmentOrderStatusUpdateRequest body, String sellerFulfillmentOrderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        SubmitFulfillmentOrderStatusUpdateRequest localVarPostBody = body;
        String localVarPath = "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}/status".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}/status".replaceAll("\\{sellerFulfillmentOrderId\\}", sellerFulfillmentOrderId.toString()) : "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}/status".replaceAll("\\{sellerFulfillmentOrderId\\}", this.apiClient.escapeString(sellerFulfillmentOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call submitFulfillmentOrderStatusUpdateValidateBeforeCall(SubmitFulfillmentOrderStatusUpdateRequest body, String sellerFulfillmentOrderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling submitFulfillmentOrderStatusUpdate(Async)");
        }
        if (sellerFulfillmentOrderId == null) {
            throw new ApiException("Missing the required parameter 'sellerFulfillmentOrderId' when calling submitFulfillmentOrderStatusUpdate(Async)");
        }
        return this.submitFulfillmentOrderStatusUpdateCall(body, sellerFulfillmentOrderId, progressRequestListener);
    }

    public SubmitFulfillmentOrderStatusUpdateResponse submitFulfillmentOrderStatusUpdate(SubmitFulfillmentOrderStatusUpdateRequest body, String sellerFulfillmentOrderId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<SubmitFulfillmentOrderStatusUpdateResponse> resp = this.submitFulfillmentOrderStatusUpdateWithHttpInfo(body, sellerFulfillmentOrderId, restrictedDataToken);
        return resp.getData();
    }

    public SubmitFulfillmentOrderStatusUpdateResponse submitFulfillmentOrderStatusUpdate(SubmitFulfillmentOrderStatusUpdateRequest body, String sellerFulfillmentOrderId) throws ApiException, LWAException {
        ApiResponse<SubmitFulfillmentOrderStatusUpdateResponse> resp = this.submitFulfillmentOrderStatusUpdateWithHttpInfo(body, sellerFulfillmentOrderId, null);
        return resp.getData();
    }

    public ApiResponse<SubmitFulfillmentOrderStatusUpdateResponse> submitFulfillmentOrderStatusUpdateWithHttpInfo(SubmitFulfillmentOrderStatusUpdateRequest body, String sellerFulfillmentOrderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.submitFulfillmentOrderStatusUpdateValidateBeforeCall(body, sellerFulfillmentOrderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-submitFulfillmentOrderStatusUpdate");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitFulfillmentOrderStatusUpdateBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SubmitFulfillmentOrderStatusUpdateResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("submitFulfillmentOrderStatusUpdate operation exceeds rate limit");
    }

    public ApiResponse<SubmitFulfillmentOrderStatusUpdateResponse> submitFulfillmentOrderStatusUpdateWithHttpInfo(SubmitFulfillmentOrderStatusUpdateRequest body, String sellerFulfillmentOrderId) throws ApiException, LWAException {
        return this.submitFulfillmentOrderStatusUpdateWithHttpInfo(body, sellerFulfillmentOrderId, null);
    }

    public Call submitFulfillmentOrderStatusUpdateAsync(SubmitFulfillmentOrderStatusUpdateRequest body, String sellerFulfillmentOrderId, ApiCallback<SubmitFulfillmentOrderStatusUpdateResponse> callback) throws ApiException, LWAException {
        return this.submitFulfillmentOrderStatusUpdateAsync(body, sellerFulfillmentOrderId, callback, null);
    }

    public Call submitFulfillmentOrderStatusUpdateAsync(SubmitFulfillmentOrderStatusUpdateRequest body, String sellerFulfillmentOrderId, ApiCallback<SubmitFulfillmentOrderStatusUpdateResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.submitFulfillmentOrderStatusUpdateValidateBeforeCall(body, sellerFulfillmentOrderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-submitFulfillmentOrderStatusUpdate");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitFulfillmentOrderStatusUpdateBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SubmitFulfillmentOrderStatusUpdateResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("submitFulfillmentOrderStatusUpdate operation exceeds rate limit");
    }

    private Call updateFulfillmentOrderCall(UpdateFulfillmentOrderRequest body, String sellerFulfillmentOrderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        UpdateFulfillmentOrderRequest localVarPostBody = body;
        String localVarPath = "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}".replaceAll("\\{sellerFulfillmentOrderId\\}", sellerFulfillmentOrderId.toString()) : "/fba/outbound/2020-07-01/fulfillmentOrders/{sellerFulfillmentOrderId}".replaceAll("\\{sellerFulfillmentOrderId\\}", this.apiClient.escapeString(sellerFulfillmentOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call updateFulfillmentOrderValidateBeforeCall(UpdateFulfillmentOrderRequest body, String sellerFulfillmentOrderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateFulfillmentOrder(Async)");
        }
        if (sellerFulfillmentOrderId == null) {
            throw new ApiException("Missing the required parameter 'sellerFulfillmentOrderId' when calling updateFulfillmentOrder(Async)");
        }
        return this.updateFulfillmentOrderCall(body, sellerFulfillmentOrderId, progressRequestListener);
    }

    public UpdateFulfillmentOrderResponse updateFulfillmentOrder(UpdateFulfillmentOrderRequest body, String sellerFulfillmentOrderId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<UpdateFulfillmentOrderResponse> resp = this.updateFulfillmentOrderWithHttpInfo(body, sellerFulfillmentOrderId, restrictedDataToken);
        return resp.getData();
    }

    public UpdateFulfillmentOrderResponse updateFulfillmentOrder(UpdateFulfillmentOrderRequest body, String sellerFulfillmentOrderId) throws ApiException, LWAException {
        ApiResponse<UpdateFulfillmentOrderResponse> resp = this.updateFulfillmentOrderWithHttpInfo(body, sellerFulfillmentOrderId, null);
        return resp.getData();
    }

    public ApiResponse<UpdateFulfillmentOrderResponse> updateFulfillmentOrderWithHttpInfo(UpdateFulfillmentOrderRequest body, String sellerFulfillmentOrderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.updateFulfillmentOrderValidateBeforeCall(body, sellerFulfillmentOrderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-updateFulfillmentOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateFulfillmentOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<UpdateFulfillmentOrderResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("updateFulfillmentOrder operation exceeds rate limit");
    }

    public ApiResponse<UpdateFulfillmentOrderResponse> updateFulfillmentOrderWithHttpInfo(UpdateFulfillmentOrderRequest body, String sellerFulfillmentOrderId) throws ApiException, LWAException {
        return this.updateFulfillmentOrderWithHttpInfo(body, sellerFulfillmentOrderId, null);
    }

    public Call updateFulfillmentOrderAsync(UpdateFulfillmentOrderRequest body, String sellerFulfillmentOrderId, ApiCallback<UpdateFulfillmentOrderResponse> callback) throws ApiException, LWAException {
        return this.updateFulfillmentOrderAsync(body, sellerFulfillmentOrderId, callback, null);
    }

    public Call updateFulfillmentOrderAsync(UpdateFulfillmentOrderRequest body, String sellerFulfillmentOrderId, ApiCallback<UpdateFulfillmentOrderResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.updateFulfillmentOrderValidateBeforeCall(body, sellerFulfillmentOrderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaOutboundApi-updateFulfillmentOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateFulfillmentOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<UpdateFulfillmentOrderResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("updateFulfillmentOrder operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public FbaOutboundApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new FbaOutboundApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

