/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.catalogitems.v2022_04_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.catalogitems.v2022_04_01.Item;
import software.amazon.spapi.models.catalogitems.v2022_04_01.ItemSearchResults;

public class CatalogApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getCatalogItemBucket = Bucket.builder().addLimit(this.config.getLimit("CatalogApi-getCatalogItem")).build();
    public final Bucket searchCatalogItemsBucket = Bucket.builder().addLimit(this.config.getLimit("CatalogApi-searchCatalogItems")).build();

    public CatalogApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getCatalogItemCall(String asin, List<String> marketplaceIds, List<String> includedData, String locale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/catalog/2022-04-01/items/{asin}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/catalog/2022-04-01/items/{asin}".replaceAll("\\{asin\\}", asin.toString()) : "/catalog/2022-04-01/items/{asin}".replaceAll("\\{asin\\}", this.apiClient.escapeString(asin.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (includedData != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "includedData", includedData));
        }
        if (locale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("locale", locale));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getCatalogItemValidateBeforeCall(String asin, List<String> marketplaceIds, List<String> includedData, String locale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (asin == null) {
            throw new ApiException("Missing the required parameter 'asin' when calling getCatalogItem(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getCatalogItem(Async)");
        }
        return this.getCatalogItemCall(asin, marketplaceIds, includedData, locale, progressRequestListener);
    }

    public Item getCatalogItem(String asin, List<String> marketplaceIds, List<String> includedData, String locale, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<Item> resp = this.getCatalogItemWithHttpInfo(asin, marketplaceIds, includedData, locale, restrictedDataToken);
        return resp.getData();
    }

    public Item getCatalogItem(String asin, List<String> marketplaceIds, List<String> includedData, String locale) throws ApiException, LWAException {
        ApiResponse<Item> resp = this.getCatalogItemWithHttpInfo(asin, marketplaceIds, includedData, locale, null);
        return resp.getData();
    }

    public ApiResponse<Item> getCatalogItemWithHttpInfo(String asin, List<String> marketplaceIds, List<String> includedData, String locale, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getCatalogItemValidateBeforeCall(asin, marketplaceIds, includedData, locale, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CatalogApi-getCatalogItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCatalogItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Item>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getCatalogItem operation exceeds rate limit");
    }

    public ApiResponse<Item> getCatalogItemWithHttpInfo(String asin, List<String> marketplaceIds, List<String> includedData, String locale) throws ApiException, LWAException {
        return this.getCatalogItemWithHttpInfo(asin, marketplaceIds, includedData, locale, null);
    }

    public Call getCatalogItemAsync(String asin, List<String> marketplaceIds, List<String> includedData, String locale, ApiCallback<Item> callback) throws ApiException, LWAException {
        return this.getCatalogItemAsync(asin, marketplaceIds, includedData, locale, callback, null);
    }

    public Call getCatalogItemAsync(String asin, List<String> marketplaceIds, List<String> includedData, String locale, ApiCallback<Item> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getCatalogItemValidateBeforeCall(asin, marketplaceIds, includedData, locale, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CatalogApi-getCatalogItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCatalogItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Item>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getCatalogItem operation exceeds rate limit");
    }

    private Call searchCatalogItemsCall(List<String> marketplaceIds, List<String> identifiers, String identifiersType, List<String> includedData, String locale, String sellerId, List<String> keywords, List<String> brandNames, List<String> classificationIds, Integer pageSize, String pageToken, String keywordsLocale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/catalog/2022-04-01/items".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/catalog/2022-04-01/items" : "/catalog/2022-04-01/items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (identifiers != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "identifiers", identifiers));
        }
        if (identifiersType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("identifiersType", identifiersType));
        }
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (includedData != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "includedData", includedData));
        }
        if (locale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("locale", locale));
        }
        if (sellerId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sellerId", sellerId));
        }
        if (keywords != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "keywords", keywords));
        }
        if (brandNames != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "brandNames", brandNames));
        }
        if (classificationIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "classificationIds", classificationIds));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageToken", pageToken));
        }
        if (keywordsLocale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("keywordsLocale", keywordsLocale));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call searchCatalogItemsValidateBeforeCall(List<String> marketplaceIds, List<String> identifiers, String identifiersType, List<String> includedData, String locale, String sellerId, List<String> keywords, List<String> brandNames, List<String> classificationIds, Integer pageSize, String pageToken, String keywordsLocale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling searchCatalogItems(Async)");
        }
        return this.searchCatalogItemsCall(marketplaceIds, identifiers, identifiersType, includedData, locale, sellerId, keywords, brandNames, classificationIds, pageSize, pageToken, keywordsLocale, progressRequestListener);
    }

    public ItemSearchResults searchCatalogItems(List<String> marketplaceIds, List<String> identifiers, String identifiersType, List<String> includedData, String locale, String sellerId, List<String> keywords, List<String> brandNames, List<String> classificationIds, Integer pageSize, String pageToken, String keywordsLocale, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ItemSearchResults> resp = this.searchCatalogItemsWithHttpInfo(marketplaceIds, identifiers, identifiersType, includedData, locale, sellerId, keywords, brandNames, classificationIds, pageSize, pageToken, keywordsLocale, restrictedDataToken);
        return resp.getData();
    }

    public ItemSearchResults searchCatalogItems(List<String> marketplaceIds, List<String> identifiers, String identifiersType, List<String> includedData, String locale, String sellerId, List<String> keywords, List<String> brandNames, List<String> classificationIds, Integer pageSize, String pageToken, String keywordsLocale) throws ApiException, LWAException {
        ApiResponse<ItemSearchResults> resp = this.searchCatalogItemsWithHttpInfo(marketplaceIds, identifiers, identifiersType, includedData, locale, sellerId, keywords, brandNames, classificationIds, pageSize, pageToken, keywordsLocale, null);
        return resp.getData();
    }

    public ApiResponse<ItemSearchResults> searchCatalogItemsWithHttpInfo(List<String> marketplaceIds, List<String> identifiers, String identifiersType, List<String> includedData, String locale, String sellerId, List<String> keywords, List<String> brandNames, List<String> classificationIds, Integer pageSize, String pageToken, String keywordsLocale, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.searchCatalogItemsValidateBeforeCall(marketplaceIds, identifiers, identifiersType, includedData, locale, sellerId, keywords, brandNames, classificationIds, pageSize, pageToken, keywordsLocale, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CatalogApi-searchCatalogItems");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.searchCatalogItemsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ItemSearchResults>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("searchCatalogItems operation exceeds rate limit");
    }

    public ApiResponse<ItemSearchResults> searchCatalogItemsWithHttpInfo(List<String> marketplaceIds, List<String> identifiers, String identifiersType, List<String> includedData, String locale, String sellerId, List<String> keywords, List<String> brandNames, List<String> classificationIds, Integer pageSize, String pageToken, String keywordsLocale) throws ApiException, LWAException {
        return this.searchCatalogItemsWithHttpInfo(marketplaceIds, identifiers, identifiersType, includedData, locale, sellerId, keywords, brandNames, classificationIds, pageSize, pageToken, keywordsLocale, null);
    }

    public Call searchCatalogItemsAsync(List<String> marketplaceIds, List<String> identifiers, String identifiersType, List<String> includedData, String locale, String sellerId, List<String> keywords, List<String> brandNames, List<String> classificationIds, Integer pageSize, String pageToken, String keywordsLocale, ApiCallback<ItemSearchResults> callback) throws ApiException, LWAException {
        return this.searchCatalogItemsAsync(marketplaceIds, identifiers, identifiersType, includedData, locale, sellerId, keywords, brandNames, classificationIds, pageSize, pageToken, keywordsLocale, callback, null);
    }

    public Call searchCatalogItemsAsync(List<String> marketplaceIds, List<String> identifiers, String identifiersType, List<String> includedData, String locale, String sellerId, List<String> keywords, List<String> brandNames, List<String> classificationIds, Integer pageSize, String pageToken, String keywordsLocale, ApiCallback<ItemSearchResults> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.searchCatalogItemsValidateBeforeCall(marketplaceIds, identifiers, identifiersType, includedData, locale, sellerId, keywords, brandNames, classificationIds, pageSize, pageToken, keywordsLocale, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CatalogApi-searchCatalogItems");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.searchCatalogItemsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ItemSearchResults>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("searchCatalogItems operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public CatalogApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new CatalogApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

