/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.awd.v2024_05_09;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.awd.v2024_05_09.InboundEligibility;
import software.amazon.spapi.models.awd.v2024_05_09.InboundOrder;
import software.amazon.spapi.models.awd.v2024_05_09.InboundOrderCreationData;
import software.amazon.spapi.models.awd.v2024_05_09.InboundOrderReference;
import software.amazon.spapi.models.awd.v2024_05_09.InboundPackages;
import software.amazon.spapi.models.awd.v2024_05_09.InboundShipment;
import software.amazon.spapi.models.awd.v2024_05_09.InventoryListing;
import software.amazon.spapi.models.awd.v2024_05_09.ShipmentLabels;
import software.amazon.spapi.models.awd.v2024_05_09.ShipmentListing;
import software.amazon.spapi.models.awd.v2024_05_09.TransportationDetails;

public class AwdApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket cancelInboundBucket = Bucket.builder().addLimit(this.config.getLimit("AwdApi-cancelInbound")).build();
    public final Bucket checkInboundEligibilityBucket = Bucket.builder().addLimit(this.config.getLimit("AwdApi-checkInboundEligibility")).build();
    public final Bucket confirmInboundBucket = Bucket.builder().addLimit(this.config.getLimit("AwdApi-confirmInbound")).build();
    public final Bucket createInboundBucket = Bucket.builder().addLimit(this.config.getLimit("AwdApi-createInbound")).build();
    public final Bucket getInboundBucket = Bucket.builder().addLimit(this.config.getLimit("AwdApi-getInbound")).build();
    public final Bucket getInboundShipmentBucket = Bucket.builder().addLimit(this.config.getLimit("AwdApi-getInboundShipment")).build();
    public final Bucket getInboundShipmentLabelsBucket = Bucket.builder().addLimit(this.config.getLimit("AwdApi-getInboundShipmentLabels")).build();
    public final Bucket listInboundShipmentsBucket = Bucket.builder().addLimit(this.config.getLimit("AwdApi-listInboundShipments")).build();
    public final Bucket listInventoryBucket = Bucket.builder().addLimit(this.config.getLimit("AwdApi-listInventory")).build();
    public final Bucket updateInboundBucket = Bucket.builder().addLimit(this.config.getLimit("AwdApi-updateInbound")).build();
    public final Bucket updateInboundShipmentTransportDetailsBucket = Bucket.builder().addLimit(this.config.getLimit("AwdApi-updateInboundShipmentTransportDetails")).build();

    public AwdApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call cancelInboundCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/awd/2024-05-09/inboundOrders/{orderId}/cancellation".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/awd/2024-05-09/inboundOrders/{orderId}/cancellation".replaceAll("\\{orderId\\}", orderId.toString()) : "/awd/2024-05-09/inboundOrders/{orderId}/cancellation".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call cancelInboundValidateBeforeCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelInbound(Async)");
        }
        return this.cancelInboundCall(orderId, progressRequestListener);
    }

    public void cancelInbound(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        this.cancelInboundWithHttpInfo(orderId, restrictedDataToken);
    }

    public void cancelInbound(String orderId) throws ApiException, LWAException {
        this.cancelInboundWithHttpInfo(orderId, null);
    }

    public ApiResponse<Void> cancelInboundWithHttpInfo(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.cancelInboundValidateBeforeCall(orderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-cancelInbound");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelInboundBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("cancelInbound operation exceeds rate limit");
    }

    public ApiResponse<Void> cancelInboundWithHttpInfo(String orderId) throws ApiException, LWAException {
        return this.cancelInboundWithHttpInfo(orderId, null);
    }

    public Call cancelInboundAsync(String orderId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.cancelInboundAsync(orderId, callback, null);
    }

    public Call cancelInboundAsync(String orderId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.cancelInboundValidateBeforeCall(orderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-cancelInbound");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelInboundBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("cancelInbound operation exceeds rate limit");
    }

    private Call checkInboundEligibilityCall(InboundPackages body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        InboundPackages localVarPostBody = body;
        String localVarPath = "/awd/2024-05-09/inboundEligibility".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/awd/2024-05-09/inboundEligibility" : "/awd/2024-05-09/inboundEligibility";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call checkInboundEligibilityValidateBeforeCall(InboundPackages body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling checkInboundEligibility(Async)");
        }
        return this.checkInboundEligibilityCall(body, progressRequestListener);
    }

    public InboundEligibility checkInboundEligibility(InboundPackages body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<InboundEligibility> resp = this.checkInboundEligibilityWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public InboundEligibility checkInboundEligibility(InboundPackages body) throws ApiException, LWAException {
        ApiResponse<InboundEligibility> resp = this.checkInboundEligibilityWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<InboundEligibility> checkInboundEligibilityWithHttpInfo(InboundPackages body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.checkInboundEligibilityValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-checkInboundEligibility");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.checkInboundEligibilityBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InboundEligibility>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("checkInboundEligibility operation exceeds rate limit");
    }

    public ApiResponse<InboundEligibility> checkInboundEligibilityWithHttpInfo(InboundPackages body) throws ApiException, LWAException {
        return this.checkInboundEligibilityWithHttpInfo(body, null);
    }

    public Call checkInboundEligibilityAsync(InboundPackages body, ApiCallback<InboundEligibility> callback) throws ApiException, LWAException {
        return this.checkInboundEligibilityAsync(body, callback, null);
    }

    public Call checkInboundEligibilityAsync(InboundPackages body, ApiCallback<InboundEligibility> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.checkInboundEligibilityValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-checkInboundEligibility");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.checkInboundEligibilityBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InboundEligibility>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("checkInboundEligibility operation exceeds rate limit");
    }

    private Call confirmInboundCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/awd/2024-05-09/inboundOrders/{orderId}/confirmation".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/awd/2024-05-09/inboundOrders/{orderId}/confirmation".replaceAll("\\{orderId\\}", orderId.toString()) : "/awd/2024-05-09/inboundOrders/{orderId}/confirmation".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call confirmInboundValidateBeforeCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling confirmInbound(Async)");
        }
        return this.confirmInboundCall(orderId, progressRequestListener);
    }

    public void confirmInbound(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        this.confirmInboundWithHttpInfo(orderId, restrictedDataToken);
    }

    public void confirmInbound(String orderId) throws ApiException, LWAException {
        this.confirmInboundWithHttpInfo(orderId, null);
    }

    public ApiResponse<Void> confirmInboundWithHttpInfo(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.confirmInboundValidateBeforeCall(orderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-confirmInbound");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.confirmInboundBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("confirmInbound operation exceeds rate limit");
    }

    public ApiResponse<Void> confirmInboundWithHttpInfo(String orderId) throws ApiException, LWAException {
        return this.confirmInboundWithHttpInfo(orderId, null);
    }

    public Call confirmInboundAsync(String orderId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.confirmInboundAsync(orderId, callback, null);
    }

    public Call confirmInboundAsync(String orderId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.confirmInboundValidateBeforeCall(orderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-confirmInbound");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.confirmInboundBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("confirmInbound operation exceeds rate limit");
    }

    private Call createInboundCall(InboundOrderCreationData body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        InboundOrderCreationData localVarPostBody = body;
        String localVarPath = "/awd/2024-05-09/inboundOrders".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/awd/2024-05-09/inboundOrders" : "/awd/2024-05-09/inboundOrders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createInboundValidateBeforeCall(InboundOrderCreationData body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createInbound(Async)");
        }
        return this.createInboundCall(body, progressRequestListener);
    }

    public InboundOrderReference createInbound(InboundOrderCreationData body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<InboundOrderReference> resp = this.createInboundWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public InboundOrderReference createInbound(InboundOrderCreationData body) throws ApiException, LWAException {
        ApiResponse<InboundOrderReference> resp = this.createInboundWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<InboundOrderReference> createInboundWithHttpInfo(InboundOrderCreationData body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createInboundValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-createInbound");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createInboundBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InboundOrderReference>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createInbound operation exceeds rate limit");
    }

    public ApiResponse<InboundOrderReference> createInboundWithHttpInfo(InboundOrderCreationData body) throws ApiException, LWAException {
        return this.createInboundWithHttpInfo(body, null);
    }

    public Call createInboundAsync(InboundOrderCreationData body, ApiCallback<InboundOrderReference> callback) throws ApiException, LWAException {
        return this.createInboundAsync(body, callback, null);
    }

    public Call createInboundAsync(InboundOrderCreationData body, ApiCallback<InboundOrderReference> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createInboundValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-createInbound");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createInboundBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InboundOrderReference>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createInbound operation exceeds rate limit");
    }

    private Call getInboundCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/awd/2024-05-09/inboundOrders/{orderId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/awd/2024-05-09/inboundOrders/{orderId}".replaceAll("\\{orderId\\}", orderId.toString()) : "/awd/2024-05-09/inboundOrders/{orderId}".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getInboundValidateBeforeCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getInbound(Async)");
        }
        return this.getInboundCall(orderId, progressRequestListener);
    }

    public InboundOrder getInbound(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<InboundOrder> resp = this.getInboundWithHttpInfo(orderId, restrictedDataToken);
        return resp.getData();
    }

    public InboundOrder getInbound(String orderId) throws ApiException, LWAException {
        ApiResponse<InboundOrder> resp = this.getInboundWithHttpInfo(orderId, null);
        return resp.getData();
    }

    public ApiResponse<InboundOrder> getInboundWithHttpInfo(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getInboundValidateBeforeCall(orderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-getInbound");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInboundBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InboundOrder>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getInbound operation exceeds rate limit");
    }

    public ApiResponse<InboundOrder> getInboundWithHttpInfo(String orderId) throws ApiException, LWAException {
        return this.getInboundWithHttpInfo(orderId, null);
    }

    public Call getInboundAsync(String orderId, ApiCallback<InboundOrder> callback) throws ApiException, LWAException {
        return this.getInboundAsync(orderId, callback, null);
    }

    public Call getInboundAsync(String orderId, ApiCallback<InboundOrder> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getInboundValidateBeforeCall(orderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-getInbound");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInboundBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InboundOrder>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getInbound operation exceeds rate limit");
    }

    private Call getInboundShipmentCall(String shipmentId, String skuQuantities, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/awd/2024-05-09/inboundShipments/{shipmentId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/awd/2024-05-09/inboundShipments/{shipmentId}".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/awd/2024-05-09/inboundShipments/{shipmentId}".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (skuQuantities != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skuQuantities", skuQuantities));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getInboundShipmentValidateBeforeCall(String shipmentId, String skuQuantities, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling getInboundShipment(Async)");
        }
        return this.getInboundShipmentCall(shipmentId, skuQuantities, progressRequestListener);
    }

    public InboundShipment getInboundShipment(String shipmentId, String skuQuantities, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<InboundShipment> resp = this.getInboundShipmentWithHttpInfo(shipmentId, skuQuantities, restrictedDataToken);
        return resp.getData();
    }

    public InboundShipment getInboundShipment(String shipmentId, String skuQuantities) throws ApiException, LWAException {
        ApiResponse<InboundShipment> resp = this.getInboundShipmentWithHttpInfo(shipmentId, skuQuantities, null);
        return resp.getData();
    }

    public ApiResponse<InboundShipment> getInboundShipmentWithHttpInfo(String shipmentId, String skuQuantities, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getInboundShipmentValidateBeforeCall(shipmentId, skuQuantities, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-getInboundShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInboundShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InboundShipment>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getInboundShipment operation exceeds rate limit");
    }

    public ApiResponse<InboundShipment> getInboundShipmentWithHttpInfo(String shipmentId, String skuQuantities) throws ApiException, LWAException {
        return this.getInboundShipmentWithHttpInfo(shipmentId, skuQuantities, null);
    }

    public Call getInboundShipmentAsync(String shipmentId, String skuQuantities, ApiCallback<InboundShipment> callback) throws ApiException, LWAException {
        return this.getInboundShipmentAsync(shipmentId, skuQuantities, callback, null);
    }

    public Call getInboundShipmentAsync(String shipmentId, String skuQuantities, ApiCallback<InboundShipment> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getInboundShipmentValidateBeforeCall(shipmentId, skuQuantities, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-getInboundShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInboundShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InboundShipment>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getInboundShipment operation exceeds rate limit");
    }

    private Call getInboundShipmentLabelsCall(String shipmentId, String pageType, String formatType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/awd/2024-05-09/inboundShipments/{shipmentId}/labels".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/awd/2024-05-09/inboundShipments/{shipmentId}/labels".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/awd/2024-05-09/inboundShipments/{shipmentId}/labels".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageType", pageType));
        }
        if (formatType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("formatType", formatType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getInboundShipmentLabelsValidateBeforeCall(String shipmentId, String pageType, String formatType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling getInboundShipmentLabels(Async)");
        }
        return this.getInboundShipmentLabelsCall(shipmentId, pageType, formatType, progressRequestListener);
    }

    public ShipmentLabels getInboundShipmentLabels(String shipmentId, String pageType, String formatType, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ShipmentLabels> resp = this.getInboundShipmentLabelsWithHttpInfo(shipmentId, pageType, formatType, restrictedDataToken);
        return resp.getData();
    }

    public ShipmentLabels getInboundShipmentLabels(String shipmentId, String pageType, String formatType) throws ApiException, LWAException {
        ApiResponse<ShipmentLabels> resp = this.getInboundShipmentLabelsWithHttpInfo(shipmentId, pageType, formatType, null);
        return resp.getData();
    }

    public ApiResponse<ShipmentLabels> getInboundShipmentLabelsWithHttpInfo(String shipmentId, String pageType, String formatType, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getInboundShipmentLabelsValidateBeforeCall(shipmentId, pageType, formatType, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-getInboundShipmentLabels");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInboundShipmentLabelsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ShipmentLabels>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getInboundShipmentLabels operation exceeds rate limit");
    }

    public ApiResponse<ShipmentLabels> getInboundShipmentLabelsWithHttpInfo(String shipmentId, String pageType, String formatType) throws ApiException, LWAException {
        return this.getInboundShipmentLabelsWithHttpInfo(shipmentId, pageType, formatType, null);
    }

    public Call getInboundShipmentLabelsAsync(String shipmentId, String pageType, String formatType, ApiCallback<ShipmentLabels> callback) throws ApiException, LWAException {
        return this.getInboundShipmentLabelsAsync(shipmentId, pageType, formatType, callback, null);
    }

    public Call getInboundShipmentLabelsAsync(String shipmentId, String pageType, String formatType, ApiCallback<ShipmentLabels> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getInboundShipmentLabelsValidateBeforeCall(shipmentId, pageType, formatType, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-getInboundShipmentLabels");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInboundShipmentLabelsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ShipmentLabels>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getInboundShipmentLabels operation exceeds rate limit");
    }

    private Call listInboundShipmentsCall(String sortBy, String sortOrder, String shipmentStatus, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, Integer maxResults, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/awd/2024-05-09/inboundShipments".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/awd/2024-05-09/inboundShipments" : "/awd/2024-05-09/inboundShipments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (shipmentStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipmentStatus", shipmentStatus));
        }
        if (updatedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("updatedAfter", updatedAfter));
        }
        if (updatedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("updatedBefore", updatedBefore));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listInboundShipmentsValidateBeforeCall(String sortBy, String sortOrder, String shipmentStatus, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, Integer maxResults, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.listInboundShipmentsCall(sortBy, sortOrder, shipmentStatus, updatedAfter, updatedBefore, maxResults, nextToken, progressRequestListener);
    }

    public ShipmentListing listInboundShipments(String sortBy, String sortOrder, String shipmentStatus, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, Integer maxResults, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ShipmentListing> resp = this.listInboundShipmentsWithHttpInfo(sortBy, sortOrder, shipmentStatus, updatedAfter, updatedBefore, maxResults, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public ShipmentListing listInboundShipments(String sortBy, String sortOrder, String shipmentStatus, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, Integer maxResults, String nextToken) throws ApiException, LWAException {
        ApiResponse<ShipmentListing> resp = this.listInboundShipmentsWithHttpInfo(sortBy, sortOrder, shipmentStatus, updatedAfter, updatedBefore, maxResults, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<ShipmentListing> listInboundShipmentsWithHttpInfo(String sortBy, String sortOrder, String shipmentStatus, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, Integer maxResults, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listInboundShipmentsValidateBeforeCall(sortBy, sortOrder, shipmentStatus, updatedAfter, updatedBefore, maxResults, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-listInboundShipments");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listInboundShipmentsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ShipmentListing>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listInboundShipments operation exceeds rate limit");
    }

    public ApiResponse<ShipmentListing> listInboundShipmentsWithHttpInfo(String sortBy, String sortOrder, String shipmentStatus, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, Integer maxResults, String nextToken) throws ApiException, LWAException {
        return this.listInboundShipmentsWithHttpInfo(sortBy, sortOrder, shipmentStatus, updatedAfter, updatedBefore, maxResults, nextToken, null);
    }

    public Call listInboundShipmentsAsync(String sortBy, String sortOrder, String shipmentStatus, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, Integer maxResults, String nextToken, ApiCallback<ShipmentListing> callback) throws ApiException, LWAException {
        return this.listInboundShipmentsAsync(sortBy, sortOrder, shipmentStatus, updatedAfter, updatedBefore, maxResults, nextToken, callback, null);
    }

    public Call listInboundShipmentsAsync(String sortBy, String sortOrder, String shipmentStatus, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, Integer maxResults, String nextToken, ApiCallback<ShipmentListing> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listInboundShipmentsValidateBeforeCall(sortBy, sortOrder, shipmentStatus, updatedAfter, updatedBefore, maxResults, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-listInboundShipments");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listInboundShipmentsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ShipmentListing>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listInboundShipments operation exceeds rate limit");
    }

    private Call listInventoryCall(String sku, String sortOrder, String details, String nextToken, Integer maxResults, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/awd/2024-05-09/inventory".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/awd/2024-05-09/inventory" : "/awd/2024-05-09/inventory";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sku != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sku", sku));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (details != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("details", details));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listInventoryValidateBeforeCall(String sku, String sortOrder, String details, String nextToken, Integer maxResults, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.listInventoryCall(sku, sortOrder, details, nextToken, maxResults, progressRequestListener);
    }

    public InventoryListing listInventory(String sku, String sortOrder, String details, String nextToken, Integer maxResults, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<InventoryListing> resp = this.listInventoryWithHttpInfo(sku, sortOrder, details, nextToken, maxResults, restrictedDataToken);
        return resp.getData();
    }

    public InventoryListing listInventory(String sku, String sortOrder, String details, String nextToken, Integer maxResults) throws ApiException, LWAException {
        ApiResponse<InventoryListing> resp = this.listInventoryWithHttpInfo(sku, sortOrder, details, nextToken, maxResults, null);
        return resp.getData();
    }

    public ApiResponse<InventoryListing> listInventoryWithHttpInfo(String sku, String sortOrder, String details, String nextToken, Integer maxResults, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listInventoryValidateBeforeCall(sku, sortOrder, details, nextToken, maxResults, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-listInventory");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listInventoryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InventoryListing>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listInventory operation exceeds rate limit");
    }

    public ApiResponse<InventoryListing> listInventoryWithHttpInfo(String sku, String sortOrder, String details, String nextToken, Integer maxResults) throws ApiException, LWAException {
        return this.listInventoryWithHttpInfo(sku, sortOrder, details, nextToken, maxResults, null);
    }

    public Call listInventoryAsync(String sku, String sortOrder, String details, String nextToken, Integer maxResults, ApiCallback<InventoryListing> callback) throws ApiException, LWAException {
        return this.listInventoryAsync(sku, sortOrder, details, nextToken, maxResults, callback, null);
    }

    public Call listInventoryAsync(String sku, String sortOrder, String details, String nextToken, Integer maxResults, ApiCallback<InventoryListing> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listInventoryValidateBeforeCall(sku, sortOrder, details, nextToken, maxResults, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-listInventory");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listInventoryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<InventoryListing>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listInventory operation exceeds rate limit");
    }

    private Call updateInboundCall(InboundOrder body, String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        InboundOrder localVarPostBody = body;
        String localVarPath = "/awd/2024-05-09/inboundOrders/{orderId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/awd/2024-05-09/inboundOrders/{orderId}".replaceAll("\\{orderId\\}", orderId.toString()) : "/awd/2024-05-09/inboundOrders/{orderId}".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call updateInboundValidateBeforeCall(InboundOrder body, String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateInbound(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling updateInbound(Async)");
        }
        return this.updateInboundCall(body, orderId, progressRequestListener);
    }

    public void updateInbound(InboundOrder body, String orderId, String restrictedDataToken) throws ApiException, LWAException {
        this.updateInboundWithHttpInfo(body, orderId, restrictedDataToken);
    }

    public void updateInbound(InboundOrder body, String orderId) throws ApiException, LWAException {
        this.updateInboundWithHttpInfo(body, orderId, null);
    }

    public ApiResponse<Void> updateInboundWithHttpInfo(InboundOrder body, String orderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.updateInboundValidateBeforeCall(body, orderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-updateInbound");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateInboundBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("updateInbound operation exceeds rate limit");
    }

    public ApiResponse<Void> updateInboundWithHttpInfo(InboundOrder body, String orderId) throws ApiException, LWAException {
        return this.updateInboundWithHttpInfo(body, orderId, null);
    }

    public Call updateInboundAsync(InboundOrder body, String orderId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.updateInboundAsync(body, orderId, callback, null);
    }

    public Call updateInboundAsync(InboundOrder body, String orderId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.updateInboundValidateBeforeCall(body, orderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-updateInbound");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateInboundBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("updateInbound operation exceeds rate limit");
    }

    private Call updateInboundShipmentTransportDetailsCall(TransportationDetails body, String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        TransportationDetails localVarPostBody = body;
        String localVarPath = "/awd/2024-05-09/inboundShipments/{shipmentId}/transport".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/awd/2024-05-09/inboundShipments/{shipmentId}/transport".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/awd/2024-05-09/inboundShipments/{shipmentId}/transport".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call updateInboundShipmentTransportDetailsValidateBeforeCall(TransportationDetails body, String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateInboundShipmentTransportDetails(Async)");
        }
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling updateInboundShipmentTransportDetails(Async)");
        }
        return this.updateInboundShipmentTransportDetailsCall(body, shipmentId, progressRequestListener);
    }

    public void updateInboundShipmentTransportDetails(TransportationDetails body, String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        this.updateInboundShipmentTransportDetailsWithHttpInfo(body, shipmentId, restrictedDataToken);
    }

    public void updateInboundShipmentTransportDetails(TransportationDetails body, String shipmentId) throws ApiException, LWAException {
        this.updateInboundShipmentTransportDetailsWithHttpInfo(body, shipmentId, null);
    }

    public ApiResponse<Void> updateInboundShipmentTransportDetailsWithHttpInfo(TransportationDetails body, String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.updateInboundShipmentTransportDetailsValidateBeforeCall(body, shipmentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-updateInboundShipmentTransportDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateInboundShipmentTransportDetailsBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("updateInboundShipmentTransportDetails operation exceeds rate limit");
    }

    public ApiResponse<Void> updateInboundShipmentTransportDetailsWithHttpInfo(TransportationDetails body, String shipmentId) throws ApiException, LWAException {
        return this.updateInboundShipmentTransportDetailsWithHttpInfo(body, shipmentId, null);
    }

    public Call updateInboundShipmentTransportDetailsAsync(TransportationDetails body, String shipmentId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.updateInboundShipmentTransportDetailsAsync(body, shipmentId, callback, null);
    }

    public Call updateInboundShipmentTransportDetailsAsync(TransportationDetails body, String shipmentId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.updateInboundShipmentTransportDetailsValidateBeforeCall(body, shipmentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AwdApi-updateInboundShipmentTransportDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateInboundShipmentTransportDetailsBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("updateInboundShipmentTransportDetails operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public AwdApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new AwdApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

