/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.SellingPartnerAPIAA;

import java.util.Arrays;
import java.util.List;
import okhttp3.Request;

public class RestrictedDataTokenSigner {
    public static Request sign(Request request, String restrictedDataToken, String operationName) {
        boolean isRestricted = RestrictedDataTokenSigner.isRestrictedOperation(operationName);
        if (!isRestricted) {
            throw new IllegalArgumentException("Operation '" + operationName + "' does not require a Restricted Data Token (RDT). Remove the RDT parameter for non-restricted operations.");
        }
        return request.newBuilder().header("x-amz-access-token", restrictedDataToken).build();
    }

    private static boolean isRestrictedOperation(String operationName) {
        List<String> restrictedOperations = Arrays.asList("VendorOrdersApi-getOrders", "VendorOrdersApi-getOrder", "VendorShippingLabelsApi-getShippingLabel", "VendorShippingLabelsApi-getShippingLabels", "VendorShippingApi-getPackingSlips", "VendorShippingApi-getPackingSlip", "VendorShippingLabelsApi-getCustomerInvoice", "VendorShippingLabelsApi-getCustomerInvoices", "VendorShippingLabelsApi-createShippingLabels", "EasyShipApi-createScheduledPackageBulk", "OrdersV0Api-getOrders", "OrdersV0Api-getOrder", "OrdersV0Api-getOrderBuyerInfo", "OrdersV0Api-getOrderAddress", "OrdersV0Api-getOrderItems", "OrdersV0Api-getOrderItemsBuyerInfo", "OrdersV0Api-getOrderRegulatedInfo", "MerchantFulfillmentApi-getShipment", "MerchantFulfillmentApi-cancelShipment", "MerchantFulfillmentApi-createShipment", "ShipmentInvoiceApi-getShipmentDetails", "ReportsApi-getReportDocument");
        return restrictedOperations.contains(operationName);
    }
}

