/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.admin;

import com.rabbitmq.http.client.Client;
import com.rabbitmq.http.client.domain.BindingInfo;
import com.rabbitmq.http.client.domain.QueueInfo;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.BindingCleaner;
import org.springframework.cloud.stream.binder.rabbit.admin.RabbitAdminException;

public class RabbitBindingCleaner
implements BindingCleaner {
    private static final Log logger = LogFactory.getLog(RabbitBindingCleaner.class);
    private static final String PREFIX_DELIMITER = ".";
    public static final String BINDER_PREFIX = "binder.";

    public Map<String, List<String>> clean(String entity, boolean isJob) {
        return this.clean("http://localhost:15672/api", "guest", "guest", "/", BINDER_PREFIX, entity, isJob);
    }

    public Map<String, List<String>> clean(String adminUri, String user, String pw, String vhost, String binderPrefix, String entity, boolean isJob) {
        try {
            Client client = new Client(adminUri, user, pw);
            return this.doClean(client, vhost == null ? "/" : vhost, binderPrefix == null ? BINDER_PREFIX : binderPrefix, entity, isJob);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RabbitAdminException("Couldn't create a Client", e);
        }
    }

    private Map<String, List<String>> doClean(Client client, String vhost, String binderPrefix, String entity, boolean isJob) {
        LinkedList<String> removedQueues = isJob ? null : this.findStreamQueues(client, vhost, binderPrefix, entity);
        List<String> removedExchanges = this.findExchanges(client, vhost, binderPrefix, entity);
        if (removedQueues != null) {
            removedQueues.descendingIterator().forEachRemaining(q -> {
                client.deleteQueue(vhost, q);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("deleted queue: " + q));
                }
            });
        }
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        if (removedQueues.size() > 0) {
            results.put("queues", removedQueues);
        }
        removedExchanges.forEach(exchange -> {
            client.deleteExchange(vhost, exchange);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("deleted exchange: " + exchange));
            }
        });
        if (removedExchanges.size() > 0) {
            results.put("exchanges", removedExchanges);
        }
        return results;
    }

    private LinkedList<String> findStreamQueues(Client client, String vhost, String binderPrefix, String stream) {
        String queueNamePrefix = this.adjustPrefix(AbstractBinder.applyPrefix((String)binderPrefix, (String)stream));
        List queues = client.getQueues(vhost);
        return queues.stream().filter(q -> q.getName().startsWith(queueNamePrefix)).map(q -> this.checkNoConsumers((QueueInfo)q)).collect(Collectors.toCollection(LinkedList::new));
    }

    private String adjustPrefix(String prefix) {
        if (prefix.endsWith("*")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix + PREFIX_DELIMITER;
    }

    private String checkNoConsumers(QueueInfo queue) {
        if (queue.getConsumerCount() != 0L) {
            throw new RabbitAdminException("Queue " + queue.getName() + " is in use");
        }
        return queue.getName();
    }

    private List<String> findExchanges(Client client, String vhost, String binderPrefix, String entity) {
        List exchanges = client.getExchanges(vhost);
        String exchangeNamePrefix = this.adjustPrefix(AbstractBinder.applyPrefix((String)binderPrefix, (String)entity));
        List<String> exchangesToRemove = exchanges.stream().filter(e -> e.getName().startsWith(exchangeNamePrefix)).map(e -> {
            System.out.println(e.getName());
            List bindingsBySource = client.getBindingsBySource(vhost, e.getName());
            return Collections.singletonMap(e.getName(), bindingsBySource);
        }).map(bindingsMap -> this.hasNoForeignBindings((Map<String, List<BindingInfo>>)bindingsMap, exchangeNamePrefix)).collect(Collectors.toList());
        exchangesToRemove.stream().map(exchange -> client.getExchangeBindingsByDestination(vhost, exchange)).forEach(bindings -> {
            if (bindings.size() > 0) {
                throw new RabbitAdminException("Cannot delete exchange " + ((BindingInfo)bindings.get(0)).getDestination() + "; it is a destination: " + bindings);
            }
        });
        return exchangesToRemove;
    }

    private String hasNoForeignBindings(Map<String, List<BindingInfo>> bindings, String exchangeNamePrefix) {
        Map.Entry<String, List<BindingInfo>> next = bindings.entrySet().iterator().next();
        for (BindingInfo binding : next.getValue()) {
            if ("queue".equals(binding.getDestinationType()) && binding.getDestination().startsWith(exchangeNamePrefix)) continue;
            throw new RabbitAdminException("Cannot delete exchange " + next.getKey() + "; it has bindings: " + bindings);
        }
        return next.getKey();
    }
}

